/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public class PostScriptTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(PostScriptTable.class);
    private float formatType;
    private float italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private long isFixedPitch;
    private long minMemType42;
    private long maxMemType42;
    private long mimMemType1;
    private long maxMemType1;
    private String[] glyphNames = null;
    public static final String TAG = "post";

    PostScriptTable() {
    }

    @Override
    void read(TrueTypeFont object, TTFDataStream tTFDataStream) {
        this.formatType = tTFDataStream.read32Fixed();
        this.italicAngle = tTFDataStream.read32Fixed();
        this.underlinePosition = tTFDataStream.readSignedShort();
        this.underlineThickness = tTFDataStream.readSignedShort();
        this.isFixedPitch = tTFDataStream.readUnsignedInt();
        this.minMemType42 = tTFDataStream.readUnsignedInt();
        this.maxMemType42 = tTFDataStream.readUnsignedInt();
        this.mimMemType1 = tTFDataStream.readUnsignedInt();
        this.maxMemType1 = tTFDataStream.readUnsignedInt();
        if (Float.compare(this.formatType, 1.0f) == 0) {
            this.glyphNames = WGL4Names.getAllNames();
        } else if (Float.compare(this.formatType, 2.0f) == 0) {
            int n;
            int n2 = tTFDataStream.readUnsignedShort();
            int[] nArray = new int[n2];
            this.glyphNames = new String[n2];
            int n3 = Integer.MIN_VALUE;
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n = tTFDataStream.readUnsignedShort();
                if (n > Short.MAX_VALUE) continue;
                n3 = Math.max(n3, n);
            }
            String[] stringArray = null;
            if (n3 >= 258) {
                stringArray = new String[n3 - 258 + 1];
                for (n = 0; n < stringArray.length; ++n) {
                    n3 = tTFDataStream.readUnsignedByte();
                    try {
                        stringArray[n] = tTFDataStream.readString(n3);
                        continue;
                    }
                    catch (IOException iOException) {
                        LOG.warn((Object)("Error reading names in PostScript table at entry " + n + " of " + stringArray.length + ", setting remaining entries to .notdef"), (Throwable)iOException);
                        for (int i = n; i < stringArray.length; ++i) {
                            stringArray[i] = ".notdef";
                        }
                        break;
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                n3 = nArray[n];
                this.glyphNames[n] = n3 >= 0 && n3 < 258 ? WGL4Names.getGlyphName(n3) : (n3 >= 258 && n3 <= Short.MAX_VALUE && stringArray != null ? stringArray[n3 - 258] : ".undefined");
            }
        } else if (Float.compare(this.formatType, 2.5f) == 0) {
            Object object2;
            object = new int[((TrueTypeFont)object).getNumberOfGlyphs()];
            int n = 0;
            while (n < ((Object)object).length) {
                object2 = tTFDataStream.readSignedByte();
                int n4 = n++;
                object[n4] = n4 + 1 + object2;
            }
            this.glyphNames = new String[((Object)object).length];
            for (n = 0; n < this.glyphNames.length; ++n) {
                Object object3 = object[n];
                object2 = object3;
                if (object3 >= 0 && object2 < 258) {
                    String string = WGL4Names.getGlyphName(object2);
                    if (string == null) continue;
                    this.glyphNames[n] = string;
                    continue;
                }
                LOG.debug((Object)("incorrect glyph name index " + object2 + ", valid numbers 0..258"));
            }
        } else if (Float.compare(this.formatType, 3.0f) == 0) {
            LOG.debug((Object)("No PostScript name information is provided for the font " + ((TrueTypeFont)object).getName()));
        }
        this.initialized = true;
    }

    public float getFormatType() {
        return this.formatType;
    }

    public void setFormatType(float f2) {
        this.formatType = f2;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(long l) {
        this.isFixedPitch = l;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float f2) {
        this.italicAngle = f2;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(long l) {
        this.maxMemType1 = l;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(long l) {
        this.maxMemType42 = l;
    }

    public long getMinMemType1() {
        return this.mimMemType1;
    }

    public void setMimMemType1(long l) {
        this.mimMemType1 = l;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(long l) {
        this.minMemType42 = l;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short s) {
        this.underlinePosition = s;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short s) {
        this.underlineThickness = s;
    }

    public String[] getGlyphNames() {
        return this.glyphNames;
    }

    public void setGlyphNames(String[] stringArray) {
        this.glyphNames = stringArray;
    }

    public String getName(int n) {
        if (n < 0 || this.glyphNames == null || n >= this.glyphNames.length) {
            return null;
        }
        return this.glyphNames[n];
    }
}

