/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.a.d.e;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphSubstitutionTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;

public class TTFParser {
    private static final Log LOG = LogFactory.getLog(TTFParser.class);
    private boolean isEmbedded = false;

    public TTFParser() {
        this(false);
    }

    public TTFParser(boolean bl) {
        this.isEmbedded = bl;
    }

    public TrueTypeFont parse(e e2) {
        RandomAccessReadDataStream randomAccessReadDataStream = new RandomAccessReadDataStream(e2);
        try {
            TrueTypeFont trueTypeFont = this.parse(randomAccessReadDataStream);
            return trueTypeFont;
        }
        catch (IOException iOException) {
            randomAccessReadDataStream.close();
            throw iOException;
        }
        finally {
            e2.close();
        }
    }

    public TrueTypeFont parseEmbedded(InputStream inputStream) {
        this.isEmbedded = true;
        RandomAccessReadDataStream randomAccessReadDataStream = new RandomAccessReadDataStream(inputStream);
        try {
            TrueTypeFont trueTypeFont = this.parse(randomAccessReadDataStream);
            return trueTypeFont;
        }
        catch (IOException iOException) {
            randomAccessReadDataStream.close();
            throw iOException;
        }
        finally {
            inputStream.close();
        }
    }

    TrueTypeFont parse(TTFDataStream tTFDataStream) {
        TrueTypeFont trueTypeFont = this.newFont(tTFDataStream);
        trueTypeFont.setVersion(tTFDataStream.read32Fixed());
        int n = tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        tTFDataStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            TTFTable tTFTable = this.readTableDirectory(tTFDataStream);
            if (tTFTable == null) continue;
            if (tTFTable.getOffset() + tTFTable.getLength() > trueTypeFont.getOriginalDataSize()) {
                LOG.warn((Object)("Skip table '" + tTFTable.getTag() + "' which goes past the file size; offset: " + tTFTable.getOffset() + ", size: " + tTFTable.getLength() + ", font size: " + trueTypeFont.getOriginalDataSize()));
                continue;
            }
            trueTypeFont.addTable(tTFTable);
        }
        this.parseTables(trueTypeFont);
        return trueTypeFont;
    }

    TrueTypeFont newFont(TTFDataStream tTFDataStream) {
        return new TrueTypeFont(tTFDataStream);
    }

    private void parseTables(TrueTypeFont trueTypeFont) {
        for (TTFTable tTFTable : trueTypeFont.getTables()) {
            if (tTFTable.getInitialized()) continue;
            trueTypeFont.readTable(tTFTable);
        }
        boolean bl = trueTypeFont.tables.containsKey("CFF ");
        boolean bl2 = trueTypeFont instanceof OpenTypeFont;
        bl = bl2 ? ((OpenTypeFont)trueTypeFont).isPostScript() : bl;
        TTFTable tTFTable = trueTypeFont.getHeader();
        if (tTFTable == null) {
            throw new IOException("'head' table is mandatory");
        }
        tTFTable = trueTypeFont.getHorizontalHeader();
        if (tTFTable == null) {
            throw new IOException("'hhea' table is mandatory");
        }
        tTFTable = trueTypeFont.getMaximumProfile();
        if (tTFTable == null) {
            throw new IOException("'maxp' table is mandatory");
        }
        tTFTable = trueTypeFont.getPostScript();
        if (tTFTable == null && !this.isEmbedded) {
            throw new IOException("'post' table is mandatory");
        }
        if (!bl) {
            if (trueTypeFont.getIndexToLocation() == null) {
                throw new IOException("'loca' table is mandatory");
            }
            if (trueTypeFont.getGlyph() == null) {
                throw new IOException("'glyf' table is mandatory");
            }
        } else if (!bl2) {
            throw new IOException("True Type fonts using CFF outlines are not supported");
        }
        if (trueTypeFont.getNaming() == null && !this.isEmbedded) {
            throw new IOException("'name' table is mandatory");
        }
        if (trueTypeFont.getHorizontalMetrics() == null) {
            throw new IOException("'hmtx' table is mandatory");
        }
        if (!this.isEmbedded && trueTypeFont.getCmap() == null) {
            throw new IOException("'cmap' table is mandatory");
        }
    }

    protected boolean allowCFF() {
        return false;
    }

    private TTFTable readTableDirectory(TTFDataStream tTFDataStream) {
        Object object;
        String string = tTFDataStream.readString(4);
        switch (string) {
            case "cmap": {
                object = new CmapTable();
                break;
            }
            case "glyf": {
                object = new GlyphTable();
                break;
            }
            case "head": {
                object = new HeaderTable();
                break;
            }
            case "hhea": {
                object = new HorizontalHeaderTable();
                break;
            }
            case "hmtx": {
                object = new HorizontalMetricsTable();
                break;
            }
            case "loca": {
                object = new IndexToLocationTable();
                break;
            }
            case "maxp": {
                object = new MaximumProfileTable();
                break;
            }
            case "name": {
                object = new NamingTable();
                break;
            }
            case "OS/2": {
                object = new OS2WindowsMetricsTable();
                break;
            }
            case "post": {
                object = new PostScriptTable();
                break;
            }
            case "DSIG": {
                object = new DigitalSignatureTable();
                break;
            }
            case "kern": {
                object = new KerningTable();
                break;
            }
            case "vhea": {
                object = new VerticalHeaderTable();
                break;
            }
            case "vmtx": {
                object = new VerticalMetricsTable();
                break;
            }
            case "VORG": {
                object = new VerticalOriginTable();
                break;
            }
            case "GSUB": {
                object = new GlyphSubstitutionTable();
                break;
            }
            default: {
                object = this.readTable(string);
            }
        }
        ((TTFTable)object).setTag(string);
        ((TTFTable)object).setCheckSum(tTFDataStream.readUnsignedInt());
        ((TTFTable)object).setOffset(tTFDataStream.readUnsignedInt());
        ((TTFTable)object).setLength(tTFDataStream.readUnsignedInt());
        if (((TTFTable)object).getLength() == 0L && !string.equals("glyf")) {
            return null;
        }
        return object;
    }

    protected TTFTable readTable(String string) {
        return new TTFTable();
    }
}

