/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public final class TTFSubsetter {
    private static final Log LOG = LogFactory.getLog(TTFSubsetter.class);
    private static final byte[] PAD_BUF = new byte[]{0, 0, 0};
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private final TrueTypeFont ttf;
    private final CmapLookup unicodeCmap;
    private final SortedMap<Integer, Integer> uniToGID;
    private final List<String> keepTables;
    private final SortedSet<Integer> glyphIds;
    private String prefix;
    private boolean hasAddedCompoundReferences;

    public TTFSubsetter(TrueTypeFont trueTypeFont) {
        this(trueTypeFont, null);
    }

    public TTFSubsetter(TrueTypeFont trueTypeFont, List<String> list) {
        this.ttf = trueTypeFont;
        this.keepTables = list;
        this.uniToGID = new TreeMap<Integer, Integer>();
        this.glyphIds = new TreeSet<Integer>();
        this.unicodeCmap = trueTypeFont.getUnicodeCmapLookup();
        this.glyphIds.add(0);
    }

    public final void setPrefix(String string) {
        this.prefix = string;
    }

    public final void add(int n) {
        int n2 = this.unicodeCmap.getGlyphId(n);
        if (n2 != 0) {
            this.uniToGID.put(n, n2);
            this.glyphIds.add(n2);
        }
    }

    public final void addAll(Set<Integer> set) {
        set.forEach(this::add);
    }

    public final Map<Integer, Integer> getGIDMap() {
        this.addCompoundReferences();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        Iterator iterator = this.glyphIds.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            hashMap.put(n, n2);
            ++n;
        }
        return hashMap;
    }

    private long writeFileHeader(DataOutputStream dataOutputStream, int n) {
        dataOutputStream.writeInt(65536);
        dataOutputStream.writeShort(n);
        int n2 = Integer.highestOneBit(n);
        int n3 = n2 << 4;
        dataOutputStream.writeShort(n3);
        n2 = this.log2(n2);
        dataOutputStream.writeShort(n2);
        int n4 = n * 16 - n3;
        dataOutputStream.writeShort(n4);
        return 65536L + this.toUInt32(n, n3) + this.toUInt32(n2, n4);
    }

    private long writeTableHeader(DataOutputStream dataOutputStream, String string, long l, byte[] byArray) {
        long l2 = 0L;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            l2 += ((long)byArray[i] & 0xFFL) << 24 - (i % 4 << 3);
        }
        byte[] byArray2 = string.getBytes(StandardCharsets.US_ASCII);
        dataOutputStream.write(byArray2, 0, 4);
        dataOutputStream.writeInt((int)(l2 &= 0xFFFFFFFFL));
        dataOutputStream.writeInt((int)l);
        dataOutputStream.writeInt(byArray.length);
        return this.toUInt32(byArray2) + l2 + l2 + l + (long)byArray.length;
    }

    private void writeTableBody(OutputStream outputStream, byte[] byArray) {
        int n = byArray.length;
        outputStream.write(byArray);
        if (n % 4 != 0) {
            outputStream.write(PAD_BUF, 0, 4 - n % 4);
        }
    }

    private byte[] buildHeadTable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        HeaderTable headerTable = this.ttf.getHeader();
        this.writeFixed(dataOutputStream, headerTable.getVersion());
        this.writeFixed(dataOutputStream, headerTable.getFontRevision());
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, headerTable.getMagicNumber());
        this.writeUint16(dataOutputStream, headerTable.getFlags());
        this.writeUint16(dataOutputStream, headerTable.getUnitsPerEm());
        this.writeLongDateTime(dataOutputStream, headerTable.getCreated());
        this.writeLongDateTime(dataOutputStream, headerTable.getModified());
        this.writeSInt16(dataOutputStream, headerTable.getXMin());
        this.writeSInt16(dataOutputStream, headerTable.getYMin());
        this.writeSInt16(dataOutputStream, headerTable.getXMax());
        this.writeSInt16(dataOutputStream, headerTable.getYMax());
        this.writeUint16(dataOutputStream, headerTable.getMacStyle());
        this.writeUint16(dataOutputStream, headerTable.getLowestRecPPEM());
        this.writeSInt16(dataOutputStream, headerTable.getFontDirectionHint());
        this.writeSInt16(dataOutputStream, (short)1);
        this.writeSInt16(dataOutputStream, headerTable.getGlyphDataFormat());
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildHheaTable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        HorizontalHeaderTable horizontalHeaderTable = this.ttf.getHorizontalHeader();
        this.writeFixed(dataOutputStream, horizontalHeaderTable.getVersion());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getAscender());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getDescender());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getLineGap());
        this.writeUint16(dataOutputStream, horizontalHeaderTable.getAdvanceWidthMax());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMinLeftSideBearing());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMinRightSideBearing());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getXMaxExtent());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getCaretSlopeRise());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getCaretSlopeRun());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved1());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved2());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved3());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved4());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getReserved5());
        this.writeSInt16(dataOutputStream, horizontalHeaderTable.getMetricDataFormat());
        int n = this.glyphIds.subSet(0, horizontalHeaderTable.getNumberOfHMetrics()).size();
        if (this.glyphIds.last() >= horizontalHeaderTable.getNumberOfHMetrics() && !this.glyphIds.contains(horizontalHeaderTable.getNumberOfHMetrics() - 1)) {
            ++n;
        }
        this.writeUint16(dataOutputStream, n);
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private boolean shouldCopyNameRecord(NameRecord nameRecord) {
        return nameRecord.getPlatformId() == 3 && nameRecord.getPlatformEncodingId() == 1 && nameRecord.getLanguageId() == 1033 && nameRecord.getNameId() >= 0 && nameRecord.getNameId() < 7;
    }

    private byte[] buildNameTable() {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Object object3 = this.ttf.getNaming();
        if (object3 == null || this.keepTables != null && !this.keepTables.contains("name")) {
            return null;
        }
        object3 = ((NamingTable)object3).getNameRecords();
        int n = (int)object3.stream().filter(this::shouldCopyNameRecord).count();
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, n);
        this.writeUint16(dataOutputStream, 6 + n * 12);
        if (n == 0) {
            return null;
        }
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (NameRecord)iterator.next();
            if (!this.shouldCopyNameRecord((NameRecord)object2)) continue;
            int n3 = ((NameRecord)object2).getPlatformId();
            int n4 = ((NameRecord)object2).getPlatformEncodingId();
            Charset charset = StandardCharsets.ISO_8859_1;
            if (n3 == 3 && n4 == 1) {
                charset = StandardCharsets.UTF_16BE;
            } else if (n3 == 2) {
                if (n4 == 0) {
                    charset = StandardCharsets.US_ASCII;
                } else if (n4 == 1) {
                    charset = StandardCharsets.UTF_16BE;
                }
            }
            object = ((NameRecord)object2).getString();
            if (((NameRecord)object2).getNameId() == 6 && this.prefix != null) {
                object = this.prefix + (String)object;
            }
            byArrayArray[n2] = ((String)object).getBytes(charset);
            ++n2;
        }
        int n5 = 0;
        n2 = 0;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (NameRecord)object2.next();
            if (!this.shouldCopyNameRecord((NameRecord)object)) continue;
            this.writeUint16(dataOutputStream, ((NameRecord)object).getPlatformId());
            this.writeUint16(dataOutputStream, ((NameRecord)object).getPlatformEncodingId());
            this.writeUint16(dataOutputStream, ((NameRecord)object).getLanguageId());
            this.writeUint16(dataOutputStream, ((NameRecord)object).getNameId());
            this.writeUint16(dataOutputStream, byArrayArray[n2].length);
            this.writeUint16(dataOutputStream, n5);
            n5 += byArrayArray[n2].length;
            ++n2;
        }
        for (int i = 0; i < n; ++i) {
            dataOutputStream.write(byArrayArray[i]);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildMaxpTable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        MaximumProfileTable maximumProfileTable = this.ttf.getMaximumProfile();
        this.writeFixed(dataOutputStream, maximumProfileTable.getVersion());
        this.writeUint16(dataOutputStream, this.glyphIds.size());
        if (maximumProfileTable.getVersion() >= 1.0f) {
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxPoints());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxContours());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxCompositePoints());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxCompositeContours());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxZones());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxTwilightPoints());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxStorage());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxFunctionDefs());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxInstructionDefs());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxStackElements());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxSizeOfInstructions());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxComponentElements());
            this.writeUint16(dataOutputStream, maximumProfileTable.getMaxComponentDepth());
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildOS2Table() {
        OS2WindowsMetricsTable oS2WindowsMetricsTable = this.ttf.getOS2Windows();
        if (oS2WindowsMetricsTable == null || this.uniToGID.isEmpty() || this.keepTables != null && !this.keepTables.contains("OS/2")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getVersion());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getAverageCharWidth());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWeightClass());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWidthClass());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getFsType());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptXSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptYSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptXOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSubscriptYOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptXSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptYSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptXOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getSuperscriptYOffset());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getStrikeoutSize());
        this.writeSInt16(dataOutputStream, oS2WindowsMetricsTable.getStrikeoutPosition());
        this.writeSInt16(dataOutputStream, (short)oS2WindowsMetricsTable.getFamilyClass());
        dataOutputStream.write(oS2WindowsMetricsTable.getPanose());
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        this.writeUint32(dataOutputStream, 0L);
        dataOutputStream.write(oS2WindowsMetricsTable.getAchVendId().getBytes(StandardCharsets.US_ASCII));
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getFsSelection());
        this.writeUint16(dataOutputStream, this.uniToGID.firstKey());
        this.writeUint16(dataOutputStream, this.uniToGID.lastKey());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoAscender());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoDescender());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getTypoLineGap());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWinAscent());
        this.writeUint16(dataOutputStream, oS2WindowsMetricsTable.getWinDescent());
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildLocaTable(long[] lArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (long l : lArray) {
            this.writeUint32(dataOutputStream, l);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private void addCompoundReferences() {
        boolean bl;
        if (this.hasAddedCompoundReferences) {
            return;
        }
        this.hasAddedCompoundReferences = true;
        GlyphTable glyphTable = this.ttf.getGlyph();
        long[] lArray = this.ttf.getIndexToLocation().getOffsets();
        do {
            TreeSet<Integer> treeSet = null;
            Throwable throwable = null;
            try (InputStream inputStream = this.ttf.getOriginalData();){
                long l = inputStream.skip(glyphTable.getOffset());
                if (Long.compare(l, glyphTable.getOffset()) != 0) {
                    LOG.debug((Object)("Tried skipping " + glyphTable.getOffset() + " bytes but skipped only " + l + " bytes"));
                }
                long l2 = 0L;
                for (Integer n : this.glyphIds) {
                    byte[] byArray;
                    long l3 = lArray[n];
                    long l4 = lArray[n + 1] - l3;
                    l = inputStream.skip(l3 - l2);
                    if (Long.compare(l, l3 - l2) != 0) {
                        LOG.debug((Object)("Tried skipping " + (l3 - l2) + " bytes but skipped only " + l + " bytes"));
                    }
                    if (Long.compare(l = (long)inputStream.read(byArray = new byte[(int)l4]), l4) != 0) {
                        LOG.debug((Object)("Tried reading " + l4 + " bytes but only " + l + " bytes read"));
                    }
                    if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -1) {
                        int n2;
                        int n3 = 10;
                        do {
                            int n4;
                            n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                            if (!this.glyphIds.contains(n4 = (byArray[n3 += 2] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF)) {
                                if (treeSet == null) {
                                    treeSet = new TreeSet<Integer>();
                                }
                                treeSet.add(n4);
                            }
                            n3 += 2;
                            n3 = (n2 & 1) != 0 ? (n3 += 4) : (n3 += 2);
                            if ((n2 & 0x80) != 0) {
                                n3 += 8;
                                continue;
                            }
                            if ((n2 & 0x40) != 0) {
                                n3 += 4;
                                continue;
                            }
                            if ((n2 & 8) == 0) continue;
                            n3 += 2;
                        } while ((n2 & 0x20) != 0);
                    }
                    l2 = lArray[n + 1];
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            bl = treeSet != null;
            if (!bl) continue;
            this.glyphIds.addAll(treeSet);
        } while (bl);
    }

    private byte[] buildGlyfTable(long[] lArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GlyphTable glyphTable = this.ttf.getGlyph();
        long[] lArray2 = this.ttf.getIndexToLocation().getOffsets();
        Throwable throwable = null;
        try (InputStream inputStream = this.ttf.getOriginalData();){
            long l = inputStream.skip(glyphTable.getOffset());
            if (Long.compare(l, glyphTable.getOffset()) != 0) {
                LOG.debug((Object)("Tried skipping " + glyphTable.getOffset() + " bytes but skipped only " + l + " bytes"));
            }
            long l2 = 0L;
            long l3 = 0L;
            int n = 0;
            for (Integer n2 : this.glyphIds) {
                byte[] byArray;
                long l4 = lArray2[n2];
                long l5 = lArray2[n2 + 1] - l4;
                lArray[n++] = l3;
                long l6 = inputStream.skip(l4 - l2);
                if (Long.compare(l6, l4 - l2) != 0) {
                    LOG.debug((Object)("Tried skipping " + (l4 - l2) + " bytes but skipped only " + l6 + " bytes"));
                }
                if (Long.compare(l6 = (long)inputStream.read(byArray = new byte[(int)l5]), l5) != 0) {
                    LOG.debug((Object)("Tried reading " + l5 + " bytes but only " + l6 + " bytes read"));
                }
                if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -1) {
                    int n3;
                    int n4;
                    int n5 = 10;
                    do {
                        n4 = (byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF;
                        n3 = (byArray[n5 += 2] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF;
                        this.glyphIds.add(n3);
                        n3 = this.getNewGlyphId(n3);
                        byArray[n5] = (byte)(n3 >>> 8);
                        byArray[n5 + 1] = (byte)n3;
                        n5 += 2;
                        n5 = (n4 & 1) != 0 ? (n5 += 4) : (n5 += 2);
                        if ((n4 & 0x80) != 0) {
                            n5 += 8;
                            continue;
                        }
                        if ((n4 & 0x40) != 0) {
                            n5 += 4;
                            continue;
                        }
                        if ((n4 & 8) == 0) continue;
                        n5 += 2;
                    } while ((n4 & 0x20) != 0);
                    if ((n4 & 0x100) == 256) {
                        n3 = (byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF;
                        n5 += 2;
                        n5 += n3;
                    }
                    byteArrayOutputStream.write(byArray, 0, n5);
                    l3 += (long)n5;
                } else if (byArray.length > 0) {
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    l3 += (long)byArray.length;
                }
                if (l3 % 4L != 0L) {
                    int n6 = 4 - (int)(l3 % 4L);
                    byteArrayOutputStream.write(PAD_BUF, 0, n6);
                    l3 += (long)n6;
                }
                l2 = l4 + l5;
            }
            lArray[n] = l3;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int getNewGlyphId(Integer n) {
        return this.glyphIds.headSet(n).size();
    }

    private byte[] buildCmapTable() {
        int n;
        Map.Entry<Integer, Integer> entry;
        if (this.ttf.getCmap() == null || this.uniToGID.isEmpty() || this.keepTables != null && !this.keepTables.contains("cmap")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, 1);
        this.writeUint16(dataOutputStream, 3);
        this.writeUint16(dataOutputStream, 1);
        this.writeUint32(dataOutputStream, 12L);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.uniToGID.entrySet().iterator();
        Map.Entry<Integer, Integer> entry2 = entry = iterator.next();
        int n2 = this.getNewGlyphId(entry.getValue());
        int[] nArray = new int[this.uniToGID.size() + 1];
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry3 = iterator.next();
            n = this.getNewGlyphId(entry3.getValue());
            if (entry3.getKey() > 65535) {
                throw new UnsupportedOperationException("non-BMP Unicode character");
            }
            if (entry3.getKey() != entry2.getKey() + 1 || n - n2 != entry3.getKey() - entry.getKey()) {
                if (n2 != 0) {
                    nArray[n3] = entry.getKey();
                    nArray2[n3] = entry2.getKey();
                    nArray3[n3] = n2 - entry.getKey();
                    ++n3;
                } else if (!entry.getKey().equals(entry2.getKey())) {
                    nArray[n3] = entry.getKey() + 1;
                    nArray2[n3] = entry2.getKey();
                    nArray3[n3] = n2 - entry.getKey();
                    ++n3;
                }
                n2 = n;
                entry = entry3;
            }
            entry2 = entry3;
        }
        nArray[n3] = entry.getKey();
        nArray2[n3] = entry2.getKey();
        nArray3[n3] = n2 - entry.getKey();
        nArray[++n3] = 65535;
        nArray2[n3] = 65535;
        nArray3[n3] = 1;
        int n4 = 2 * (int)Math.pow(2.0, this.log2(++n3));
        this.writeUint16(dataOutputStream, 4);
        this.writeUint16(dataOutputStream, 16 + (n3 << 2 << 1));
        this.writeUint16(dataOutputStream, 0);
        this.writeUint16(dataOutputStream, n3 << 1);
        this.writeUint16(dataOutputStream, n4);
        this.writeUint16(dataOutputStream, this.log2(n4 / 2));
        this.writeUint16(dataOutputStream, 2 * n3 - n4);
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray2[n]);
        }
        this.writeUint16(dataOutputStream, 0);
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, nArray3[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.writeUint16(dataOutputStream, 0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildPostTable() {
        PostScriptTable postScriptTable = this.ttf.getPostScript();
        if (postScriptTable == null || this.keepTables != null && !this.keepTables.contains("post")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeFixed(dataOutputStream, 2.0);
        this.writeFixed(dataOutputStream, postScriptTable.getItalicAngle());
        this.writeSInt16(dataOutputStream, postScriptTable.getUnderlinePosition());
        this.writeSInt16(dataOutputStream, postScriptTable.getUnderlineThickness());
        this.writeUint32(dataOutputStream, postScriptTable.getIsFixedPitch());
        this.writeUint32(dataOutputStream, postScriptTable.getMinMemType42());
        this.writeUint32(dataOutputStream, postScriptTable.getMaxMemType42());
        this.writeUint32(dataOutputStream, postScriptTable.getMinMemType1());
        this.writeUint32(dataOutputStream, postScriptTable.getMaxMemType1());
        this.writeUint16(dataOutputStream, this.glyphIds.size());
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        Iterator<Object> iterator = this.glyphIds.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Object object = postScriptTable.getName(n);
            Integer n2 = WGL4Names.getGlyphIndex((String)object);
            if (n2 != null) {
                this.writeUint16(dataOutputStream, n2);
                continue;
            }
            object = linkedHashMap.computeIfAbsent((String)object, string -> linkedHashMap.size());
            this.writeUint16(dataOutputStream, 258 + (Integer)object);
        }
        for (Object object : linkedHashMap.keySet()) {
            object = ((String)object).getBytes(StandardCharsets.US_ASCII);
            this.writeUint8(dataOutputStream, ((Object)object).length);
            dataOutputStream.write((byte[])object);
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] buildHmtxTable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HorizontalHeaderTable horizontalHeaderTable = this.ttf.getHorizontalHeader();
        Object object = this.ttf.getHorizontalMetrics();
        InputStream inputStream = this.ttf.getOriginalData();
        int n = horizontalHeaderTable.getNumberOfHMetrics() - 1;
        boolean bl = this.glyphIds.last() > n && !this.glyphIds.contains(n);
        try {
            long l = inputStream.skip(((TTFTable)object).getOffset());
            if (Long.compare(l, ((TTFTable)object).getOffset()) != 0) {
                LOG.debug((Object)("Tried skipping " + ((TTFTable)object).getOffset() + " bytes but only " + l + " bytes skipped"));
            }
            long l2 = 0L;
            for (Integer n2 : this.glyphIds) {
                long l3;
                if (n2 <= n) {
                    l3 = (long)n2.intValue() << 2;
                    l2 = this.copyBytes(inputStream, byteArrayOutputStream, l3, l2, 4);
                    continue;
                }
                if (bl) {
                    bl = false;
                    l3 = (long)n << 2;
                    l2 = this.copyBytes(inputStream, byteArrayOutputStream, l3, l2, 2);
                }
                l3 = ((long)horizontalHeaderTable.getNumberOfHMetrics() << 2) + ((long)(n2 - horizontalHeaderTable.getNumberOfHMetrics()) << 1);
                l2 = this.copyBytes(inputStream, byteArrayOutputStream, l3, l2, 2);
            }
            object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    private long copyBytes(InputStream inputStream, OutputStream outputStream, long l, long l2, int n) {
        long l3 = l - l2;
        if (l3 != inputStream.skip(l3)) {
            throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
        }
        byte[] byArray = new byte[n];
        if (n != inputStream.read(byArray, 0, n)) {
            throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
        }
        outputStream.write(byArray, 0, n);
        return l + (long)n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeToStream(OutputStream outputStream) {
        block17: {
            if (this.glyphIds.isEmpty() && this.uniToGID.isEmpty()) {
                LOG.info((Object)"font subset is empty");
            }
            this.addCompoundReferences();
            outputStream = new DataOutputStream(outputStream);
            Throwable throwable = null;
            try {
                Object object = new long[this.glyphIds.size() + 1];
                byte[] byArray = this.buildHeadTable();
                Object object2 = this.buildHheaTable();
                byte[] byArray2 = this.buildMaxpTable();
                byte[] byArray3 = this.buildNameTable();
                byte[] byArray4 = this.buildOS2Table();
                byte[] byArray5 = this.buildGlyfTable((long[])object);
                object = this.buildLocaTable((long[])object);
                byte[] byArray6 = this.buildCmapTable();
                byte[] byArray7 = this.buildHmtxTable();
                byte[] byArray8 = this.buildPostTable();
                TreeMap<String, long[]> treeMap = new TreeMap<String, long[]>();
                if (byArray4 != null) {
                    treeMap.put("OS/2", byArray4);
                }
                if (byArray6 != null) {
                    treeMap.put("cmap", byArray6);
                }
                treeMap.put("glyf", byArray5);
                treeMap.put("head", byArray);
                treeMap.put("hhea", (long[])object2);
                treeMap.put("hmtx", byArray7);
                treeMap.put("loca", (long[])object);
                treeMap.put("maxp", byArray2);
                if (byArray3 != null) {
                    treeMap.put("name", byArray3);
                }
                if (byArray8 != null) {
                    treeMap.put("post", byArray8);
                }
                for (Map.Entry<String, TTFTable> entry : this.ttf.getTableMap().entrySet()) {
                    String string = entry.getKey();
                    TTFTable tTFTable = entry.getValue();
                    if (treeMap.containsKey(string) || this.keepTables != null && !this.keepTables.contains(string)) continue;
                    treeMap.put(string, this.ttf.getTableBytes(tTFTable));
                }
                long l = this.writeFileHeader((DataOutputStream)outputStream, treeMap.size());
                long l2 = 12L + 16L * (long)treeMap.size();
                object = treeMap.entrySet().iterator();
                while (object.hasNext()) {
                    object2 = (Map.Entry)object.next();
                    l += this.writeTableHeader((DataOutputStream)outputStream, (String)object2.getKey(), l2, (byte[])object2.getValue());
                    l2 += ((long)((byte[])object2.getValue()).length + 3L) / 4L << 2;
                }
                l = 2981146554L - (l & 0xFFFFFFFFL);
                byArray[8] = (byte)(l >>> 24);
                byArray[9] = (byte)(l >>> 16);
                byArray[10] = (byte)(l >>> 8);
                byArray[11] = (byte)l;
                object = treeMap.values().iterator();
                while (object.hasNext()) {
                    object2 = (byte[])object.next();
                    this.writeTableBody(outputStream, (byte[])object2);
                }
                if (throwable == null) break block17;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        ((FilterOutputStream)outputStream).close();
                        throw throwable5;
                    }
                    try {
                        ((FilterOutputStream)outputStream).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                ((FilterOutputStream)outputStream).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((FilterOutputStream)outputStream).close();
    }

    private void writeFixed(DataOutputStream dataOutputStream, double d) {
        double d2 = Math.floor(d);
        double d3 = (d - d2) * 65536.0;
        dataOutputStream.writeShort((int)d2);
        dataOutputStream.writeShort((int)d3);
    }

    private void writeUint32(DataOutputStream dataOutputStream, long l) {
        dataOutputStream.writeInt((int)l);
    }

    private void writeUint16(DataOutputStream dataOutputStream, int n) {
        dataOutputStream.writeShort(n);
    }

    private void writeSInt16(DataOutputStream dataOutputStream, short s) {
        dataOutputStream.writeShort(s);
    }

    private void writeUint8(DataOutputStream dataOutputStream, int n) {
        dataOutputStream.writeByte(n);
    }

    private void writeLongDateTime(DataOutputStream dataOutputStream, Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance((TimeZone)TIMEZONE_UTC.clone());
        calendar2.set(1904, 0, 1, 0, 0, 0);
        calendar2.set(14, 0);
        long l = calendar2.getTimeInMillis();
        long l2 = (calendar.getTimeInMillis() - l) / 1000L;
        dataOutputStream.writeLong(l2);
    }

    private long toUInt32(int n, int n2) {
        return ((long)n & 0xFFFFL) << 16 | (long)n2 & 0xFFFFL;
    }

    private long toUInt32(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL;
    }

    private int log2(int n) {
        return (int)Math.floor(Math.log(n) / Math.log(2.0));
    }

    public final void addGlyphIds(Set<Integer> set) {
        this.glyphIds.addAll(set);
    }
}

