/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class VerticalHeaderTable
extends TTFTable {
    public static final String TAG = "vhea";
    private float version;
    private short ascender;
    private short descender;
    private short lineGap;
    private int advanceHeightMax;
    private short minTopSideBearing;
    private short minBottomSideBearing;
    private short yMaxExtent;
    private short caretSlopeRise;
    private short caretSlopeRun;
    private short caretOffset;
    private short reserved1;
    private short reserved2;
    private short reserved3;
    private short reserved4;
    private short metricDataFormat;
    private int numberOfVMetrics;

    VerticalHeaderTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        this.version = tTFDataStream.read32Fixed();
        this.ascender = tTFDataStream.readSignedShort();
        this.descender = tTFDataStream.readSignedShort();
        this.lineGap = tTFDataStream.readSignedShort();
        this.advanceHeightMax = tTFDataStream.readUnsignedShort();
        this.minTopSideBearing = tTFDataStream.readSignedShort();
        this.minBottomSideBearing = tTFDataStream.readSignedShort();
        this.yMaxExtent = tTFDataStream.readSignedShort();
        this.caretSlopeRise = tTFDataStream.readSignedShort();
        this.caretSlopeRun = tTFDataStream.readSignedShort();
        this.caretOffset = tTFDataStream.readSignedShort();
        this.reserved1 = tTFDataStream.readSignedShort();
        this.reserved2 = tTFDataStream.readSignedShort();
        this.reserved3 = tTFDataStream.readSignedShort();
        this.reserved4 = tTFDataStream.readSignedShort();
        this.metricDataFormat = tTFDataStream.readSignedShort();
        this.numberOfVMetrics = tTFDataStream.readUnsignedShort();
        this.initialized = true;
    }

    public int getAdvanceHeightMax() {
        return this.advanceHeightMax;
    }

    public short getAscender() {
        return this.ascender;
    }

    public short getCaretSlopeRise() {
        return this.caretSlopeRise;
    }

    public short getCaretSlopeRun() {
        return this.caretSlopeRun;
    }

    public short getCaretOffset() {
        return this.caretOffset;
    }

    public short getDescender() {
        return this.descender;
    }

    public short getLineGap() {
        return this.lineGap;
    }

    public short getMetricDataFormat() {
        return this.metricDataFormat;
    }

    public short getMinTopSideBearing() {
        return this.minTopSideBearing;
    }

    public short getMinBottomSideBearing() {
        return this.minBottomSideBearing;
    }

    public int getNumberOfVMetrics() {
        return this.numberOfVMetrics;
    }

    public short getReserved1() {
        return this.reserved1;
    }

    public short getReserved2() {
        return this.reserved2;
    }

    public short getReserved3() {
        return this.reserved3;
    }

    public short getReserved4() {
        return this.reserved4;
    }

    public float getVersion() {
        return this.version;
    }

    public short getYMaxExtent() {
        return this.yMaxExtent;
    }
}

