/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;

public class VerticalMetricsTable
extends TTFTable {
    public static final String TAG = "vmtx";
    private int[] advanceHeight;
    private short[] topSideBearing;
    private short[] additionalTopSideBearing;
    private int numVMetrics;

    VerticalMetricsTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        int n;
        VerticalHeaderTable verticalHeaderTable = trueTypeFont.getVerticalHeader();
        if (verticalHeaderTable == null) {
            throw new IOException("Could not get vhea table");
        }
        this.numVMetrics = verticalHeaderTable.getNumberOfVMetrics();
        int n2 = trueTypeFont.getNumberOfGlyphs();
        int n3 = 0;
        this.advanceHeight = new int[this.numVMetrics];
        this.topSideBearing = new short[this.numVMetrics];
        for (n = 0; n < this.numVMetrics; ++n) {
            this.advanceHeight[n] = tTFDataStream.readUnsignedShort();
            this.topSideBearing[n] = tTFDataStream.readSignedShort();
            n3 += 4;
        }
        if ((long)n3 < this.getLength()) {
            n = n2 - this.numVMetrics;
            if (n < 0) {
                n = n2;
            }
            this.additionalTopSideBearing = new short[n];
            for (n2 = 0; n2 < n; ++n2) {
                if ((long)n3 >= this.getLength()) continue;
                this.additionalTopSideBearing[n2] = tTFDataStream.readSignedShort();
                n3 += 2;
            }
        }
        this.initialized = true;
    }

    public int getTopSideBearing(int n) {
        if (n < this.numVMetrics) {
            return this.topSideBearing[n];
        }
        return this.additionalTopSideBearing[n - this.numVMetrics];
    }

    public int getAdvanceHeight(int n) {
        if (n < this.numVMetrics) {
            return this.advanceHeight[n];
        }
        return this.advanceHeight[this.advanceHeight.length - 1];
    }
}

