/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.Language;
import org.apache.fontbox.ttf.model.MapBackedScriptFeature;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class MapBackedGsubData
implements GsubData {
    private final Language language;
    private final String activeScriptName;
    private final Map<String, Map<List<Integer>, Integer>> glyphSubstitutionMap;

    public MapBackedGsubData(Language language, String string, Map<String, Map<List<Integer>, Integer>> map) {
        this.language = language;
        this.activeScriptName = string;
        this.glyphSubstitutionMap = map;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public String getActiveScriptName() {
        return this.activeScriptName;
    }

    @Override
    public boolean isFeatureSupported(String string) {
        return this.glyphSubstitutionMap.containsKey(string);
    }

    @Override
    public ScriptFeature getFeature(String string) {
        if (!this.isFeatureSupported(string)) {
            throw new UnsupportedOperationException("The feature " + string + " is not supported!");
        }
        return new MapBackedScriptFeature(string, this.glyphSubstitutionMap.get(string));
    }

    @Override
    public Set<String> getSupportedFeatures() {
        return this.glyphSubstitutionMap.keySet();
    }
}

