/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import org.apache.fontbox.type1.Token$Kind;

class Token {
    static final Token$Kind STRING = Token$Kind.STRING;
    static final Token$Kind NAME = Token$Kind.NAME;
    static final Token$Kind LITERAL = Token$Kind.LITERAL;
    static final Token$Kind REAL = Token$Kind.REAL;
    static final Token$Kind INTEGER = Token$Kind.INTEGER;
    static final Token$Kind START_ARRAY = Token$Kind.START_ARRAY;
    static final Token$Kind END_ARRAY = Token$Kind.END_ARRAY;
    static final Token$Kind START_PROC = Token$Kind.START_PROC;
    static final Token$Kind END_PROC = Token$Kind.END_PROC;
    static final Token$Kind CHARSTRING = Token$Kind.CHARSTRING;
    static final Token$Kind START_DICT = Token$Kind.START_DICT;
    static final Token$Kind END_DICT = Token$Kind.END_DICT;
    private String text;
    private byte[] data;
    private final Token$Kind kind;

    Token(String string, Token$Kind token$Kind) {
        this.text = string;
        this.kind = token$Kind;
    }

    Token(char c, Token$Kind token$Kind) {
        this.text = Character.toString(c);
        this.kind = token$Kind;
    }

    Token(byte[] byArray, Token$Kind token$Kind) {
        this.data = byArray;
        this.kind = token$Kind;
    }

    public String getText() {
        return this.text;
    }

    public Token$Kind getKind() {
        return this.kind;
    }

    public int intValue() {
        return (int)Float.parseFloat(this.text);
    }

    public float floatValue() {
        return Float.parseFloat(this.text);
    }

    public boolean booleanValue() {
        return this.text.equals("true");
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        if (this.kind == CHARSTRING) {
            return "Token[kind=CHARSTRING, data=" + this.data.length + " bytes]";
        }
        return "Token[kind=" + (Object)((Object)this.kind) + ", text=" + this.text + "]";
    }
}

