/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.type1.DamagedFontException;
import org.apache.fontbox.type1.Token;
import org.apache.fontbox.type1.Token$Kind;

class Type1Lexer {
    private static final Log LOG = LogFactory.getLog(Type1Lexer.class);
    private final ByteBuffer buffer;
    private Token aheadToken;
    private int openParens = 0;

    Type1Lexer(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.aheadToken = this.readToken(null);
    }

    public Token nextToken() {
        Token token = this.aheadToken;
        this.aheadToken = this.readToken(token);
        return token;
    }

    public Token peekToken() {
        return this.aheadToken;
    }

    public boolean peekKind(Token$Kind token$Kind) {
        return this.aheadToken != null && this.aheadToken.getKind() == token$Kind;
    }

    private char getChar() {
        try {
            return (char)this.buffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Premature end of buffer reached");
        }
    }

    private Token readToken(Token token) {
        char c;
        do {
            c = '\u0000';
            while (this.buffer.hasRemaining()) {
                char c2 = this.getChar();
                if (c2 == '%') {
                    this.readComment();
                    continue;
                }
                if (c2 == '(') {
                    return this.readString();
                }
                if (c2 == ')') {
                    throw new IOException("unexpected closing parenthesis");
                }
                if (c2 == '[') {
                    return new Token(c2, Token.START_ARRAY);
                }
                if (c2 == '{') {
                    return new Token(c2, Token.START_PROC);
                }
                if (c2 == ']') {
                    return new Token(c2, Token.END_ARRAY);
                }
                if (c2 == '}') {
                    return new Token(c2, Token.END_PROC);
                }
                if (c2 == '/') {
                    String string = this.readRegular();
                    if (string == null) {
                        throw new DamagedFontException("Could not read token at position " + this.buffer.position());
                    }
                    return new Token(string, Token.LITERAL);
                }
                if (c2 == '<') {
                    c = this.getChar();
                    if (c == c2) {
                        return new Token("<<", Token.START_DICT);
                    }
                    this.buffer.position(this.buffer.position() - 1);
                    return new Token(c2, Token.NAME);
                }
                if (c2 == '>') {
                    c = this.getChar();
                    if (c == c2) {
                        return new Token(">>", Token.END_DICT);
                    }
                    this.buffer.position(this.buffer.position() - 1);
                    return new Token(c2, Token.NAME);
                }
                if (Character.isWhitespace(c2)) {
                    c = '\u0001';
                    continue;
                }
                if (c2 == '\u0000') {
                    LOG.warn((Object)"NULL byte in font, skipped");
                    c = '\u0001';
                    continue;
                }
                this.buffer.position(this.buffer.position() - 1);
                Object object = this.tryReadNumber();
                if (object != null) {
                    return object;
                }
                object = this.readRegular();
                if (object == null) {
                    throw new DamagedFontException("Could not read token at position " + this.buffer.position());
                }
                if (((String)object).equals("RD") || ((String)object).equals("-|")) {
                    if (token != null && token.getKind() == Token.INTEGER) {
                        return this.readCharString(token.intValue());
                    }
                    throw new IOException("expected INTEGER before -| or RD");
                }
                return new Token((String)object, Token.NAME);
            }
        } while (c != '\u0000');
        return null;
    }

    private Token tryReadNumber() {
        this.buffer.mark();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = null;
        char c = this.getChar();
        boolean bl = false;
        if (c == '+' || c == '-') {
            stringBuilder.append(c);
            c = this.getChar();
        }
        while (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
            bl = true;
        }
        if (c == '.') {
            stringBuilder.append(c);
            c = this.getChar();
        } else if (c == '#') {
            stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            c = this.getChar();
        } else {
            if (stringBuilder.length() == 0 || !bl) {
                this.buffer.reset();
                return null;
            }
            if (c != 'e' && c != 'E') {
                this.buffer.position(this.buffer.position() - 1);
                return new Token(stringBuilder.toString(), Token.INTEGER);
            }
        }
        if (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
        } else if (c != 'e' && c != 'E') {
            this.buffer.reset();
            return null;
        }
        while (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
        }
        if (c == 'E' || c == 'e') {
            stringBuilder.append(c);
            c = this.getChar();
            if (c == '-') {
                stringBuilder.append(c);
                c = this.getChar();
            }
            if (Character.isDigit(c)) {
                stringBuilder.append(c);
                c = this.getChar();
            } else {
                this.buffer.reset();
                return null;
            }
            while (Character.isDigit(c)) {
                stringBuilder.append(c);
                c = this.getChar();
            }
        }
        this.buffer.position(this.buffer.position() - 1);
        if (stringBuilder2 != null) {
            int n;
            try {
                n = Integer.parseInt(stringBuilder.toString(), Integer.parseInt(stringBuilder2.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid number '" + stringBuilder + "'", numberFormatException);
            }
            return new Token(Integer.toString(n), Token.INTEGER);
        }
        return new Token(stringBuilder.toString(), Token.REAL);
    }

    private String readRegular() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.buffer.hasRemaining()) {
            this.buffer.mark();
            char c = this.getChar();
            if (Character.isWhitespace(c) || c == '(' || c == ')' || c == '<' || c == '>' || c == '[' || c == ']' || c == '{' || c == '}' || c == '/' || c == '%') {
                this.buffer.reset();
                break;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private String readComment() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.buffer.hasRemaining() && (c = this.getChar()) != '\r' && c != '\n') {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private Token readString() {
        StringBuilder stringBuilder = new StringBuilder();
        block17: while (this.buffer.hasRemaining()) {
            char c = this.getChar();
            switch (c) {
                case '(': {
                    ++this.openParens;
                    stringBuilder.append('(');
                    continue block17;
                }
                case ')': {
                    if (this.openParens == 0) {
                        return new Token(stringBuilder.toString(), Token.STRING);
                    }
                    stringBuilder.append(')');
                    --this.openParens;
                    continue block17;
                }
                case '\\': {
                    c = this.getChar();
                    switch (c) {
                        case 'n': 
                        case 'r': {
                            stringBuilder.append("\n");
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        case 'b': {
                            stringBuilder.append('\b');
                            break;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            break;
                        }
                        case '(': {
                            stringBuilder.append('(');
                            break;
                        }
                        case ')': {
                            stringBuilder.append(')');
                        }
                    }
                    if (!Character.isDigit(c)) continue block17;
                    String string = String.valueOf(new char[]{c, this.getChar(), this.getChar()});
                    try {
                        int numberFormatException = Integer.parseInt(string, 8);
                        stringBuilder.append((char)numberFormatException);
                        continue block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException(numberFormatException);
                    }
                }
                case '\n': 
                case '\r': {
                    stringBuilder.append("\n");
                    continue block17;
                }
            }
            stringBuilder.append(c);
        }
        return null;
    }

    private Token readCharString(int n) {
        try {
            this.buffer.get();
            byte[] byArray = new byte[n];
            this.buffer.get(byArray);
            return new Token(byArray, Token.CHARSTRING);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Premature end of buffer reached");
        }
    }
}

