/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;
import org.apache.fontbox.util.autodetect.MacFontDirFinder;
import org.apache.fontbox.util.autodetect.OS400FontDirFinder;
import org.apache.fontbox.util.autodetect.UnixFontDirFinder;
import org.apache.fontbox.util.autodetect.WindowsFontDirFinder;

public class FontFileFinder {
    private static final Log LOG = LogFactory.getLog(FontFileFinder.class);
    private FontDirFinder fontDirFinder = null;

    private FontDirFinder determineDirFinder() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return new WindowsFontDirFinder();
        }
        if (string.startsWith("Mac")) {
            return new MacFontDirFinder();
        }
        if (string.startsWith("OS/400")) {
            return new OS400FontDirFinder();
        }
        return new UnixFontDirFinder();
    }

    public List<URI> find() {
        if (this.fontDirFinder == null) {
            this.fontDirFinder = this.determineDirFinder();
        }
        List<File> list = this.fontDirFinder.find();
        ArrayList<URI> arrayList = new ArrayList<URI>();
        list.forEach(file -> this.walk((File)file, (List<URI>)arrayList));
        return arrayList;
    }

    public List<URI> find(String object) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (((File)(object = new File((String)object))).isDirectory()) {
            this.walk((File)object, arrayList);
        }
        return arrayList;
    }

    private void walk(File fileArray, List<URI> list) {
        if (!fileArray.isDirectory()) {
            return;
        }
        if ((fileArray = fileArray.listFiles()) == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                if (file.isHidden()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("skip hidden directory " + file));
                    continue;
                }
                this.walk(file, list);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("checkFontfile check " + file));
            }
            if (!this.checkFontfile(file)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("checkFontfile found " + file));
            }
            list.add(file.toURI());
        }
    }

    private boolean checkFontfile(File object) {
        return (((String)(object = ((File)object).getName().toLowerCase(Locale.US))).endsWith(".ttf") || ((String)object).endsWith(".otf") || ((String)object).endsWith(".pfb") || ((String)object).endsWith(".ttc")) && !((String)object).startsWith("fonts.");
    }
}

