/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private static final long serialVersionUID = 975798773772956428L;
    SourceLocator locator;
    Throwable containedException;
    static Class class$java$lang$Throwable;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        if (this.containedException == this) {
            return null;
        }
        return this.containedException;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = throwable;
        return this;
    }

    public TransformerException(String string) {
        super(string);
        this.containedException = null;
        this.locator = null;
    }

    public TransformerException(Throwable throwable) {
        super(throwable.toString());
        this.containedException = throwable;
        this.locator = null;
    }

    public TransformerException(String string, Throwable throwable) {
        super(string == null || string.length() == 0 ? throwable.toString() : string);
        this.containedException = throwable;
        this.locator = null;
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        super(string);
        this.containedException = null;
        this.locator = sourceLocator;
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.containedException = throwable;
        this.locator = sourceLocator;
    }

    public String getMessageAndLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.getMessage();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.locator != null) {
            string = this.locator.getSystemId();
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            if (string != null) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string);
            }
            if (n != 0) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n);
            }
            if (n2 != 0) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n2);
            }
        }
        return stringBuffer.toString();
    }

    public String getLocationAsString() {
        if (this.locator != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.locator.getSystemId();
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            if (string != null) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string);
            }
            if (n != 0) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n);
            }
            if (n2 != 0) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            String string = this.getLocationAsString();
            if (string != null) {
                printWriter.println(string);
            }
            super.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {}
        boolean bl = false;
        try {
            (class$java$lang$Throwable == null ? (class$java$lang$Throwable = TransformerException.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getCause", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (!bl) {
            Throwable throwable = this.getException();
            int n = 0;
            while (n < 10 && throwable != null) {
                Object object;
                printWriter.println("---------");
                try {
                    if (throwable instanceof TransformerException && (object = ((TransformerException)throwable).getLocationAsString()) != null) {
                        printWriter.println((String)object);
                    }
                    throwable.printStackTrace(printWriter);
                }
                catch (Throwable throwable2) {
                    printWriter.println("Could not print stack trace...");
                }
                try {
                    object = throwable.getClass().getMethod("getException", null);
                    if (object != null) {
                        Throwable throwable3 = throwable;
                        if (throwable3 == (throwable = (Throwable)((Method)object).invoke((Object)throwable, (Object[])null))) {
                            break;
                        }
                    } else {
                        throwable = null;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throwable = null;
                }
                ++n;
            }
        }
        printWriter.flush();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

