/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryFinder$1;
import javax.xml.xpath.XPathFactoryFinder$2;

final class XPathFactoryFinder {
    private static boolean debug = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties cacheProps;
    private static boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;
    static Class class$javax$xml$xpath$XPathFactory;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public XPathFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (VirtualMachineError virtualMachineError) {
            VirtualMachineError virtualMachineError2 = virtualMachineError;
            throw virtualMachineError;
        }
        catch (ThreadDeath threadDeath) {
            ThreadDeath threadDeath2 = threadDeath;
            throw threadDeath;
        }
        catch (Throwable throwable) {}
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public final XPathFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        XPathFactory xPathFactory = this._newFactory(string);
        if (debug) {
            if (xPathFactory != null) {
                XPathFactoryFinder.debugPrintln("factory '" + xPathFactory.getClass().getName() + "' was found for " + string);
            } else {
                XPathFactoryFinder.debugPrintln("unable to find a factory for " + string);
            }
        }
        return xPathFactory;
    }

    private XPathFactory _newFactory(String string) {
        Serializable serializable;
        Object object;
        Object object2;
        block29: {
            String string2;
            block28: {
                string2 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    if (debug) {
                        XPathFactoryFinder.debugPrintln("Looking up system property '" + string2 + "'");
                    }
                    if ((object2 = SecuritySupport.getSystemProperty(string2)) != null && ((String)object2).length() > 0) {
                        if (debug) {
                            XPathFactoryFinder.debugPrintln("The value is '" + (String)object2 + "'");
                        }
                        if ((object2 = this.createInstance((String)object2)) != null) {
                            return object2;
                        }
                    } else if (debug) {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    VirtualMachineError virtualMachineError2 = virtualMachineError;
                    throw virtualMachineError;
                }
                catch (ThreadDeath threadDeath) {
                    ThreadDeath threadDeath2 = threadDeath;
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    if (!debug) break block28;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + string2 + "'");
                    throwable.printStackTrace();
                }
            }
            object2 = SecuritySupport.getSystemProperty("java.home");
            object2 = (String)object2 + File.separator + "lib" + File.separator + "jaxp.properties";
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable = new File((String)object2);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)serializable)) {
                                if (debug) {
                                    XPathFactoryFinder.debugPrintln("Read properties file " + serializable);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)serializable));
                            }
                        }
                    }
                }
                object2 = cacheProps.getProperty(string2);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("found " + (String)object2 + " in $java.home/jaxp.properties");
                }
                if (object2 != null && (object2 = this.createInstance((String)object2)) != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                if (!debug) break block29;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable = (URL)object.next();
            if (debug) {
                XPathFactoryFinder.debugPrintln("looking into " + serializable);
            }
            try {
                object2 = this.loadFromServicesFile(string, ((URL)serializable).toExternalForm(), SecuritySupport.getURLInputStream((URL)serializable));
                if (object2 == null) continue;
                return object2;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + serializable);
                iOException.printStackTrace();
            }
        }
        if (string.equals("http://java.sun.com/jaxp/xpath/dom")) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            }
            return this.createInstance("org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        if (debug) {
            XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    final XPathFactory createInstance(String string) {
        block8: {
            try {
                if (debug) {
                    XPathFactoryFinder.debugPrintln("instanciating " + string);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string) : Class.forName(string);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((clazz = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)((Object)clazz);
                }
                if (debug) {
                    XPathFactoryFinder.debugPrintln(string + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                VirtualMachineError virtualMachineError2 = virtualMachineError;
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                ThreadDeath threadDeath2 = threadDeath;
                throw threadDeath;
            }
            catch (Throwable throwable) {
                if (!debug) break block8;
                XPathFactoryFinder.debugPrintln("failed to instanciate " + string);
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromServicesFile(String string, String object, InputStream object2) {
        if (debug) {
            XPathFactoryFinder.debugPrintln("Reading " + (String)object);
        }
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader((InputStream)object2), 80);
        }
        Object object3 = null;
        while (true) {
            try {
                object2 = ((BufferedReader)object).readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (object2 == null) break;
            int n = ((String)object2).indexOf(35);
            if (n != -1) {
                object2 = ((String)object2).substring(0, n);
            }
            if (((String)(object2 = ((String)object2).trim())).length() == 0) continue;
            try {
                if (!((XPathFactory)(object2 = this.createInstance((String)object2))).isObjectModelSupported(string)) continue;
                object3 = object2;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        try {
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {}
        return object3;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new XPathFactoryFinder$1(this);
        }
        try {
            Enumeration enumeration = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !enumeration.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new XPathFactoryFinder$2(this, enumeration);
        }
        catch (IOException iOException) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                iOException.printStackTrace();
            }
            return ((AbstractList)new ArrayList()).iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String object, ClassLoader classLoader) {
        object = ((String)object).replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((object = SecuritySupport.getResourceAsURL(classLoader, (String)object)) != null) {
            return ((URL)object).toString();
        }
        return null;
    }

    static String access$100() {
        return SERVICE_ID;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (Exception exception) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = class$javax$xml$xpath$XPathFactory == null ? (class$javax$xml$xpath$XPathFactory = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactory")) : class$javax$xml$xpath$XPathFactory;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }
}

