/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$WhenMappings;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$renderFunction$1$1;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$renderLambda$1$1;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "()V", "renderer", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "renderCallable", "", "descriptor", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "renderFunction", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "renderLambda", "invoke", "renderParameter", "parameter", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "renderProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "renderType", "type", "Lkotlin/reflect/jvm/internal/impl/types/KotlinType;", "appendReceiverType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "receiver", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "appendReceivers", "callable", "kotlin-reflection"})
public final class ReflectionObjectRenderer {
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();
    private static final DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;

    private ReflectionObjectRenderer() {
    }

    private final void appendReceiverType(StringBuilder stringBuilder, ReceiverParameterDescriptor receiverParameterDescriptor) {
        if (receiverParameterDescriptor != null) {
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            stringBuilder.append(this.renderType(kotlinType));
            stringBuilder.append(".");
        }
    }

    private final void appendReceivers(StringBuilder stringBuilder, CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameterDescriptor = UtilKt.getInstanceReceiverParameter(callableDescriptor);
        callableDescriptor = callableDescriptor.getExtensionReceiverParameter();
        this.appendReceiverType(stringBuilder, receiverParameterDescriptor);
        boolean bl = receiverParameterDescriptor != null && callableDescriptor != null;
        if (bl) {
            stringBuilder.append("(");
        }
        this.appendReceiverType(stringBuilder, (ReceiverParameterDescriptor)callableDescriptor);
        if (bl) {
            stringBuilder.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor callableDescriptor) {
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        if (callableDescriptor2 instanceof PropertyDescriptor) {
            return this.renderProperty((PropertyDescriptor)callableDescriptor);
        }
        if (callableDescriptor2 instanceof FunctionDescriptor) {
            return this.renderFunction((FunctionDescriptor)callableDescriptor);
        }
        throw new IllegalStateException(("Illegal callable: " + callableDescriptor).toString());
    }

    public final String renderProperty(PropertyDescriptor propertyDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(propertyDescriptor.isVar() ? "var " : "val ");
        INSTANCE.appendReceivers(stringBuilder2, propertyDescriptor);
        Name name = propertyDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder2.append(renderer.renderName(name, true));
        stringBuilder2.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String renderFunction(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append("fun ");
        INSTANCE.appendReceivers(stringBuilder2, functionDescriptor);
        Name name = functionDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder2.append(renderer.renderName(name, true));
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)ReflectionObjectRenderer$renderFunction$1$1.INSTANCE, (int)48, null);
        stringBuilder2.append(": ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String renderLambda(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        INSTANCE.appendReceivers(stringBuilder2, functionDescriptor);
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)ReflectionObjectRenderer$renderLambda$1$1.INSTANCE, (int)48, null);
        stringBuilder2.append(" -> ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String renderParameter(KParameterImpl kParameterImpl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)kParameterImpl, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        switch (ReflectionObjectRenderer$WhenMappings.$EnumSwitchMapping$0[kParameterImpl.getKind().ordinal()]) {
            case 1: {
                stringBuilder2.append("extension receiver parameter");
                break;
            }
            case 2: {
                stringBuilder2.append("instance parameter");
                break;
            }
            case 3: {
                stringBuilder2.append("parameter #" + kParameterImpl.getIndex() + ' ' + kParameterImpl.getName());
            }
        }
        stringBuilder2.append(" of ");
        stringBuilder2.append(INSTANCE.renderCallable(kParameterImpl.getCallable().getDescriptor()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String renderType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return renderer.renderType(kotlinType);
    }
}

