/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$Function;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$SuspendFunction;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKindExtractor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class FunctionTypesKt {
    public static final FunctionTypeKind getFunctionTypeKind(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return FunctionTypesKt.getFunctionTypeKind(classifierDescriptor);
        }
        return null;
    }

    public static final boolean isFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind$Function.INSTANCE);
    }

    public static final boolean isSuspendFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind$SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinFunctionalType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor);
        }
        return false;
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(DeclarationDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = FunctionTypesKt.getFunctionTypeKind((DeclarationDescriptor)object);
        return Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind$Function.INSTANCE) || Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind$SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinExtensionFunctionalType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return FunctionTypesKt.isBuiltinFunctionalType(kotlinType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(kotlinType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType kotlinType) {
        return kotlinType.getAnnotations().findAnnotation(StandardNames$FqNames.extensionFunctionType) != null;
    }

    public static final FunctionTypeKind getFunctionTypeKind(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage(declarationDescriptor)) {
            return null;
        }
        return FunctionTypesKt.getFunctionTypeKind(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor));
    }

    private static final FunctionTypeKind getFunctionTypeKind(FqNameUnsafe fqNameUnsafe) {
        if (!fqNameUnsafe.isSafe() || fqNameUnsafe.isRoot()) {
            return null;
        }
        FunctionTypeKindExtractor functionTypeKindExtractor = FunctionTypeKindExtractor.Companion.getDefault();
        FqName fqName2 = fqNameUnsafe.toSafe().parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        String string = fqNameUnsafe.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return functionTypeKindExtractor.getFunctionalClassKind(fqName2, string);
    }

    public static final int contextFunctionTypeParamsCount(KotlinType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        AnnotationDescriptor annotationDescriptor = ((KotlinType)object).getAnnotations().findAnnotation(StandardNames$FqNames.contextFunctionTypeParams);
        if (annotationDescriptor == null) {
            return 0;
        }
        object = annotationDescriptor;
        object = (ConstantValue)MapsKt.getValue(annotationDescriptor.getAllValueArguments(), (Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull((Object)object);
        return ((Number)((IntValue)object).getValue()).intValue();
    }

    public static final KotlinType getReceiverTypeFromFunctionType(KotlinType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        int n = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (_Assertions.ENABLED && n == 0) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType((KotlinType)object)) {
            return null;
        }
        n = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)object);
        return ((KotlinType)object).getArguments().get(n).getType();
    }

    public static final List<KotlinType> getContextReceiverTypesFromFunctionType(KotlinType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        int n = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (_Assertions.ENABLED && n == 0) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        n = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)object);
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        Object object2 = object = (Iterable)((KotlinType)object).getArguments().subList(0, n);
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (TypeProjection)object3;
            Object object4 = object;
            KotlinType kotlinType = object3.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            object4.add(kotlinType);
        }
        return (List)object;
    }

    public static final KotlinType getReturnTypeFromFunctionType(KotlinType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (_Assertions.ENABLED && !bl) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last(((KotlinType)object).getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        return kotlinType;
    }

    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(KotlinType object) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not a function type: " + object;
            throw new AssertionError((Object)string);
        }
        List<TypeProjection> list = ((KotlinType)object).getArguments();
        int n = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)object) + (FunctionTypesKt.isBuiltinExtensionFunctionalType((KotlinType)object) ? 1 : 0);
        int n2 = list.size() - 1;
        boolean bl3 = bl = n <= n2;
        if (_Assertions.ENABLED && !bl) {
            object = "Not an exact function type: " + object;
            throw new AssertionError(object);
        }
        return list.subList(n, n2);
    }

    public static final Name extractParameterNameFromFunctionTypeArgument(KotlinType object) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                AnnotationDescriptor annotationDescriptor = ((KotlinType)object).getAnnotations().findAnnotation(StandardNames$FqNames.parameterName);
                if (annotationDescriptor == null) {
                    return null;
                }
                object = annotationDescriptor;
                object = CollectionsKt.singleOrNull((Iterable)annotationDescriptor.getAllValueArguments().values());
                object = object instanceof StringValue ? (StringValue)object : null;
                if (object == null || (object = (String)((ConstantValue)object).getValue()) == null) break block4;
                Object object2 = object;
                if ((object = Name.isValidIdentifier((String)object) ? object : null) != null) break block5;
            }
            return null;
        }
        return Name.identifier((String)object);
    }

    public static final List<TypeProjection> getFunctionTypeArgumentProjections(KotlinType object, List<? extends KotlinType> object2, List<? extends KotlinType> object3, List<Name> list, KotlinType kotlinType, KotlinBuiltIns kotlinBuiltIns) {
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter(object2, (String)"");
        Intrinsics.checkNotNullParameter(object3, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ArrayList<TypeProjection> arrayList = new ArrayList<TypeProjection>(object3.size() + object2.size() + (object != null ? 1 : 0) + 1);
        object2 = (Iterable)object2;
        Collection<TypeProjection> collection = arrayList;
        Iterable<KotlinType> iterable = object2;
        object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        Iterator<KotlinType> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            KotlinType kotlinType3 = kotlinType2 = iterator2.next();
            iterable = object2;
            iterable.add((TypeProjection)TypeUtilsKt.asTypeProjection(kotlinType3));
        }
        ((ArrayList)collection).addAll((Collection)object2);
        KotlinType kotlinType4 = object;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arrayList, kotlinType4 != null ? TypeUtilsKt.asTypeProjection(kotlinType4) : null);
        object2 = (Iterable)object3;
        int n = 0;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            KotlinType kotlinType5;
            Object object4;
            int n2;
            object = object2.next();
            Collection collection2 = arrayList;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            kotlinType2 = object;
            int n3 = n2;
            collection = collection2;
            List<Name> list2 = list;
            if (list2 != null && (list2 = list2.get(n3)) != null) {
                object = list2;
                object3 = list2;
                object4 = !((Name)((Object)list2)).isSpecial() ? object : null;
            } else {
                object4 = object = null;
            }
            if (object4 != null) {
                String string = ((Name)object).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                object = new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames$FqNames.parameterName, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.NAME, (Object)new StringValue(string))), false, 8, null);
                kotlinType5 = TypeUtilsKt.replaceAnnotations(kotlinType2, Annotations.Companion.create(CollectionsKt.plus((Iterable)kotlinType2.getAnnotations(), (Object)object)));
            } else {
                kotlinType5 = kotlinType2;
            }
            object = kotlinType5;
            collection.add(TypeUtilsKt.asTypeProjection(kotlinType5));
        }
        arrayList.add(TypeUtilsKt.asTypeProjection(kotlinType));
        return arrayList;
    }

    public static final SimpleType createFunctionType(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List<? extends KotlinType> list, List<? extends KotlinType> list2, List<Name> list3, KotlinType kotlinType2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType2, (String)"");
        list3 = FunctionTypesKt.getFunctionTypeArgumentProjections(kotlinType, list, list2, list3, kotlinType2, kotlinBuiltIns);
        int n = list2.size() + list.size() + (kotlinType == null ? 0 : 1);
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(kotlinBuiltIns, n, bl);
        if (kotlinType != null) {
            annotations2 = FunctionTypesKt.withExtensionFunctionAnnotation(annotations2, kotlinBuiltIns);
        }
        if (!((Collection)list).isEmpty()) {
            annotations2 = FunctionTypesKt.withContextReceiversFunctionAnnotation(annotations2, kotlinBuiltIns, list.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations2), classDescriptor, list3);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, list3, kotlinType2, bl);
    }

    public static final Annotations withExtensionFunctionAnnotation(Annotations annotations2, KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        if (annotations2.hasAnnotation(StandardNames$FqNames.extensionFunctionType)) {
            return annotations2;
        }
        return Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames$FqNames.extensionFunctionType, MapsKt.emptyMap(), false, 8, null)));
    }

    public static final Annotations withContextReceiversFunctionAnnotation(Annotations annotations2, KotlinBuiltIns kotlinBuiltIns, int n) {
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        if (annotations2.hasAnnotation(StandardNames$FqNames.contextFunctionTypeParams)) {
            return annotations2;
        }
        return Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames$FqNames.contextFunctionTypeParams, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, (Object)new IntValue(n))), false, 8, null)));
    }

    public static final ClassDescriptor getFunctionDescriptor(KotlinBuiltIns object, int n, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = bl ? ((KotlinBuiltIns)object).getSuspendFunction(n) : ((KotlinBuiltIns)object).getFunction(n);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }
}

