/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;

public final class InlineClassRepresentation<Type extends SimpleTypeMarker>
extends ValueClassRepresentation<Type> {
    private final Name underlyingPropertyName;
    private final Type underlyingType;

    public InlineClassRepresentation(Name name, Type Type2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter(Type2, (String)"");
        super(null);
        this.underlyingPropertyName = name;
        this.underlyingType = Type2;
    }

    public final Name getUnderlyingPropertyName() {
        return this.underlyingPropertyName;
    }

    public final Type getUnderlyingType() {
        return this.underlyingType;
    }

    @Override
    public final List<Pair<Name, Type>> getUnderlyingPropertyNamesToTypes() {
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)this.underlyingPropertyName, this.underlyingType));
    }

    @Override
    public final boolean containsPropertyWithName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return Intrinsics.areEqual((Object)this.underlyingPropertyName, (Object)name);
    }

    public final String toString() {
        return "InlineClassRepresentation(underlyingPropertyName=" + this.underlyingPropertyName + ", underlyingType=" + this.underlyingType + ')';
    }
}

