/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader$Kind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class PackagePartScopeCache {
    private final DeserializedDescriptorResolver resolver;
    private final ReflectKotlinClassFinder kotlinClassFinder;
    private final ConcurrentHashMap<ClassId, MemberScope> cache;

    public PackagePartScopeCache(DeserializedDescriptorResolver deserializedDescriptorResolver, ReflectKotlinClassFinder reflectKotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)deserializedDescriptorResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)reflectKotlinClassFinder, (String)"");
        this.resolver = deserializedDescriptorResolver;
        this.kotlinClassFinder = reflectKotlinClassFinder;
        this.cache = new ConcurrentHashMap();
    }

    public final MemberScope getPackagePartScope(ReflectKotlinClass object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        ConcurrentMap concurrentMap = this.cache;
        ClassId classId = ((ReflectKotlinClass)object).getClassId();
        Object object2 = concurrentMap.get(classId);
        if (object2 == null) {
            List list;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            FqName fqName2 = ((ReflectKotlinClass)object).getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
            FqName fqName3 = fqName2;
            if (((ReflectKotlinClass)object).getClassHeader().getKind() == KotlinClassHeader$Kind.MULTIFILE_CLASS) {
                object6 = object7 = (Iterable)((ReflectKotlinClass)object).getClassHeader().getMultifilePartNames();
                object7 = new ArrayList();
                object5 = object6;
                object6 = object5.iterator();
                while (object6.hasNext()) {
                    object4 = object5 = object6.next();
                    object3 = (String)object5;
                    ClassId classId2 = ClassId.topLevel(JvmClassName.byInternalName((String)object3).getFqNameForTopLevelClassMaybeWithDollars());
                    Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"");
                    object3 = classId2;
                    KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.kotlinClassFinder, (ClassId)object3, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.resolver.getComponents().getConfiguration()));
                    if (kotlinJvmBinaryClass == null) continue;
                    object5 = kotlinJvmBinaryClass;
                    object7.add(object5);
                }
                list = (List)object7;
            } else {
                list = CollectionsKt.listOf((Object)object);
            }
            object6 = list;
            object7 = new EmptyPackageFragmentDescriptor(this.resolver.getComponents().getModuleDescriptor(), fqName3);
            object6 = (Iterable)object6;
            object5 = new ArrayList();
            object4 = object6.iterator();
            while (object4.hasNext()) {
                object3 = object6 = object4.next();
                object3 = (KotlinJvmBinaryClass)object6;
                MemberScope memberScope2 = this.resolver.createKotlinPackagePartScope((PackageFragmentDescriptor)object7, (KotlinJvmBinaryClass)object3);
                if (memberScope2 == null) continue;
                object6 = memberScope2;
                object5.add(object6);
            }
            object7 = CollectionsKt.toList((Iterable)((Iterable)object5));
            object = ChainedMemberScope.Companion.create("package " + fqName3 + " (" + object + ')', (Iterable)object7);
            object2 = concurrentMap.putIfAbsent(classId, object);
            if (object2 == null) {
                object2 = object;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object2, (String)"");
        return (MemberScope)object2;
    }
}

