/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArrayArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$MemberVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$MethodAnnotationVisitor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(Class<?> annotationArray, KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor) {
        Intrinsics.checkNotNullParameter(annotationArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass$AnnotationVisitor, (String)"");
        Annotation[] annotationArray2 = annotationArray.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"");
        for (Annotation annotation : annotationArray2) {
            Intrinsics.checkNotNull((Object)annotation);
            this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
        }
        kotlinJvmBinaryClass$AnnotationVisitor.visitEnd();
    }

    public final void visitMembers(Class<?> clazz, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass$MemberVisitor, (String)"");
        this.loadMethodAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
        this.loadConstructorAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
        this.loadFieldAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> methodArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        Method[] methodArray2 = methodArray.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"");
        for (Method method : methodArray2) {
            KotlinJvmBinaryClass$MethodAnnotationVisitor kotlinJvmBinaryClass$MethodAnnotationVisitor;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)method);
            if (kotlinJvmBinaryClass$MemberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor = kotlinJvmBinaryClass$MethodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"");
            Annotation[] annotationArray3 = annotationArray2;
            int n = ((Object[])annotationArray3).length;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                Annotation annotation = annotationArray3[i];
                Intrinsics.checkNotNull((Object)annotation);
                for (Annotation annotation2 : annotation) {
                    KotlinJvmBinaryClass$AnnotationArgumentVisitor annotationArgumentVisitor;
                    Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
                    ClassId classId = ReflectClassUtilKt.getClassId(clazz);
                    Intrinsics.checkNotNull((Object)annotation2);
                    if (kotlinJvmBinaryClass$MethodAnnotationVisitor.visitParameterAnnotation(n2, classId, new ReflectAnnotationSource(annotation2)) == null) continue;
                    INSTANCE.processAnnotationArguments(annotationArgumentVisitor, annotation2, clazz);
                }
            }
            kotlinJvmBinaryClass$MethodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> constructorArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        Constructor<?>[] constructorArray2 = constructorArray.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray2, (String)"");
        for (Constructor<?> constructor : constructorArray2) {
            KotlinJvmBinaryClass$MethodAnnotationVisitor kotlinJvmBinaryClass$MethodAnnotationVisitor;
            Intrinsics.checkNotNull(constructor);
            if (kotlinJvmBinaryClass$MemberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor)) == null) continue;
            Annotation[] annotationArray = constructor.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor = kotlinJvmBinaryClass$MethodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
            }
            Annotation[] annotationArray2 = constructor.getParameterAnnotations();
            Intrinsics.checkNotNull((Object)annotationArray2);
            if (!(((Object[])annotationArray2).length == 0)) {
                int n = constructor.getParameterTypes().length - ((Object[])annotationArray2).length;
                Annotation[] annotationArray3 = annotationArray2;
                int n2 = ((Object[])annotationArray3).length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = i;
                    Annotation annotation = annotationArray3[i];
                    Intrinsics.checkNotNull((Object)annotation);
                    for (Annotation annotation2 : annotation) {
                        Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
                        ClassId classId = ReflectClassUtilKt.getClassId(clazz);
                        Intrinsics.checkNotNull((Object)annotation2);
                        KotlinJvmBinaryClass$AnnotationArgumentVisitor annotationArgumentVisitor = kotlinJvmBinaryClass$MethodAnnotationVisitor.visitParameterAnnotation(n3 + n, classId, new ReflectAnnotationSource(annotation2));
                        if (annotationArgumentVisitor == null) continue;
                        INSTANCE.processAnnotationArguments(annotationArgumentVisitor, annotation2, clazz);
                    }
                }
            }
            kotlinJvmBinaryClass$MethodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> fieldArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        Field[] fieldArray2 = fieldArray.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"");
        for (Field field : fieldArray2) {
            KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor;
            Annotation[] annotationArray;
            Name name = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)field);
            if (kotlinJvmBinaryClass$MemberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)field.getDeclaredAnnotations(), (String)"");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
            }
            kotlinJvmBinaryClass$AnnotationVisitor.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass$AnnotationVisitor object, Annotation annotation) {
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
        KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor = object.visitAnnotation(ReflectClassUtilKt.getClassId(clazz), new ReflectAnnotationSource(annotation));
        if (kotlinJvmBinaryClass$AnnotationArgumentVisitor != null) {
            object = kotlinJvmBinaryClass$AnnotationArgumentVisitor;
            INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass$AnnotationArgumentVisitor)object, annotation, clazz);
            return;
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor, Annotation annotation, Class<?> methodArray) {
        Method[] methodArray2 = methodArray.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"");
        for (Method method : methodArray2) {
            Object object;
            try {
                Object object2 = method.invoke((Object)annotation, new Object[0]);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            this.processAnnotationArgumentValue(kotlinJvmBinaryClass$AnnotationArgumentVisitor, name, object);
        }
        kotlinJvmBinaryClass$AnnotationArgumentVisitor.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> object) {
        int n = 0;
        while (((Class)object).isArray()) {
            ++n;
            Intrinsics.checkNotNullExpressionValue(((Class)object).getComponentType(), (String)"");
        }
        if (((Class)object).isPrimitive()) {
            if (Intrinsics.areEqual(object, Void.TYPE)) {
                ClassId classId = ClassId.topLevel(StandardNames$FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
                return new ClassLiteralValue(classId, n);
            }
            PrimitiveType primitiveType = JvmPrimitiveType.get(((Class)object).getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"");
            object = primitiveType;
            if (n > 0) {
                ClassId classId = ClassId.topLevel(((PrimitiveType)((Object)object)).getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
                return new ClassLiteralValue(classId, n - 1);
            }
            ClassId classId = ClassId.topLevel(((PrimitiveType)((Object)object)).getTypeFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
            return new ClassLiteralValue(classId, n);
        }
        object = ReflectClassUtilKt.getClassId(object);
        FqName fqName2 = ((ClassId)object).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        Object object2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        if (object2 == null) {
            object2 = object;
        }
        object = object2;
        return new ClassLiteralValue((ClassId)object, n);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass$AnnotationArgumentVisitor objectArray, Name objectArray2, Object object) {
        Class<?> clazz = object.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)object);
            objectArray.visitClassLiteral((Name)objectArray2, this.classLiteralValue((Class)object));
            return;
        }
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            objectArray.visit((Name)objectArray2, object);
            return;
        }
        if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            clazz = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNull(clazz);
            ClassId classId = ReflectClassUtilKt.getClassId(clazz);
            Intrinsics.checkNotNull((Object)object);
            Name name = Name.identifier(((Enum)object).name());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            objectArray.visitEnum((Name)objectArray2, classId, name);
            return;
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
            Class clazz2 = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNull((Object)clazz2);
            KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor = objectArray.visitAnnotation((Name)objectArray2, ReflectClassUtilKt.getClassId(clazz2));
            if (kotlinJvmBinaryClass$AnnotationArgumentVisitor == null) {
                return;
            }
            clazz = kotlinJvmBinaryClass$AnnotationArgumentVisitor;
            Intrinsics.checkNotNull((Object)object);
            this.processAnnotationArguments((KotlinJvmBinaryClass$AnnotationArgumentVisitor)((Object)clazz), (Annotation)object, clazz2);
            return;
        }
        if (clazz.isArray()) {
            KotlinJvmBinaryClass$AnnotationArrayArgumentVisitor kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor = objectArray.visitArray((Name)objectArray2);
            if (kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass$AnnotationArrayArgumentVisitor kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2 = kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor;
            if ((clazz = clazz.getComponentType()).isEnum()) {
                Intrinsics.checkNotNull(clazz);
                objectArray = ReflectClassUtilKt.getClassId(clazz);
                Intrinsics.checkNotNull((Object)object);
                for (Object object2 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object2);
                    Name name = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2.visitEnum((ClassId)objectArray, name);
                }
            } else if (Intrinsics.areEqual(clazz, Class.class)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object3 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object3);
                    kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2.visitClassLiteral(this.classLiteralValue((Class)object3));
                }
            } else if (Annotation.class.isAssignableFrom(clazz)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object4 : (Object[])object) {
                    KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor;
                    Intrinsics.checkNotNull((Object)clazz);
                    if (kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2.visitAnnotation(ReflectClassUtilKt.getClassId(clazz)) == null) continue;
                    Intrinsics.checkNotNull((Object)object4);
                    this.processAnnotationArguments(kotlinJvmBinaryClass$AnnotationArgumentVisitor, (Annotation)object4, clazz);
                }
            } else {
                Intrinsics.checkNotNull((Object)object);
                for (Object object5 : (Object[])object) {
                    kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2.visit(object5);
                }
            }
            kotlinJvmBinaryClass$AnnotationArrayArgumentVisitor2.visitEnd();
            return;
        }
        throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + object);
    }
}

