/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl$loadAnnotation$1;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.text.StringsKt;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;
    private final AnnotationDeserializer annotationDeserializer;
    private JvmMetadataVersion jvmMetadataVersion;

    public BinaryClassAnnotationAndConstantLoaderImpl(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses, StorageManager storageManager, KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        super(storageManager, kotlinClassFinder);
        this.module = moduleDescriptor;
        this.notFoundClasses = notFoundClasses;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
        this.jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
    }

    @Override
    public final JvmMetadataVersion getJvmMetadataVersion() {
        return this.jvmMetadataVersion;
    }

    public final void setJvmMetadataVersion(JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        this.jvmMetadataVersion = jvmMetadataVersion;
    }

    @Override
    public final AnnotationDescriptor loadAnnotation(ProtoBuf$Annotation protoBuf$Annotation, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)protoBuf$Annotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        return this.annotationDeserializer.deserializeAnnotation(protoBuf$Annotation, nameResolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final ConstantValue<?> loadConstant(String object, Object object2) {
        Object object3;
        block11: {
            block8: {
                int n;
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)object, (String)"");
                        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
                        if (!StringsKt.contains$default((CharSequence)"ZBCS", (CharSequence)((CharSequence)object), (boolean)false, (int)2, null)) break block8;
                        n = (Integer)object2;
                        Object object4 = object;
                        switch (((String)object4).hashCode()) {
                            case 66: {
                                if (((String)object4).equals("B")) break;
                                throw new AssertionError(object);
                            }
                            case 67: {
                                if (!((String)object4).equals("C")) {
                                    throw new AssertionError(object);
                                }
                                break block9;
                            }
                            case 83: {
                                if (!((String)object4).equals("S")) {
                                    throw new AssertionError(object);
                                }
                                break block10;
                            }
                            case 90: {
                                if (!((String)object4).equals("Z")) throw new AssertionError(object);
                                object3 = n != 0;
                                break block11;
                            }
                        }
                        object3 = (byte)n;
                        break block11;
                    }
                    object3 = Character.valueOf((char)n);
                    break block11;
                }
                object3 = (short)n;
                break block11;
                throw new AssertionError(object);
            }
            object3 = object2;
        }
        object = object3;
        return ConstantValueFactory.INSTANCE.createConstantValue(object, this.module);
    }

    @Override
    protected final ConstantValue<?> transformToUnsignedConstant(ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"");
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof ByteValue) {
            return new UByteValue(((Number)((ByteValue)constantValue).getValue()).byteValue());
        }
        if (constantValue2 instanceof ShortValue) {
            return new UShortValue(((Number)((ShortValue)constantValue).getValue()).shortValue());
        }
        if (constantValue2 instanceof IntValue) {
            return new UIntValue(((Number)((IntValue)constantValue).getValue()).intValue());
        }
        if (constantValue2 instanceof LongValue) {
            return new ULongValue(((Number)((LongValue)constantValue).getValue()).longValue());
        }
        return constantValue;
    }

    @Override
    protected final KotlinJvmBinaryClass$AnnotationArgumentVisitor loadAnnotation(ClassId classId, SourceElement sourceElement, List<AnnotationDescriptor> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        ClassDescriptor classDescriptor = this.resolveClass(classId);
        return new BinaryClassAnnotationAndConstantLoaderImpl$loadAnnotation$1(this, classDescriptor, classId, list, sourceElement);
    }

    private final ConstantValue<?> createConstant(Name name, Object object) {
        ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(object, this.module);
        if (constantValue == null) {
            constantValue = ErrorValue.Companion.create("Unsupported annotation argument: " + name);
        }
        return constantValue;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public static final /* synthetic */ ConstantValue access$createConstant(BinaryClassAnnotationAndConstantLoaderImpl binaryClassAnnotationAndConstantLoaderImpl, Name name, Object object) {
        return binaryClassAnnotationAndConstantLoaderImpl.createConstant(name, object);
    }
}

