/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString$ByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$1;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$Balancer;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$PieceIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$RopeByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$RopeInputStream;

class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private int hash = 0;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = byteString.size();
        this.totalLength = this.leftLength + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        RopeByteString ropeByteString;
        RopeByteString ropeByteString2 = ropeByteString = byteString instanceof RopeByteString ? (RopeByteString)byteString : null;
        if (byteString2.size() != 0) {
            if (byteString.size() == 0) {
                byteString = byteString2;
            } else {
                int n = byteString.size() + byteString2.size();
                if (n < 128) {
                    byteString = RopeByteString.concatenateBytes(byteString, byteString2);
                } else if (ropeByteString != null && ropeByteString.right.size() + byteString2.size() < 128) {
                    LiteralByteString literalByteString = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                    byteString = new RopeByteString(ropeByteString.left, literalByteString);
                } else if (ropeByteString != null && ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                    RopeByteString ropeByteString3 = new RopeByteString(ropeByteString.right, byteString2);
                    byteString = new RopeByteString(ropeByteString.left, ropeByteString3);
                } else {
                    int n2 = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
                    byteString = n >= minLengthByDepth[n2] ? new RopeByteString(byteString, byteString2) : RopeByteString$Balancer.access$100(new RopeByteString$Balancer(null), byteString, byteString2);
                }
            }
        }
        return byteString;
    }

    private static LiteralByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        int n = byteString.size();
        int n2 = byteString2.size();
        byte[] byArray = new byte[n + n2];
        byteString.copyTo(byArray, 0, 0, n);
        byteString2.copyTo(byArray, 0, n, n2);
        return new LiteralByteString(byArray);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        if (n + n3 <= this.leftLength) {
            this.left.copyToInternal(byArray, n, n2, n3);
            return;
        }
        if (n >= this.leftLength) {
            this.right.copyToInternal(byArray, n - this.leftLength, n2, n3);
            return;
        }
        int n4 = this.leftLength - n;
        this.left.copyToInternal(byArray, n, n2, n4);
        this.right.copyToInternal(byArray, 0, n2 + n4, n3 - n4);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        if (n + n2 <= this.leftLength) {
            this.left.writeToInternal(outputStream, n, n2);
            return;
        }
        if (n >= this.leftLength) {
            this.right.writeToInternal(outputStream, n - this.leftLength, n2);
            return;
        }
        int n3 = this.leftLength - n;
        this.left.writeToInternal(outputStream, n, n3);
        this.right.writeToInternal(outputStream, 0, n2 - n3);
    }

    @Override
    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    @Override
    public boolean isValidUtf8() {
        int n = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        return (n = this.right.partialIsValidUtf8(n, 0, this.right.size())) == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialIsValidUtf8(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialIsValidUtf8(n, n2 - this.leftLength, n3);
        }
        n4 = this.leftLength - n2;
        n = this.left.partialIsValidUtf8(n, n2, n4);
        return this.right.partialIsValidUtf8(n, 0, n3 - n4);
    }

    public boolean equals(Object object) {
        int n;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (this.totalLength != ((ByteString)(object = (ByteString)object)).size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (n = ((ByteString)object).peekCachedHashCode()) != 0 && this.hash != n) {
            return false;
        }
        return this.equalsFragments((ByteString)object);
    }

    private boolean equalsFragments(ByteString object) {
        int n = 0;
        RopeByteString$PieceIterator ropeByteString$PieceIterator = new RopeByteString$PieceIterator(this, null);
        LiteralByteString literalByteString = (LiteralByteString)ropeByteString$PieceIterator.next();
        int n2 = 0;
        object = new RopeByteString$PieceIterator((ByteString)object, null);
        LiteralByteString literalByteString2 = (LiteralByteString)object.next();
        int n3 = 0;
        while (true) {
            int n4 = literalByteString.size() - n;
            int n5 = literalByteString2.size() - n2;
            int n6 = Math.min(n4, n5);
            boolean bl = n == 0 ? literalByteString.equalsRange(literalByteString2, n2, n6) : literalByteString2.equalsRange(literalByteString, n, n6);
            if (!bl) {
                return false;
            }
            if ((n3 += n6) >= this.totalLength) {
                if (n3 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                literalByteString = (LiteralByteString)ropeByteString$PieceIterator.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                n2 = 0;
                literalByteString2 = (LiteralByteString)object.next();
                continue;
            }
            n2 += n6;
        }
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.totalLength;
            if ((n = this.partialHash(n, 0, this.totalLength)) == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialHash(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialHash(n, n2 - this.leftLength, n3);
        }
        n4 = this.leftLength - n2;
        n = this.left.partialHash(n, n2, n4);
        return this.right.partialHash(n, 0, n3 - n4);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(new RopeByteString$RopeInputStream(this));
    }

    @Override
    public ByteString$ByteIterator iterator() {
        return new RopeByteString$RopeByteIterator(this, null);
    }

    /* synthetic */ RopeByteString(ByteString byteString, ByteString byteString2, RopeByteString$1 ropeByteString$1) {
        this(byteString, byteString2);
    }

    static /* synthetic */ ByteString access$400(RopeByteString ropeByteString) {
        return ropeByteString.left;
    }

    static /* synthetic */ ByteString access$500(RopeByteString ropeByteString) {
        return ropeByteString.right;
    }

    static /* synthetic */ int[] access$600() {
        return minLengthByDepth;
    }

    static {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 1;
        int n3 = 1;
        while (n3 > 0) {
            arrayList.add(n3);
            n = n2 + n3;
            n2 = n3;
            n3 = n;
        }
        arrayList.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[arrayList.size()];
        for (n = 0; n < minLengthByDepth.length; ++n) {
            RopeByteString.minLengthByDepth[n] = (Integer)arrayList.get(n);
        }
    }
}

