/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char c) {
        super(Character.valueOf(c));
    }

    @Override
    public final SimpleType getType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        SimpleType simpleType2 = moduleDescriptor.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        return simpleType2;
    }

    @Override
    public final String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = (int)((Character)this.getValue()).charValue();
        CharValue charValue = this;
        objectArray2[1] = charValue.getPrintablePart(((Character)charValue.getValue()).charValue());
        String string2 = String.format(string, Arrays.copyOf(objectArray2, 2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    private final String getPrintablePart(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (this.isPrintableUnicode(c)) {
            return String.valueOf(c);
        }
        return "?";
    }

    private final boolean isPrintableUnicode(char c) {
        byte by = (byte)Character.getType(c);
        c = (char)by;
        return by != 0 && c != '\r' && c != '\u000e' && c != '\u000f' && c != '\u0010' && c != '\u0012' && c != '\u0013';
    }
}

