/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;

public final class ClassLiteralValue {
    private final ClassId classId;
    private final int arrayNestedness;

    public ClassLiteralValue(ClassId classId, int n) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        this.classId = classId;
        this.arrayNestedness = n;
    }

    public final ClassId getClassId() {
        return this.classId;
    }

    public final int getArrayNestedness() {
        return this.arrayNestedness;
    }

    public final String toString() {
        int n;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        int n2 = this.arrayNestedness;
        for (n = 0; n < n2; ++n) {
            stringBuilder2.append("kotlin/Array<");
        }
        stringBuilder2.append(this.classId);
        n2 = this.arrayNestedness;
        for (n = 0; n < n2; ++n) {
            stringBuilder2.append(">");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final ClassId component1() {
        return this.classId;
    }

    public final int component2() {
        return this.arrayNestedness;
    }

    public final int hashCode() {
        int n = this.classId.hashCode();
        n = n * 31 + Integer.hashCode(this.arrayNestedness);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassLiteralValue)) {
            return false;
        }
        object = (ClassLiteralValue)object;
        if (!Intrinsics.areEqual((Object)this.classId, (Object)((ClassLiteralValue)object).classId)) {
            return false;
        }
        return this.arrayNestedness == ((ClassLiteralValue)object).arrayNestedness;
    }
}

