/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState$ForkPointContext;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState$ForkPointContext$Default;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState$LowerCapturedTypePolicy;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    private final TypeSystemContext typeSystemContext;
    private final AbstractTypePreparator kotlinTypePreparator;
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleTypeMarker> supertypesDeque;
    private Set<SimpleTypeMarker> supertypesSet;

    public TypeCheckerState(boolean bl, boolean bl2, boolean bl3, TypeSystemContext typeSystemContext, AbstractTypePreparator abstractTypePreparator, AbstractTypeRefiner abstractTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractTypePreparator, (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractTypeRefiner, (String)"");
        this.isErrorTypeEqualsToAnything = bl;
        this.isStubTypeEqualsToAnything = bl2;
        this.allowedTypeVariable = bl3;
        this.typeSystemContext = typeSystemContext;
        this.kotlinTypePreparator = abstractTypePreparator;
        this.kotlinTypeRefiner = abstractTypeRefiner;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    public final KotlinTypeMarker refineType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.kotlinTypeRefiner.refineType(kotlinTypeMarker);
    }

    public final KotlinTypeMarker prepareType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.kotlinTypePreparator.prepareType(kotlinTypeMarker);
    }

    public boolean customIsSubtypeOf(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return true;
    }

    public TypeCheckerState$LowerCapturedTypePolicy getLowerCapturedTypePolicy(SimpleTypeMarker simpleTypeMarker, CapturedTypeMarker capturedTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)simpleTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)capturedTypeMarker, (String)"");
        return TypeCheckerState$LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    public Boolean addSubtypeConstraint(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    public boolean runForkingPoint(Function1<? super TypeCheckerState$ForkPointContext, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        TypeCheckerState$ForkPointContext$Default typeCheckerState$ForkPointContext$Default = new TypeCheckerState$ForkPointContext$Default();
        function1.invoke((Object)typeCheckerState$ForkPointContext$Default);
        return typeCheckerState$ForkPointContext$Default.getResult();
    }

    public final ArrayDeque<SimpleTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    public final Set<SimpleTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new AssertionError((Object)string);
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    public final void clear() {
        ArrayDeque<SimpleTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<SimpleTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean isAllowedTypeVariable(KotlinTypeMarker kotlinTypeMarker) {
        TypeSystemContext typeSystemContext;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.allowedTypeVariable && (typeSystemContext = this.typeSystemContext).isTypeVariableType(kotlinTypeMarker);
    }

    public static final /* synthetic */ int access$getArgumentsDepth(TypeCheckerState typeCheckerState) {
        return typeCheckerState.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth(TypeCheckerState typeCheckerState, int n) {
        typeCheckerState.argumentsDepth = n;
    }
}

