/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Check$DefaultImpls;

final class IsKPropertyCheck
implements Check {
    public static final IsKPropertyCheck INSTANCE = new IsKPropertyCheck();
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";

    private IsKPropertyCheck() {
    }

    @Override
    public final String getDescription() {
        return description;
    }

    @Override
    public final boolean check(FunctionDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        callableDescriptor = callableDescriptor.getValueParameters().get(1);
        Intrinsics.checkNotNull((Object)callableDescriptor);
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(callableDescriptor));
        if (kotlinType != null) {
            KotlinType kotlinType2 = callableDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
            return TypeUtilsKt.isSubtypeOf(kotlinType, TypeUtilsKt.makeNotNullable(kotlinType2));
        }
        return false;
    }

    @Override
    public final String invoke(FunctionDescriptor functionDescriptor) {
        return Check$DefaultImpls.invoke(this, functionDescriptor);
    }
}

