/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.List;
import org.quartz.core.JobRunShellFactory;
import org.quartz.management.ManagementRESTServiceConfiguration;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;

public class QuartzSchedulerResources {
    public static final String CREATE_REGISTRY_NEVER = "never";
    public static final String CREATE_REGISTRY_ALWAYS = "always";
    public static final String CREATE_REGISTRY_AS_NEEDED = "as_needed";
    private String name;
    private String instanceId;
    private String threadName;
    private String rmiRegistryHost = null;
    private int rmiRegistryPort = 1099;
    private int rmiServerPort = -1;
    private String rmiCreateRegistryStrategy = "never";
    private ThreadPool threadPool;
    private JobStore jobStore;
    private JobRunShellFactory jobRunShellFactory;
    private List<SchedulerPlugin> schedulerPlugins = new ArrayList<SchedulerPlugin>(10);
    private boolean makeSchedulerThreadDaemon = false;
    private boolean threadsInheritInitializersClassLoadContext = false;
    private String rmiBindName;
    private boolean jmxExport;
    private String jmxObjectName;
    private ManagementRESTServiceConfiguration managementRESTServiceConfiguration;
    private ThreadExecutor threadExecutor;
    private long batchTimeWindow = 0L;
    private int maxBatchSize = 1;
    private boolean interruptJobsOnShutdown = false;
    private boolean interruptJobsOnShutdownWithWait = false;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler name cannot be empty.");
        }
        this.name = string;
        if (this.threadName == null) {
            this.setThreadName(string + "_QuartzSchedulerThread");
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler instanceId cannot be empty.");
        }
        this.instanceId = string;
    }

    public static String getUniqueIdentifier(String string, String string2) {
        return string + "_$_" + string2;
    }

    public String getUniqueIdentifier() {
        return QuartzSchedulerResources.getUniqueIdentifier(this.name, this.instanceId);
    }

    public String getRMIRegistryHost() {
        return this.rmiRegistryHost;
    }

    public void setRMIRegistryHost(String string) {
        this.rmiRegistryHost = string;
    }

    public int getRMIRegistryPort() {
        return this.rmiRegistryPort;
    }

    public void setRMIRegistryPort(int n) {
        this.rmiRegistryPort = n;
    }

    public int getRMIServerPort() {
        return this.rmiServerPort;
    }

    public void setRMIServerPort(int n) {
        this.rmiServerPort = n;
    }

    public String getRMICreateRegistryStrategy() {
        return this.rmiCreateRegistryStrategy;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler thread name cannot be empty.");
        }
        this.threadName = string;
    }

    public void setRMICreateRegistryStrategy(String string) {
        if (string == null || string.trim().length() == 0) {
            string = CREATE_REGISTRY_NEVER;
        } else if (string.equalsIgnoreCase("true")) {
            string = CREATE_REGISTRY_AS_NEEDED;
        } else if (string.equalsIgnoreCase("false")) {
            string = CREATE_REGISTRY_NEVER;
        } else if (string.equalsIgnoreCase(CREATE_REGISTRY_ALWAYS)) {
            string = CREATE_REGISTRY_ALWAYS;
        } else if (string.equalsIgnoreCase(CREATE_REGISTRY_AS_NEEDED)) {
            string = CREATE_REGISTRY_AS_NEEDED;
        } else if (string.equalsIgnoreCase(CREATE_REGISTRY_NEVER)) {
            string = CREATE_REGISTRY_NEVER;
        } else {
            throw new IllegalArgumentException("Faild to set RMICreateRegistryStrategy - strategy unknown: '" + string + "'");
        }
        this.rmiCreateRegistryStrategy = string;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (threadPool == null) {
            throw new IllegalArgumentException("ThreadPool cannot be null.");
        }
        this.threadPool = threadPool;
    }

    public JobStore getJobStore() {
        return this.jobStore;
    }

    public void setJobStore(JobStore jobStore) {
        if (jobStore == null) {
            throw new IllegalArgumentException("JobStore cannot be null.");
        }
        this.jobStore = jobStore;
    }

    public JobRunShellFactory getJobRunShellFactory() {
        return this.jobRunShellFactory;
    }

    public void setJobRunShellFactory(JobRunShellFactory jobRunShellFactory) {
        if (jobRunShellFactory == null) {
            throw new IllegalArgumentException("JobRunShellFactory cannot be null.");
        }
        this.jobRunShellFactory = jobRunShellFactory;
    }

    public void addSchedulerPlugin(SchedulerPlugin schedulerPlugin) {
        this.schedulerPlugins.add(schedulerPlugin);
    }

    public List<SchedulerPlugin> getSchedulerPlugins() {
        return this.schedulerPlugins;
    }

    public boolean getMakeSchedulerThreadDaemon() {
        return this.makeSchedulerThreadDaemon;
    }

    public void setMakeSchedulerThreadDaemon(boolean bl) {
        this.makeSchedulerThreadDaemon = bl;
    }

    public boolean isThreadsInheritInitializersClassLoadContext() {
        return this.threadsInheritInitializersClassLoadContext;
    }

    public void setThreadsInheritInitializersClassLoadContext(boolean bl) {
        this.threadsInheritInitializersClassLoadContext = bl;
    }

    public String getRMIBindName() {
        if (this.rmiBindName == null) {
            return this.getUniqueIdentifier();
        }
        return this.rmiBindName;
    }

    public void setRMIBindName(String string) {
        this.rmiBindName = string;
    }

    public boolean getJMXExport() {
        return this.jmxExport;
    }

    public void setJMXExport(boolean bl) {
        this.jmxExport = bl;
    }

    public String getJMXObjectName() {
        if (this.jmxObjectName == null) {
            return QuartzSchedulerResources.generateJMXObjectName(this.name, this.instanceId);
        }
        return this.jmxObjectName;
    }

    public void setJMXObjectName(String string) {
        this.jmxObjectName = string;
    }

    public ThreadExecutor getThreadExecutor() {
        return this.threadExecutor;
    }

    public void setThreadExecutor(ThreadExecutor threadExecutor) {
        this.threadExecutor = threadExecutor;
    }

    public static String generateJMXObjectName(String string, String string2) {
        return "quartz:type=QuartzScheduler,name=" + string.replaceAll(":|=|\n", ".") + ",instance=" + string2;
    }

    public long getBatchTimeWindow() {
        return this.batchTimeWindow;
    }

    public void setBatchTimeWindow(long l) {
        this.batchTimeWindow = l;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int n) {
        this.maxBatchSize = n;
    }

    public boolean isInterruptJobsOnShutdown() {
        return this.interruptJobsOnShutdown;
    }

    public void setInterruptJobsOnShutdown(boolean bl) {
        this.interruptJobsOnShutdown = bl;
    }

    public boolean isInterruptJobsOnShutdownWithWait() {
        return this.interruptJobsOnShutdownWithWait;
    }

    public void setInterruptJobsOnShutdownWithWait(boolean bl) {
        this.interruptJobsOnShutdownWithWait = bl;
    }

    public ManagementRESTServiceConfiguration getManagementRESTServiceConfiguration() {
        return this.managementRESTServiceConfiguration;
    }

    public void setManagementRESTServiceConfiguration(ManagementRESTServiceConfiguration managementRESTServiceConfiguration) {
        this.managementRESTServiceConfiguration = managementRESTServiceConfiguration;
    }
}

