/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class MonthlyCalendar
extends BaseCalendar
implements Serializable,
Calendar {
    static final long serialVersionUID = 419164961091807944L;
    private static final int MAX_DAYS_IN_MONTH = 31;
    private boolean[] excludeDays = new boolean[31];
    private boolean excludeAll = this.areAllDaysExcluded();

    public MonthlyCalendar() {
        this(null, null);
    }

    public MonthlyCalendar(Calendar calendar) {
        this(calendar, null);
    }

    public MonthlyCalendar(TimeZone timeZone) {
        this(null, timeZone);
    }

    public MonthlyCalendar(Calendar calendar, TimeZone timeZone) {
        super(calendar, timeZone);
    }

    @Override
    public Object clone() {
        MonthlyCalendar monthlyCalendar = (MonthlyCalendar)super.clone();
        ((MonthlyCalendar)super.clone()).excludeDays = (boolean[])this.excludeDays.clone();
        return monthlyCalendar;
    }

    public boolean[] getDaysExcluded() {
        return this.excludeDays;
    }

    public boolean isDayExcluded(int n) {
        if (n <= 0 || n > 31) {
            throw new IllegalArgumentException("The day parameter must be in the range of 1 to 31");
        }
        return this.excludeDays[n - 1];
    }

    public void setDaysExcluded(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The days parameter cannot be null.");
        }
        if (blArray.length < 31) {
            throw new IllegalArgumentException("The days parameter must have a length of at least 31 elements.");
        }
        this.excludeDays = blArray;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public void setDayExcluded(int n, boolean bl) {
        if (n <= 0 || n > 31) {
            throw new IllegalArgumentException("The day parameter must be in the range of 1 to 31");
        }
        this.excludeDays[n - 1] = bl;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public boolean areAllDaysExcluded() {
        for (int i = 1; i <= 31; ++i) {
            if (this.isDayExcluded(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.excludeAll) {
            return false;
        }
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        java.util.Calendar calendar = this.createJavaCalendar(l);
        int n = calendar.get(5);
        return !this.isDayExcluded(n);
    }

    @Override
    public long getNextIncludedTime(long l) {
        java.util.Calendar calendar;
        int n;
        if (this.excludeAll) {
            return 0L;
        }
        long l2 = super.getNextIncludedTime(l);
        if (l2 > 0L && l2 > l) {
            l = l2;
        }
        if (!this.isDayExcluded(n = (calendar = this.getStartOfDayJavaCalendar(l)).get(5))) {
            return l;
        }
        while (this.isDayExcluded(n)) {
            calendar.add(5, 1);
            n = calendar.get(5);
        }
        return calendar.getTime().getTime();
    }
}

