/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$RecoverMisfiredJobsResult;
import org.quartz.spi.ThreadExecutor;

class JobStoreSupport$MisfireHandler
extends Thread {
    private volatile boolean shutdown = false;
    private int numFails = 0;
    final /* synthetic */ JobStoreSupport this$0;

    JobStoreSupport$MisfireHandler(JobStoreSupport jobStoreSupport) {
        this.this$0 = jobStoreSupport;
        this.setName("QuartzScheduler_" + jobStoreSupport.instanceName + "-" + jobStoreSupport.instanceId + "_MisfireHandler");
        this.setDaemon(jobStoreSupport.getMakeThreadsDaemons());
    }

    public void initialize() {
        ThreadExecutor threadExecutor = this.this$0.getThreadExecutor();
        threadExecutor.execute(this);
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    private JobStoreSupport$RecoverMisfiredJobsResult manage() {
        try {
            this.this$0.getLog().debug("MisfireHandler: scanning for misfires...");
            JobStoreSupport$RecoverMisfiredJobsResult jobStoreSupport$RecoverMisfiredJobsResult = this.this$0.doRecoverMisfires();
            this.numFails = 0;
            return jobStoreSupport$RecoverMisfiredJobsResult;
        }
        catch (Exception exception) {
            if (this.numFails % 4 == 0) {
                this.this$0.getLog().error("MisfireHandler: Error handling misfires: " + exception.getMessage(), (Throwable)exception);
            }
            ++this.numFails;
            return JobStoreSupport$RecoverMisfiredJobsResult.NO_OP;
        }
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            long l = System.currentTimeMillis();
            JobStoreSupport$RecoverMisfiredJobsResult jobStoreSupport$RecoverMisfiredJobsResult = this.manage();
            if (jobStoreSupport$RecoverMisfiredJobsResult.getProcessedMisfiredTriggerCount() > 0) {
                this.this$0.signalSchedulingChangeImmediately(jobStoreSupport$RecoverMisfiredJobsResult.getEarliestNewTime());
            }
            if (this.shutdown) continue;
            long l2 = 50L;
            if (!jobStoreSupport$RecoverMisfiredJobsResult.hasMoreMisfiredTriggers()) {
                l2 = this.this$0.getMisfireThreshold() - (System.currentTimeMillis() - l);
                if (l2 <= 0L) {
                    l2 = 50L;
                }
                if (this.numFails > 0) {
                    l2 = Math.max(this.this$0.getDbRetryInterval(), l2);
                }
            }
            try {
                Thread.sleep(l2);
            }
            catch (Exception exception) {}
        }
    }
}

