/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSemaphore
implements Semaphore {
    ThreadLocal<HashSet<String>> lockOwners = new ThreadLocal();
    HashSet<String> locks = new HashSet();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    private HashSet<String> getThreadLocks() {
        HashSet<String> hashSet = this.lockOwners.get();
        if (hashSet == null) {
            hashSet = new HashSet();
            this.lockOwners.set(hashSet);
        }
        return hashSet;
    }

    @Override
    public synchronized boolean obtainLock(Connection connection, String string) {
        string = string.intern();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' is desired by: " + Thread.currentThread().getName());
        }
        if (!this.isLockOwner(string)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '" + string + "' is being obtained: " + Thread.currentThread().getName());
            }
            while (this.locks.contains(string)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Lock '" + string + "' was not obtained by: " + Thread.currentThread().getName());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '" + string + "' given to: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().add(string);
            this.locks.add(string);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' already owned by: " + Thread.currentThread().getName() + " -- but not owner!", (Throwable)new Exception("stack-trace of wrongful returner"));
        }
        return true;
    }

    @Override
    public synchronized void releaseLock(String string) {
        if (this.isLockOwner(string = string.intern())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + string + "' retuned by: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(string);
            this.locks.remove(string);
            this.notifyAll();
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Lock '" + string + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!", (Throwable)new Exception("stack-trace of wrongful returner"));
        }
    }

    public synchronized boolean isLockOwner(String string) {
        string = string.intern();
        return this.getThreadLocks().contains(string);
    }

    @Override
    public boolean requiresConnection() {
        return false;
    }
}

