/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.triggers;

import java.util.Date;
import org.quartz.Calendar;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CoreTrigger;

public class SimpleTriggerImpl
extends AbstractTrigger<SimpleTrigger>
implements SimpleTrigger,
CoreTrigger {
    private static final long serialVersionUID = -3735980074222850397L;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = java.util.Calendar.getInstance().get(1) + 100;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatCount = 0;
    private long repeatInterval = 0L;
    private int timesTriggered = 0;
    private boolean complete = false;

    public SimpleTriggerImpl() {
    }

    @Deprecated
    public SimpleTriggerImpl(String string) {
        this(string, (String)null);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, String string2) {
        this(string, string2, new Date(), null, 0, 0L);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, int n, long l) {
        this(string, null, n, l);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, String string2, int n, long l) {
        this(string, string2, new Date(), null, n, l);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, Date date) {
        this(string, null, date);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, String string2, Date date) {
        this(string, string2, date, null, 0, 0L);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, Date date, Date date2, int n, long l) {
        this(string, null, date, date2, n, l);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, String string2, Date date, Date date2, int n, long l) {
        super(string, string2);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatCount(n);
        this.setRepeatInterval(l);
    }

    @Deprecated
    public SimpleTriggerImpl(String string, String string2, String string3, String string4, Date date, Date date2, int n, long l) {
        super(string, string2, string3, string4);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatCount(n);
        this.setRepeatInterval(l);
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date date2 = this.getEndTime();
        if (date2 != null && date != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = date;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = date;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int n) {
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.repeatCount = n;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Repeat interval must be >= 0");
        }
        this.repeatInterval = l;
    }

    @Override
    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.timesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(int n) {
        if (n < -1) {
            return false;
        }
        return n <= 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateAfterMisfire(Calendar calendar) {
        int n = this.getMisfireInstruction();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            n = this.getRepeatCount() == 0 ? 1 : (this.getRepeatCount() == -1 ? 4 : 2);
        } else if (n == 1 && this.getRepeatCount() != 0) {
            n = 3;
        }
        if (n == 1) {
            this.setNextFireTime(new Date());
            return;
        }
        if (n == 5) {
            Date date = this.getFireTimeAfter(new Date());
            while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime()) && (date = this.getFireTimeAfter(date)) != null) {
                java.util.Calendar calendar2 = java.util.Calendar.getInstance();
                calendar2.setTime(date);
                if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
                date = null;
            }
            this.setNextFireTime(date);
            return;
        }
        if (n == 4) {
            Date date = this.getFireTimeAfter(new Date());
            while (date != null && calendar != null && !calendar.isTimeIncluded(date.getTime()) && (date = this.getFireTimeAfter(date)) != null) {
                java.util.Calendar calendar3 = java.util.Calendar.getInstance();
                calendar3.setTime(date);
                if (calendar3.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
                date = null;
            }
            if (date != null) {
                SimpleTriggerImpl simpleTriggerImpl = this;
                int n2 = simpleTriggerImpl.computeNumTimesFiredBetween(simpleTriggerImpl.nextFireTime, date);
                SimpleTriggerImpl simpleTriggerImpl2 = this;
                simpleTriggerImpl2.setTimesTriggered(simpleTriggerImpl2.getTimesTriggered() + n2);
            }
            this.setNextFireTime(date);
            return;
        }
        if (n == 2) {
            Date date = new Date();
            if (this.repeatCount != 0 && this.repeatCount != -1) {
                SimpleTriggerImpl simpleTriggerImpl = this;
                simpleTriggerImpl.setRepeatCount(simpleTriggerImpl.getRepeatCount() - this.getTimesTriggered());
                this.setTimesTriggered(0);
            }
            if (this.getEndTime() != null && this.getEndTime().before(date)) {
                this.setNextFireTime(null);
                return;
            }
            this.setStartTime(date);
            this.setNextFireTime(date);
            return;
        }
        if (n != 3) return;
        Date date = new Date();
        SimpleTriggerImpl simpleTriggerImpl = this;
        int n3 = simpleTriggerImpl.computeNumTimesFiredBetween(simpleTriggerImpl.nextFireTime, date);
        if (this.repeatCount != 0 && this.repeatCount != -1) {
            int n4 = this.getRepeatCount() - (this.getTimesTriggered() + n3);
            if (n4 <= 0) {
                n4 = 0;
            }
            this.setRepeatCount(n4);
            this.setTimesTriggered(0);
        }
        if (this.getEndTime() != null && this.getEndTime().before(date)) {
            this.setNextFireTime(null);
            return;
        }
        this.setStartTime(date);
        this.setNextFireTime(date);
    }

    @Override
    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            this.nextFireTime = null;
        }
    }

    @Override
    public void updateWithNewCalendar(Calendar calendar, long l) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date date = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long l2;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(date) || (l2 = date.getTime() - this.nextFireTime.getTime()) < l) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            return null;
        }
        return this.nextFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.nextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.previousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(Date date) {
        if (this.complete) {
            return null;
        }
        if (this.timesTriggered > this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        if (date == null) {
            date = new Date();
        }
        if (this.repeatCount == 0 && date.compareTo(this.getStartTime()) >= 0) {
            return null;
        }
        long l = this.getStartTime().getTime();
        long l2 = date.getTime();
        long l3 = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (l3 <= l2) {
            return null;
        }
        if (l2 < l) {
            return new Date(l);
        }
        long l4 = (l2 - l) / this.repeatInterval + 1L;
        if (l4 > (long)this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        date = new Date(l + l4 * this.repeatInterval);
        if (l3 <= date.getTime()) {
            return null;
        }
        return date;
    }

    public Date getFireTimeBefore(Date date) {
        if (date.getTime() < this.getStartTime().getTime()) {
            return null;
        }
        SimpleTriggerImpl simpleTriggerImpl = this;
        int n = simpleTriggerImpl.computeNumTimesFiredBetween(simpleTriggerImpl.getStartTime(), date);
        return new Date(this.getStartTime().getTime() + (long)n * this.repeatInterval);
    }

    public int computeNumTimesFiredBetween(Date date, Date date2) {
        if (this.repeatInterval < 1L) {
            return 0;
        }
        long l = date2.getTime() - date.getTime();
        return (int)(l / this.repeatInterval);
    }

    @Override
    public Date getFinalFireTime() {
        if (this.repeatCount == 0) {
            return this.startTime;
        }
        if (this.repeatCount == -1) {
            if (this.getEndTime() == null) {
                return null;
            }
            SimpleTriggerImpl simpleTriggerImpl = this;
            return simpleTriggerImpl.getFireTimeBefore(simpleTriggerImpl.getEndTime());
        }
        long l = this.startTime.getTime() + (long)this.repeatCount * this.repeatInterval;
        if (this.getEndTime() == null || l < this.getEndTime().getTime()) {
            return new Date(l);
        }
        SimpleTriggerImpl simpleTriggerImpl = this;
        return simpleTriggerImpl.getFireTimeBefore(simpleTriggerImpl.getEndTime());
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.repeatCount != 0 && this.repeatInterval < 1L) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    @Override
    public boolean hasAdditionalProperties() {
        return false;
    }

    @Override
    public ScheduleBuilder<SimpleTrigger> getScheduleBuilder() {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.getRepeatInterval()).withRepeatCount(this.getRepeatCount());
        switch (this.getMisfireInstruction()) {
            case 1: {
                simpleScheduleBuilder.withMisfireHandlingInstructionFireNow();
                break;
            }
            case 5: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNextWithExistingCount();
                break;
            }
            case 4: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                break;
            }
            case 2: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNowWithExistingCount();
                break;
            }
            case 3: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
            }
        }
        return simpleScheduleBuilder;
    }
}

