/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.interrupt;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.plugins.interrupt.JobInterruptMonitorPlugin$InterruptMonitor;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInterruptMonitorPlugin
extends TriggerListenerSupport
implements SchedulerPlugin {
    private static final String JOB_INTERRUPT_MONITOR_KEY = "JOB_INTERRUPT_MONITOR_KEY";
    private long DEFAULT_MAX_RUNTIME = 300000L;
    private String name;
    private ScheduledExecutorService executor;
    private ScheduledFuture future;
    private Scheduler scheduler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String AUTO_INTERRUPTIBLE = "AutoInterruptable";
    public static final String MAX_RUN_TIME = "MaxRunTime";

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public ScheduledFuture scheduleJobInterruptMonitor(JobKey jobKey, long l) {
        return this.executor.schedule(new JobInterruptMonitorPlugin$InterruptMonitor(jobKey, this.scheduler), l, TimeUnit.MILLISECONDS);
    }

    public long getDefaultMaxRunTime() {
        return this.DEFAULT_MAX_RUNTIME;
    }

    public void setDefaultMaxRunTime(long l) {
        this.DEFAULT_MAX_RUNTIME = l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void triggerFired(Trigger object, JobExecutionContext jobExecutionContext) {
        try {
            if (jobExecutionContext.getJobDetail().getJobDataMap().getBoolean(AUTO_INTERRUPTIBLE)) {
                object = (JobInterruptMonitorPlugin)jobExecutionContext.getScheduler().getContext().get(JOB_INTERRUPT_MONITOR_KEY);
                long l = this.DEFAULT_MAX_RUNTIME;
                if (jobExecutionContext.getJobDetail().getJobDataMap().get(MAX_RUN_TIME) != null) {
                    l = jobExecutionContext.getJobDetail().getJobDataMap().getLong(MAX_RUN_TIME);
                }
                this.future = ((JobInterruptMonitorPlugin)object).scheduleJobInterruptMonitor(jobExecutionContext.getJobDetail().getKey(), l);
                this.getLog().debug("Job's Interrupt Monitor has been scheduled to interrupt with the delay :" + this.DEFAULT_MAX_RUNTIME);
            }
            return;
        }
        catch (SchedulerException schedulerException) {
            this.getLog().info("Error scheduling interrupt monitor " + schedulerException.getMessage(), (Throwable)schedulerException);
            return;
        }
    }

    @Override
    public void triggerComplete(Trigger trigger, JobExecutionContext jobExecutionContext, Trigger$CompletedExecutionInstruction trigger$CompletedExecutionInstruction) {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    @Override
    public void initialize(String string, Scheduler scheduler, ClassLoadHelper classLoadHelper) {
        this.getLog().info("Registering Job Interrupt Monitor Plugin");
        this.name = string;
        this.executor = Executors.newScheduledThreadPool(1);
        scheduler.getContext().put(JOB_INTERRUPT_MONITOR_KEY, (Object)this);
        this.scheduler = scheduler;
        this.scheduler.getListenerManager().addTriggerListener(this);
    }
}

