/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.sanity;

import ch.qos.logback.core.joran.sanity.Pair;
import ch.qos.logback.core.joran.sanity.SanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AppenderWithinAppenderSanityChecker
extends ContextAwareBase
implements SanityChecker {
    public static String NESTED_APPENDERS_WARNING = "As of logback version 1.3, nested appenders are not allowed.";

    @Override
    public void check(Model object) {
        if (object == null) {
            return;
        }
        Object object2 = new ArrayList<Model>();
        this.deepFindAllModelsOfType((Class<? extends Model>)AppenderModel.class, (List<Model>)object2, (Model)object);
        object = this.deepFindNestedSubModelsOfType((Class<? extends Model>)AppenderModel.class, (List<? extends Model>)object2);
        object = object.stream().filter(pair -> !this.isSiftingAppender((Model)pair.first)).collect(Collectors.toList());
        if (object.isEmpty()) {
            return;
        }
        this.addWarn(NESTED_APPENDERS_WARNING);
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Pair)object.next();
            this.addWarn("Appender at line " + ((Model)((Pair)object2).first).getLineNumber() + " contains a nested appender at line " + ((Model)((Pair)object2).second).getLineNumber());
        }
    }

    private boolean isSiftingAppender(Model model) {
        if (model instanceof AppenderModel) {
            String string = ((ComponentModel)(model = (AppenderModel)model)).getClassName();
            if (string == null) {
                return false;
            }
            return ((ComponentModel)model).getClassName().contains("SiftingAppender");
        }
        return false;
    }
}

