/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.PhaseIndicator;
import ch.qos.logback.core.model.processor.ProcessingPhase;

@PhaseIndicator(phase=ProcessingPhase.DEPENDENCY_ANALYSIS)
public class RefContainerDependencyAnalyser
extends ModelHandlerBase {
    final Class<?> modelClass;

    public RefContainerDependencyAnalyser(Context context, Class<?> clazz) {
        super(context);
        this.modelClass = clazz;
    }

    @Override
    protected boolean isSupportedModelType(Model serializable) {
        if (this.modelClass.isInstance(serializable)) {
            return true;
        }
        serializable = new StringBuilder("This handler can only handle models of type ");
        ((StringBuilder)serializable).append(this.modelClass.getName());
        this.addError(((StringBuilder)serializable).toString());
        return false;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        modelInterpretationContext.pushModel(model);
    }

    @Override
    public void postHandle(ModelInterpretationContext object, Model model) {
        if (model != (object = ((ModelInterpretationContext)object).popModel())) {
            this.addError("Popped model [" + String.valueOf(object) + "] different than expected [" + String.valueOf(model) + "]");
        }
    }
}

