/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.LoginAuthenticator;
import ch.qos.logback.core.net.SMTPAppenderBase$SenderRunnable;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.sift.DefaultDiscriminator;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.util.ContentTypeUtil;
import ch.qos.logback.core.util.JNDIUtil;
import ch.qos.logback.core.util.OptionHelper;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.naming.Context;

public abstract class SMTPAppenderBase<E>
extends AppenderBase<E> {
    static InternetAddress[] EMPTY_IA_ARRAY = new InternetAddress[0];
    static final long MAX_DELAY_BETWEEN_STATUS_MESSAGES = 1228800000L;
    long lastTrackerStatusPrint = 0L;
    long delayBetweenStatusMessages = 300000L;
    protected Layout<E> subjectLayout;
    protected Layout<E> layout;
    private List<PatternLayoutBase<E>> toPatternLayoutList = new ArrayList<PatternLayoutBase<E>>();
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    private int smtpPort = 25;
    private boolean starttls = false;
    private boolean ssl = false;
    private boolean sessionViaJNDI = false;
    private String jndiLocation = "java:comp/env/mail/Session";
    String username;
    String password;
    String localhost;
    boolean asynchronousSending = true;
    protected Future<?> asynchronousSendingFuture = null;
    private String charsetEncoding = "UTF-8";
    protected Session session;
    protected EventEvaluator<E> eventEvaluator;
    protected Discriminator<E> discriminator = new DefaultDiscriminator();
    protected CyclicBufferTracker<E> cbTracker;
    private int errorCount = 0;

    protected abstract Layout<E> makeSubjectLayout(String var1);

    @Override
    public void start() {
        if (this.cbTracker == null) {
            this.cbTracker = new CyclicBufferTracker();
        }
        this.session = this.sessionViaJNDI ? this.lookupSessionInJNDI() : this.buildSessionFromProperties();
        if (this.session == null) {
            this.addError("Failed to obtain javax.mail.Session. Cannot start.");
            return;
        }
        this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
        this.started = true;
    }

    private Session lookupSessionInJNDI() {
        SMTPAppenderBase sMTPAppenderBase = this;
        sMTPAppenderBase.addInfo("Looking up javax.mail.Session at JNDI location [" + sMTPAppenderBase.jndiLocation + "]");
        try {
            Object object = JNDIUtil.getInitialContext();
            object = JNDIUtil.lookupObject((Context)object, this.jndiLocation);
            return (Session)object;
        }
        catch (Exception exception) {
            SMTPAppenderBase sMTPAppenderBase2 = this;
            sMTPAppenderBase2.addError("Failed to obtain javax.mail.Session from JNDI location [" + sMTPAppenderBase2.jndiLocation + "]", exception);
            return null;
        }
    }

    private Session buildSessionFromProperties() {
        Properties properties = new Properties(OptionHelper.getSystemProperties());
        if (this.smtpHost != null) {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        properties.put("mail.smtp.port", Integer.toString(this.smtpPort));
        if (this.localhost != null) {
            properties.put("mail.smtp.localhost", this.localhost);
        }
        LoginAuthenticator loginAuthenticator = null;
        if (!OptionHelper.isNullOrEmpty(this.username)) {
            loginAuthenticator = new LoginAuthenticator(this.username, this.password);
            properties.put("mail.smtp.auth", "true");
        }
        if (this.isSTARTTLS() && this.isSSL()) {
            this.addError("Both SSL and StartTLS cannot be enabled simultaneously");
        } else {
            if (this.isSTARTTLS()) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.transport.protocol", "true");
            }
            if (this.isSSL()) {
                properties.put("mail.smtp.ssl.enable", "true");
            }
        }
        return Session.getInstance((Properties)properties, (Authenticator)loginAuthenticator);
    }

    @Override
    protected void append(E e) {
        long l;
        String string;
        block9: {
            if (!this.checkEntryConditions()) {
                return;
            }
            string = this.discriminator.getDiscriminatingValue(e);
            l = System.currentTimeMillis();
            Object object = (CyclicBuffer)this.cbTracker.getOrCreate(string, l);
            this.subAppend((CyclicBuffer<E>)object, e);
            try {
                if (this.eventEvaluator.evaluate(e)) {
                    CyclicBuffer cyclicBuffer = new CyclicBuffer(object);
                    ((CyclicBuffer)object).clear();
                    if (this.asynchronousSending) {
                        object = new SMTPAppenderBase$SenderRunnable(this, cyclicBuffer, e);
                        this.asynchronousSendingFuture = this.context.getExecutorService().submit((Runnable)object);
                    } else {
                        this.sendBuffer(cyclicBuffer, e);
                    }
                }
            }
            catch (EvaluationException evaluationException) {
                ++this.errorCount;
                if (this.errorCount >= 4) break block9;
                this.addError("SMTPAppender's EventEvaluator threw an Exception-", evaluationException);
            }
        }
        if (this.eventMarksEndOfLife(e)) {
            this.cbTracker.endOfLife(string);
        }
        this.cbTracker.removeStaleComponents(l);
        if (this.lastTrackerStatusPrint + this.delayBetweenStatusMessages < l) {
            SMTPAppenderBase sMTPAppenderBase = this;
            sMTPAppenderBase.addInfo("SMTPAppender [" + sMTPAppenderBase.name + "] is tracking [" + this.cbTracker.getComponentCount() + "] buffers");
            this.lastTrackerStatusPrint = l;
            if (this.delayBetweenStatusMessages < 1228800000L) {
                this.delayBetweenStatusMessages <<= 2;
            }
        }
    }

    protected abstract boolean eventMarksEndOfLife(E var1);

    protected abstract void subAppend(CyclicBuffer<E> var1, E var2);

    public boolean checkEntryConditions() {
        if (!this.started) {
            SMTPAppenderBase sMTPAppenderBase = this;
            sMTPAppenderBase.addError("Attempting to append to a non-started appender: " + sMTPAppenderBase.getName());
            return false;
        }
        if (this.eventEvaluator == null) {
            SMTPAppenderBase sMTPAppenderBase = this;
            sMTPAppenderBase.addError("No EventEvaluator is set for appender [" + sMTPAppenderBase.name + "].");
            return false;
        }
        if (this.layout == null) {
            SMTPAppenderBase sMTPAppenderBase = this;
            sMTPAppenderBase.addError("No layout set for appender named [" + sMTPAppenderBase.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.addError("Could not parse address [" + string + "].", addressException);
            return null;
        }
    }

    private List<InternetAddress> parseAddress(E e) {
        int n = this.toPatternLayoutList.size();
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        for (int i = 0; i < n; ++i) {
            try {
                InternetAddress[] internetAddressArray = this.toPatternLayoutList.get(i);
                internetAddressArray = internetAddressArray.doLayout(e);
                if (internetAddressArray == null || internetAddressArray.length() == 0) continue;
                internetAddressArray = InternetAddress.parse((String)internetAddressArray, (boolean)true);
                arrayList.addAll(Arrays.asList(internetAddressArray));
                continue;
            }
            catch (AddressException addressException) {
                SMTPAppenderBase sMTPAppenderBase = this;
                sMTPAppenderBase.addError("Could not parse email address for [" + String.valueOf(sMTPAppenderBase.toPatternLayoutList.get(i)) + "] for event [" + String.valueOf(e) + "]", addressException);
                return arrayList;
            }
        }
        return arrayList;
    }

    public List<PatternLayoutBase<E>> getToList() {
        return this.toPatternLayoutList;
    }

    protected void updateMimeMsg(MimeMessage mimeMessage, CyclicBuffer<E> cyclicBuffer, E e) {
    }

    protected void sendBuffer(CyclicBuffer<E> cyclicBuffer, E e) {
        try {
            int n;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.layout.getFileHeader();
            if (string != null) {
                stringBuffer.append(string);
            }
            if ((string = this.layout.getPresentationHeader()) != null) {
                stringBuffer.append(string);
            }
            this.fillBuffer(cyclicBuffer, stringBuffer);
            string = this.layout.getPresentationFooter();
            if (string != null) {
                stringBuffer.append(string);
            }
            if ((string = this.layout.getFileFooter()) != null) {
                stringBuffer.append(string);
            }
            string = "Undefined subject";
            if (this.subjectLayout != null && (n = (string = this.subjectLayout.doLayout(e)) != null ? string.indexOf(10) : -1) >= 0) {
                string = string.substring(0, n);
            }
            MimeMessage mimeMessage = new MimeMessage(this.session);
            if (this.from != null) {
                SMTPAppenderBase sMTPAppenderBase = this;
                mimeMessage.setFrom((Address)sMTPAppenderBase.getAddress(sMTPAppenderBase.from));
            } else {
                mimeMessage.setFrom();
            }
            mimeMessage.setSubject(string, this.charsetEncoding);
            Object[] objectArray = this.parseAddress(e);
            if (objectArray.isEmpty()) {
                this.addInfo("Empty destination address. Aborting email transmission");
                return;
            }
            objectArray = objectArray.toArray(EMPTY_IA_ARRAY);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])objectArray);
            String string2 = this.layout.getContentType();
            if (ContentTypeUtil.isTextual(string2)) {
                mimeBodyPart.setText(stringBuffer.toString(), this.charsetEncoding, ContentTypeUtil.getSubType(string2));
            } else {
                mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
            }
            stringBuffer = new MimeMultipart();
            stringBuffer.addBodyPart((BodyPart)mimeBodyPart);
            mimeMessage.setContent((Multipart)stringBuffer);
            this.updateMimeMsg(mimeMessage, cyclicBuffer, e);
            mimeMessage.setSentDate(new Date());
            this.addInfo("About to send out SMTP message \"" + string + "\" to " + Arrays.toString(objectArray));
            Transport.send((Message)mimeMessage);
            return;
        }
        catch (Exception exception) {
            this.addError("Error occurred while sending e-mail notification.", exception);
            return;
        }
    }

    protected abstract void fillBuffer(CyclicBuffer<E> var1, StringBuffer var2);

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setSubject(String string) {
        this.subjectStr = string;
    }

    public void setSMTPHost(String string) {
        this.setSmtpHost(string);
    }

    public void setSmtpHost(String string) {
        this.smtpHost = string;
    }

    public String getSMTPHost() {
        return this.getSmtpHost();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSMTPPort(int n) {
        this.setSmtpPort(n);
    }

    public void setSmtpPort(int n) {
        this.smtpPort = n;
    }

    public int getSMTPPort() {
        return this.getSmtpPort();
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String string) {
        this.localhost = string;
    }

    public CyclicBufferTracker<E> getCyclicBufferTracker() {
        return this.cbTracker;
    }

    public void setCyclicBufferTracker(CyclicBufferTracker<E> cyclicBufferTracker) {
        this.cbTracker = cyclicBufferTracker;
    }

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator<E> discriminator) {
        this.discriminator = discriminator;
    }

    public boolean isAsynchronousSending() {
        return this.asynchronousSending;
    }

    public void setAsynchronousSending(boolean bl) {
        this.asynchronousSending = bl;
    }

    public void addTo(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Null or empty <to> property");
        }
        object = this.makeNewToPatternLayout(((String)object).trim());
        ((LayoutBase)object).setContext(this.context);
        ((PatternLayoutBase)object).start();
        this.toPatternLayoutList.add((PatternLayoutBase<Object>)object);
    }

    protected abstract PatternLayoutBase<E> makeNewToPatternLayout(String var1);

    public List<String> getToAsListOfString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PatternLayoutBase<E> patternLayoutBase : this.toPatternLayoutList) {
            arrayList.add(patternLayoutBase.getPattern());
        }
        return arrayList;
    }

    public boolean isSTARTTLS() {
        return this.starttls;
    }

    public void setSTARTTLS(boolean bl) {
        this.starttls = bl;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
    }

    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String string) {
        this.jndiLocation = string;
    }

    public boolean isSessionViaJNDI() {
        return this.sessionViaJNDI;
    }

    public void setSessionViaJNDI(boolean bl) {
        this.sessionViaJNDI = bl;
    }

    public void setCharsetEncoding(String string) {
        this.charsetEncoding = string;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }
}

