/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.spi.AbstractComponentTracker$1;
import ch.qos.logback.core.spi.AbstractComponentTracker$2;
import ch.qos.logback.core.spi.AbstractComponentTracker$3;
import ch.qos.logback.core.spi.AbstractComponentTracker$Entry;
import ch.qos.logback.core.spi.AbstractComponentTracker$RemovalPredicator;
import ch.qos.logback.core.spi.ComponentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractComponentTracker<C>
implements ComponentTracker<C> {
    private static final boolean ACCESS_ORDERED = true;
    public static final long LINGERING_TIMEOUT = 10000L;
    public static final long WAIT_BETWEEN_SUCCESSIVE_REMOVAL_ITERATIONS = 1000L;
    protected int maxComponents = Integer.MAX_VALUE;
    protected long timeout = 1800000L;
    LinkedHashMap<String, AbstractComponentTracker$Entry<C>> liveMap = new LinkedHashMap(32, 0.75f, true);
    LinkedHashMap<String, AbstractComponentTracker$Entry<C>> lingerersMap = new LinkedHashMap(16, 0.75f, true);
    long lastCheck = 0L;
    private AbstractComponentTracker$RemovalPredicator<C> byExcedent = new AbstractComponentTracker$1(this);
    private AbstractComponentTracker$RemovalPredicator<C> byTimeout = new AbstractComponentTracker$2(this);
    private AbstractComponentTracker$RemovalPredicator<C> byLingering = new AbstractComponentTracker$3(this);

    protected abstract void processPriorToRemoval(C var1);

    protected abstract C buildComponent(String var1);

    protected abstract boolean isComponentStale(C var1);

    @Override
    public int getComponentCount() {
        return this.liveMap.size() + this.lingerersMap.size();
    }

    private AbstractComponentTracker$Entry<C> getFromEitherMap(String string) {
        AbstractComponentTracker$Entry<C> abstractComponentTracker$Entry = this.liveMap.get(string);
        if (abstractComponentTracker$Entry != null) {
            return abstractComponentTracker$Entry;
        }
        return this.lingerersMap.get(string);
    }

    @Override
    public synchronized C find(String object) {
        if ((object = this.getFromEitherMap((String)object)) == null) {
            return null;
        }
        return ((AbstractComponentTracker$Entry)object).component;
    }

    @Override
    public synchronized C getOrCreate(String string, long l) {
        AbstractComponentTracker$Entry<Object> abstractComponentTracker$Entry = this.getFromEitherMap(string);
        if (abstractComponentTracker$Entry == null) {
            abstractComponentTracker$Entry = this.buildComponent(string);
            abstractComponentTracker$Entry = new AbstractComponentTracker$Entry<AbstractComponentTracker$Entry<C>>(string, abstractComponentTracker$Entry, l);
            this.liveMap.put(string, abstractComponentTracker$Entry);
        } else {
            abstractComponentTracker$Entry.setTimestamp(l);
        }
        return abstractComponentTracker$Entry.component;
    }

    @Override
    public void endOfLife(String string) {
        AbstractComponentTracker$Entry abstractComponentTracker$Entry = (AbstractComponentTracker$Entry)this.liveMap.remove(string);
        if (abstractComponentTracker$Entry == null) {
            return;
        }
        this.lingerersMap.put(string, abstractComponentTracker$Entry);
    }

    @Override
    public synchronized void removeStaleComponents(long l) {
        if (this.isTooSoonForRemovalIteration(l)) {
            return;
        }
        this.removeExcedentComponents();
        this.removeStaleComponentsFromMainMap(l);
        this.removeStaleComponentsFromLingerersMap(l);
    }

    private void removeExcedentComponents() {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.liveMap, 0L, this.byExcedent);
    }

    private void removeStaleComponentsFromMainMap(long l) {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.liveMap, l, this.byTimeout);
    }

    private void removeStaleComponentsFromLingerersMap(long l) {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.lingerersMap, l, this.byLingering);
    }

    private void genericStaleComponentRemover(LinkedHashMap<String, AbstractComponentTracker$Entry<C>> object, long l, AbstractComponentTracker$RemovalPredicator<C> abstractComponentTracker$RemovalPredicator) {
        object = ((LinkedHashMap)object).entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            if (!abstractComponentTracker$RemovalPredicator.isSlatedForRemoval((AbstractComponentTracker$Entry<C>)(object2 = (AbstractComponentTracker$Entry)object2.getValue()), l)) break;
            object.remove();
            object2 = ((AbstractComponentTracker$Entry)object2).component;
            this.processPriorToRemoval(object2);
        }
    }

    private boolean isTooSoonForRemovalIteration(long l) {
        if (this.lastCheck + 1000L > l) {
            return true;
        }
        this.lastCheck = l;
        return false;
    }

    private boolean isEntryStale(AbstractComponentTracker$Entry<C> abstractComponentTracker$Entry, long l) {
        Object c = abstractComponentTracker$Entry.component;
        if (this.isComponentStale(c)) {
            return true;
        }
        return abstractComponentTracker$Entry.timestamp + this.timeout < l;
    }

    private boolean isEntryDoneLingering(AbstractComponentTracker$Entry<C> abstractComponentTracker$Entry, long l) {
        return abstractComponentTracker$Entry.timestamp + 10000L < l;
    }

    @Override
    public Set<String> allKeys() {
        HashSet<String> hashSet = new HashSet<String>(this.liveMap.keySet());
        hashSet.addAll(this.lingerersMap.keySet());
        return hashSet;
    }

    @Override
    public Collection<C> allComponents() {
        ArrayList arrayList = new ArrayList();
        for (AbstractComponentTracker$Entry<C> abstractComponentTracker$Entry : this.liveMap.values()) {
            arrayList.add(abstractComponentTracker$Entry.component);
        }
        for (AbstractComponentTracker$Entry<C> abstractComponentTracker$Entry : this.lingerersMap.values()) {
            arrayList.add(abstractComponentTracker$Entry.component);
        }
        return arrayList;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void setMaxComponents(int n) {
        this.maxComponents = n;
    }
}

