/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class COWArrayList<E>
implements List<E> {
    AtomicBoolean fresh = new AtomicBoolean(false);
    CopyOnWriteArrayList<E> underlyingList = new CopyOnWriteArrayList();
    E[] ourCopy;
    final E[] modelArray;

    public COWArrayList(E[] EArray) {
        this.modelArray = EArray;
    }

    @Override
    public int size() {
        return this.underlyingList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.underlyingList.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlyingList.iterator();
    }

    private void refreshCopyIfNecessary() {
        if (!this.isFresh()) {
            this.refreshCopy();
        }
    }

    private boolean isFresh() {
        return this.fresh.get();
    }

    private void refreshCopy() {
        this.ourCopy = this.underlyingList.toArray(this.modelArray);
        this.fresh.set(true);
    }

    @Override
    public Object[] toArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    public E[] asTypedArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    private void markAsStale() {
        this.fresh.set(false);
    }

    public void addIfAbsent(E e) {
        this.underlyingList.addIfAbsent(e);
        this.markAsStale();
    }

    @Override
    public boolean add(E e) {
        boolean bl = this.underlyingList.add(e);
        this.markAsStale();
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = this.underlyingList.remove(object);
        this.markAsStale();
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.underlyingList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.markAsStale();
        boolean bl = this.underlyingList.addAll(collection);
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.markAsStale();
        boolean bl = this.underlyingList.addAll(n, collection);
        n = bl ? 1 : 0;
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.markAsStale();
        boolean bl = this.underlyingList.removeAll(collection);
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.markAsStale();
        boolean bl = this.underlyingList.retainAll(collection);
        return bl;
    }

    @Override
    public void clear() {
        this.markAsStale();
        this.underlyingList.clear();
    }

    @Override
    public E get(int n) {
        this.refreshCopyIfNecessary();
        return this.ourCopy[n];
    }

    @Override
    public E set(int n, E e) {
        this.markAsStale();
        E e2 = this.underlyingList.set(n, e);
        return e2;
    }

    @Override
    public void add(int n, E e) {
        this.markAsStale();
        this.underlyingList.add(n, e);
    }

    @Override
    public E remove(int n) {
        this.markAsStale();
        E e = this.underlyingList.remove(n);
        return e;
    }

    @Override
    public int indexOf(Object object) {
        return this.underlyingList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.underlyingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.underlyingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.underlyingList.listIterator(n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.underlyingList.subList(n, n2);
    }
}

