/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FileUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public FileUtil(Context context) {
        this.setContext(context);
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected exception on file [" + String.valueOf(file) + "]", malformedURLException);
        }
    }

    public static boolean createMissingParentDirectories(File file) {
        if ((file = file.getParentFile()) == null) {
            return true;
        }
        file.mkdirs();
        return file.exists();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String resourceAsString(ClassLoader object, String string) {
        int n;
        if ((object = ((ClassLoader)object).getResource(string)) == null) {
            this.addError("Failed to find resource [" + string + "]");
            return null;
        }
        InputStreamReader inputStreamReader = null;
        object = ((URL)object).openConnection();
        ((URLConnection)object).setUseCaches(false);
        inputStreamReader = new InputStreamReader(((URLConnection)object).getInputStream());
        object = new char[128];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStreamReader.read((char[])object, 0, 128)) != -1) {
            stringBuilder.append((char[])object, 0, n);
        }
        object = stringBuilder.toString();
        try {
            inputStreamReader.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
        catch (IOException iOException) {
            try {
                this.addError("Failed to open " + string, iOException);
                if (inputStreamReader == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStreamReader == null) throw throwable;
                try {
                    inputStreamReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                inputStreamReader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(String string, String string2) {
        FilterOutputStream filterOutputStream;
        block14: {
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                byte[] byArray = new byte[32768];
                while ((n = bufferedInputStream.read(byArray)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                bufferedInputStream.close();
                bufferedInputStream = null;
                filterOutputStream.close();
                filterOutputStream = null;
                if (bufferedInputStream == null) break block14;
            }
            catch (IOException iOException) {
                try {
                    String string3 = "Failed to copy [" + string + "] to [" + string2 + "]";
                    this.addError(string3, iOException);
                    throw new RolloverFailure(string3);
                }
                catch (Throwable throwable) {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (filterOutputStream == null) throw throwable;
                    try {
                        filterOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException3) {}
                    throw throwable;
                }
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (filterOutputStream == null) return;
        try {
            filterOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

