/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    public static void installIfAsked(Context context) {
        String string = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isNullOrEmpty(string)) {
            StatusListenerConfigHelper.addStatusListener(context, string);
        }
    }

    private static void addStatusListener(Context context, String object) {
        object = "SYSOUT".equalsIgnoreCase((String)object) || "STDOUT".equalsIgnoreCase((String)object) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(context, (String)object);
        StatusListenerConfigHelper.initAndAddListener(context, (StatusListener)object);
    }

    private static void initAndAddListener(Context context, StatusListener statusListener) {
        if (statusListener != null) {
            boolean bl;
            if (statusListener instanceof ContextAware) {
                ((ContextAware)((Object)statusListener)).setContext(context);
            }
            if ((bl = context.getStatusManager().add(statusListener)) && statusListener instanceof LifeCycle) {
                ((LifeCycle)((Object)statusListener)).start();
            }
        }
    }

    private static StatusListener createListenerPerClassName(Context object, String string) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, (Context)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static void addOnConsoleListenerInstance(Context context, OnConsoleStatusListener onConsoleStatusListener) {
        onConsoleStatusListener.setContext(context);
        boolean bl = context.getStatusManager().add(onConsoleStatusListener);
        if (bl) {
            onConsoleStatusListener.start();
        }
    }
}

