/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.jndi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.commons.c.b;
import org.osjava.sj.jndi.ContextBindings;
import org.osjava.sj.jndi.ContextNames;
import org.osjava.sj.jndi.JndiUtils;
import org.osjava.sj.jndi.SimpleNameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContext
implements Cloneable,
Context {
    public static final String IGNORE_CLOSE = "org.osjava.sj.jndi.ignoreClose";
    private Properties envAsProperties;
    private Map<Name, Object> namesToObjects = Collections.synchronizedMap(new HashMap());
    private Map<Name, Context> subContexts = Collections.synchronizedMap(new HashMap());
    private Hashtable env = new Hashtable();
    private NameParser nameParser;
    private Name nameInNamespace = null;
    private boolean nameLock = false;
    private static Logger LOGGER = LoggerFactory.getLogger(MemoryContext.class);

    public MemoryContext(Hashtable hashtable) {
        this(hashtable, null);
    }

    protected MemoryContext() {
        this(null, null);
        throw new RuntimeException("Not fully implemented");
    }

    protected MemoryContext(NameParser nameParser) {
        this(null, nameParser);
    }

    protected MemoryContext(Hashtable hashtable, NameParser nameParser) {
        Serializable serializable;
        if (hashtable != null) {
            this.env = (Hashtable)hashtable.clone();
            serializable = new Properties();
            ((Properties)serializable).putAll((Map<?, ?>)hashtable);
            this.envAsProperties = serializable;
        }
        if (nameParser == null) {
            try {
                this.nameParser = new SimpleNameParser(this);
            }
            catch (NamingException namingException) {
                serializable = namingException;
                namingException.printStackTrace();
            }
        }
        try {
            this.nameInNamespace = this.nameParser.parse("");
            return;
        }
        catch (NamingException namingException) {
            serializable = namingException;
            namingException.printStackTrace();
            return;
        }
    }

    public String toString() {
        return "MemoryContext{namesToObjects=" + this.namesToObjects + ", subContexts=" + this.subContexts + ", env=" + this.env + ", nameParser=" + this.nameParser + ", nameInNamespace=" + this.nameInNamespace + ", nameLock=" + this.nameLock + '}';
    }

    @Override
    public Object lookup(Name object) {
        if (object == null) {
            MemoryContext.$$$reportNull$$$0(0);
        }
        if (object.size() == 0) {
            return this.newInstance();
        }
        Serializable serializable = object.getPrefix(1);
        serializable = JndiUtils.toCompoundName(serializable, this.envAsProperties);
        if (object.size() > 1) {
            if (this.subContexts.containsKey(serializable)) {
                return this.subContexts.get(serializable).lookup(object.getSuffix(1));
            }
            String string = "MemoryContext#lookup(\"{}\"): Invalid subcontext '{}' in context '{}': {}";
            LOGGER.error(string, new Object[]{object, serializable, this.getNameInNamespace(), this});
            throw new NamingException();
        }
        if (this.namesToObjects.containsKey(object = JndiUtils.toCompoundName((Name)object, this.envAsProperties))) {
            Object object2 = this.namesToObjects.get(serializable);
            if (object2 instanceof Reference) {
                try {
                    object = NamingManager.getObjectInstance(object2, null, null, this.getEnvironment());
                }
                catch (Exception exception) {
                    LOGGER.error("", (Throwable)exception);
                    serializable = new NamingException();
                    ((NamingException)serializable).setRootCause(exception);
                    throw serializable;
                }
                object2 = object == object2 ? null : object;
                this.namesToObjects.put((Name)serializable, object2);
            }
            return object2;
        }
        if (this.subContexts.containsKey(object)) {
            return this.subContexts.get(object);
        }
        LOGGER.debug("MemoryContext#lookup() {} not found in {}", object, (Object)this);
        throw new NameNotFoundException(object.toString());
    }

    private Object newInstance() {
        Context context;
        try {
            context = (Context)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new OperationNotSupportedException();
        }
        return context;
    }

    @Override
    public Object lookup(String string) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(1);
        }
        MemoryContext memoryContext = this;
        return memoryContext.lookup(memoryContext.nameParser.parse(string));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bind(Name name, Object object) {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(2);
        }
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot bind to an empty name.");
        }
        if (name.size() > 1) {
            Name name2 = name.getPrefix(1);
            if (this.subContexts.containsKey(name2)) {
                this.subContexts.get(name2).bind(name.getSuffix(1), object);
                return;
            }
            LOGGER.error("No such subcontext: {} in {}", (Object)name2, (Object)this);
            throw new NameNotFoundException("" + name2);
        }
        if (this.namesToObjects.containsKey(name) || this.subContexts.containsKey(name)) {
            LOGGER.error("bind() {} already bound in {}", (Object)name, (Object)this);
            throw new NameAlreadyBoundException("Name " + name.toString() + " already bound.  Use rebind() to override");
        }
        if (object instanceof Context) {
            this.subContexts.put(name, (Context)object);
            return;
        }
        this.namesToObjects.put(name, object);
    }

    @Override
    public void bind(String string, Object object) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(3);
        }
        MemoryContext memoryContext = this;
        memoryContext.bind(memoryContext.nameParser.parse(string), object);
    }

    @Override
    public void rebind(Name name, Object object) {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(4);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        Name name2 = name;
        Object object2 = this.lookup(name2.getPrefix(name2.size() - 1));
        if (object2 == null || !(object2 instanceof Context)) {
            throw new NamingException("Cannot bind object.  Target context does not exist.");
        }
        this.unbind(name);
        this.bind(name, object);
    }

    @Override
    public void rebind(String string, Object object) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(5);
        }
        MemoryContext memoryContext = this;
        memoryContext.rebind(memoryContext.nameParser.parse(string), object);
    }

    @Override
    public void unbind(Name name) {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(6);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind to empty name");
        }
        if (name.size() == 1) {
            this.namesToObjects.remove(name);
            this.subContexts.remove(name);
            return;
        }
        Name name2 = name;
        Object object = this.lookup(name2.getPrefix(name2.size() - 1));
        if (object == null || !(object instanceof Context)) {
            NamingException namingException = new NamingException("Cannot unbind object.");
            LOGGER.error("Can not unbind object with name={} from targetContext={}.", (Object)name, object);
            LOGGER.error("", (Throwable)namingException);
            throw namingException;
        }
        Name name3 = name;
        ((Context)object).unbind(name3.getSuffix(name3.size() - 1));
    }

    @Override
    public void unbind(String string) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(7);
        }
        MemoryContext memoryContext = this;
        memoryContext.unbind(memoryContext.nameParser.parse(string));
    }

    @Override
    public void rename(Name name, Name name2) {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            MemoryContext.$$$reportNull$$$0(9);
        }
        Object object = this.lookup(name);
        if (name2.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        if (object == null) {
            throw new NamingException("Name '" + name + "' not found.");
        }
        if (this.lookup(name2) != null) {
            throw new NameAlreadyBoundException("Name '" + name2 + "' already bound");
        }
        this.unbind(name);
        this.unbind(name2);
        this.bind(name2, object);
        if (object instanceof Thread) {
            ((Thread)object).setName(name2.toString());
        }
    }

    @Override
    public void rename(String string, String string2) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(10);
        }
        if (string2 == null) {
            MemoryContext.$$$reportNull$$$0(11);
        }
        MemoryContext memoryContext = this;
        memoryContext.rename(memoryContext.nameParser.parse(string), this.nameParser.parse(string2));
    }

    public NamingEnumeration list(Name object) {
        if (object == null) {
            MemoryContext.$$$reportNull$$$0(12);
        }
        if (object == null || object.isEmpty()) {
            HashMap<Name, Object> hashMap = new HashMap<Name, Object>();
            hashMap.putAll(this.namesToObjects);
            hashMap.putAll(this.subContexts);
            object = new ContextNames(hashMap);
            return object;
        }
        Name name = object.getPrefix(1);
        if (this.namesToObjects.containsKey(name)) {
            throw new NotContextException(object + " cannot be listed");
        }
        if (this.subContexts.containsKey(name)) {
            return this.subContexts.get(name).list(object.getSuffix(1));
        }
        throw new NamingException();
    }

    public NamingEnumeration list(String string) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(13);
        }
        MemoryContext memoryContext = this;
        return memoryContext.list(memoryContext.nameParser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(14);
        }
        if (name == null || name.isEmpty()) {
            HashMap<Name, Object> hashMap = new HashMap<Name, Object>();
            hashMap.putAll(this.namesToObjects);
            hashMap.putAll(this.subContexts);
            return new ContextBindings(hashMap);
        }
        Name name2 = name.getPrefix(1);
        if (this.subContexts.containsKey(name2)) {
            return this.subContexts.get(name2).listBindings(name.getSuffix(1));
        }
        throw new NamingException("MemoryContext#listBindings(\"" + name + "\"): subcontext not found.");
    }

    public NamingEnumeration listBindings(String string) {
        if (string == null) {
            MemoryContext.$$$reportNull$$$0(15);
        }
        MemoryContext memoryContext = this;
        return memoryContext.listBindings(memoryContext.nameParser.parse(string));
    }

    @Override
    public void destroySubcontext(Name name) {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context context = this.subContexts.get(name.getPrefix(1));
                this.destroySubcontexts(context);
                return;
            }
            throw new NameNotFoundException();
        }
        if (this.namesToObjects.containsKey(name)) {
            throw new NotContextException();
        }
        if (!this.subContexts.containsKey(name)) {
            throw new NameNotFoundException();
        }
        Context context = this.subContexts.get(name);
        this.destroySubcontexts(context);
        context.close();
        this.subContexts.remove(name);
    }

    private void destroySubcontexts(Context context) {
        NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
        while (namingEnumeration.hasMore()) {
            Object object = namingEnumeration.next();
            String string = ((NameClassPair)object).getName();
            if (((Binding)object).getObject() instanceof Context) {
                object = (Context)((Binding)object).getObject();
                this.destroySubcontexts((Context)object);
                context.destroySubcontext(string);
                continue;
            }
            LOGGER.trace("Unbind {}", (Object)string);
            object = new Properties();
            ((Properties)object).setProperty("jndi.syntax.direction", "flat");
            context.unbind(new CompoundName(string, (Properties)object));
        }
    }

    @Override
    public void destroySubcontext(String string) {
        MemoryContext memoryContext = this;
        memoryContext.destroySubcontext(memoryContext.nameParser.parse(string));
    }

    @Override
    public Context createSubcontext(Name name) {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context context = this.subContexts.get(name.getPrefix(1));
                Context context2 = context.createSubcontext(name.getSuffix(1));
                return context2;
            }
            throw new NameNotFoundException("The subcontext " + name.getPrefix(1) + " was not found (" + name + ").");
        }
        try {
            this.lookup(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        Name name2 = this.getNameParser((Name)null).parse(this.getNameInNamespace());
        name2.addAll(name);
        MemoryContext memoryContext = new MemoryContext(this.env);
        memoryContext.setNameInNamespace(name2);
        this.bind(name, (Object)memoryContext);
        return memoryContext;
    }

    @Override
    public Context createSubcontext(String string) {
        MemoryContext memoryContext = this;
        return memoryContext.createSubcontext(memoryContext.nameParser.parse(string));
    }

    @Override
    public Object lookupLink(Name name) {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String string) {
        MemoryContext memoryContext = this;
        return memoryContext.lookup(memoryContext.nameParser.parse(string));
    }

    @Override
    public NameParser getNameParser(Name name) {
        if (name == null || name.isEmpty() || name.size() == 1 && name.toString().equals(this.getNameInNamespace())) {
            return this.nameParser;
        }
        Name name2 = name.getPrefix(1);
        if (this.subContexts.containsKey(name2)) {
            return this.subContexts.get(name2).getNameParser(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    @Override
    public NameParser getNameParser(String string) {
        MemoryContext memoryContext = this;
        return memoryContext.getNameParser(memoryContext.nameParser.parse(string));
    }

    @Override
    public Name composeName(Name name, Name name2) {
        if (name == null || name2 == null) {
            throw new NamingException("Arguments must not be null");
        }
        name2 = (Name)name2.clone();
        name2.addAll(name);
        return name2;
    }

    @Override
    public String composeName(String object, String string) {
        MemoryContext memoryContext = this;
        object = memoryContext.composeName(memoryContext.nameParser.parse((String)object), this.nameParser.parse(string));
        return object.toString();
    }

    @Override
    public Object addToEnvironment(String string, Object object) {
        if (this.env == null) {
            return null;
        }
        return this.env.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(string);
    }

    public Hashtable getEnvironment() {
        if (this.env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.env.clone();
    }

    @Override
    public void close() {
        String string = (String)this.env.get(IGNORE_CLOSE);
        if (!b.b((String)string)) {
            this.forceClose();
        }
    }

    @Override
    public String getNameInNamespace() {
        return this.nameInNamespace.toString();
    }

    public boolean isEmpty() {
        return this.namesToObjects.size() > 0 || this.subContexts.size() > 0;
    }

    private void setNameInNamespace(Name name) {
        if (this.nameLock && (this.nameInNamespace != null || !this.nameInNamespace.isEmpty())) {
            LOGGER.error("Name already set: name={} nameInNamespace={} this={}", new Object[]{name, this.nameInNamespace, this});
            throw new NamingException("Name already set.");
        }
        this.nameInNamespace = name;
        this.nameLock = true;
    }

    public void forceClose() {
        MemoryContext memoryContext = this;
        memoryContext.destroySubcontexts(memoryContext);
        this.env = null;
        this.namesToObjects = null;
        this.subContexts = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
            }
        }
        objectArray2[1] = "org/osjava/sj/jndi/MemoryContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bind";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rebind";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "unbind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "list";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "listBindings";
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

