/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.CoreFoundation$CFBooleanRef;
import com.sun.jna.platform.mac.CoreFoundation$CFDataRef;
import com.sun.jna.platform.mac.CoreFoundation$CFMutableDictionaryRef;
import com.sun.jna.platform.mac.CoreFoundation$CFNumberRef;
import com.sun.jna.platform.mac.CoreFoundation$CFStringRef;
import com.sun.jna.platform.mac.CoreFoundation$CFTypeRef;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKit$IOIterator;
import com.sun.jna.platform.mac.IOKit$IOObject;
import com.sun.jna.platform.mac.IOReturnException;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;

public class IOKit$IORegistryEntry
extends IOKit$IOObject {
    public IOKit$IORegistryEntry() {
    }

    public IOKit$IORegistryEntry(Pointer pointer) {
        super(pointer);
    }

    public long getRegistryEntryID() {
        LongByReference longByReference = new LongByReference();
        int n = IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(this, longByReference);
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return longByReference.getValue();
    }

    public String getName() {
        Memory memory = new Memory(128L);
        int n = IOKit.INSTANCE.IORegistryEntryGetName(this, (Pointer)memory);
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return memory.getString(0L);
    }

    public IOKit$IOIterator getChildIterator(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n = IOKit.INSTANCE.IORegistryEntryGetChildIterator(this, string, pointerByReference);
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return new IOKit$IOIterator(pointerByReference.getValue());
    }

    public IOKit$IORegistryEntry getChildEntry(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n = IOKit.INSTANCE.IORegistryEntryGetChildEntry(this, string, pointerByReference);
        if (n == -536870208) {
            return null;
        }
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return new IOKit$IORegistryEntry(pointerByReference.getValue());
    }

    public IOKit$IORegistryEntry getParentEntry(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n = IOKit.INSTANCE.IORegistryEntryGetParentEntry(this, string, pointerByReference);
        if (n == -536870208) {
            return null;
        }
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return new IOKit$IORegistryEntry(pointerByReference.getValue());
    }

    public CoreFoundation$CFTypeRef createCFProperty(CoreFoundation$CFStringRef coreFoundation$CFStringRef) {
        return IOKit.INSTANCE.IORegistryEntryCreateCFProperty(this, coreFoundation$CFStringRef, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
    }

    public CoreFoundation$CFMutableDictionaryRef createCFProperties() {
        PointerByReference pointerByReference = new PointerByReference();
        int n = IOKit.INSTANCE.IORegistryEntryCreateCFProperties(this, pointerByReference, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        if (n != 0) {
            throw new IOReturnException(n);
        }
        return new CoreFoundation$CFMutableDictionaryRef(pointerByReference.getValue());
    }

    CoreFoundation$CFTypeRef searchCFProperty(String string, CoreFoundation$CFStringRef coreFoundation$CFStringRef, int n) {
        return IOKit.INSTANCE.IORegistryEntrySearchCFProperty(this, string, coreFoundation$CFStringRef, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), n);
    }

    public String getStringProperty(String object) {
        String string = null;
        object = CoreFoundation$CFStringRef.createCFString(object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFStringRef(coreFoundation$CFTypeRef.getPointer());
            string = ((CoreFoundation$CFStringRef)((Object)object)).stringValue();
            coreFoundation$CFTypeRef.release();
        }
        return string;
    }

    public Long getLongProperty(String object) {
        Long l = null;
        object = CoreFoundation$CFStringRef.createCFString(object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            l = ((CoreFoundation$CFNumberRef)((Object)object)).longValue();
            coreFoundation$CFTypeRef.release();
        }
        return l;
    }

    public Integer getIntegerProperty(String object) {
        Integer n = null;
        object = CoreFoundation$CFStringRef.createCFString(object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            n = ((CoreFoundation$CFNumberRef)((Object)object)).intValue();
            coreFoundation$CFTypeRef.release();
        }
        return n;
    }

    public Double getDoubleProperty(String object) {
        Double d = null;
        object = CoreFoundation$CFStringRef.createCFString(object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            d = ((CoreFoundation$CFNumberRef)((Object)object)).doubleValue();
            coreFoundation$CFTypeRef.release();
        }
        return d;
    }

    public Boolean getBooleanProperty(String object) {
        Boolean bl = null;
        object = CoreFoundation$CFStringRef.createCFString(object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFBooleanRef(coreFoundation$CFTypeRef.getPointer());
            bl = ((CoreFoundation$CFBooleanRef)((Object)object)).booleanValue();
            coreFoundation$CFTypeRef.release();
        }
        return bl;
    }

    public byte[] getByteArrayProperty(String object) {
        byte[] byArray = null;
        object = CoreFoundation$CFStringRef.createCFString((String)object);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty((CoreFoundation$CFStringRef)((Object)object));
        ((CoreFoundation$CFTypeRef)((Object)object)).release();
        if (coreFoundation$CFTypeRef != null) {
            object = new CoreFoundation$CFDataRef(coreFoundation$CFTypeRef.getPointer());
            int n = ((CoreFoundation$CFDataRef)((Object)object)).getLength();
            object = ((CoreFoundation$CFDataRef)((Object)object)).getBytePtr();
            byArray = object.getByteArray(0L, n);
            coreFoundation$CFTypeRef.release();
        }
        return byArray;
    }
}

