/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.ITypeLib;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.TypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLib;
import com.sun.jna.platform.win32.COM.TypeLibUtil$FindName;
import com.sun.jna.platform.win32.COM.TypeLibUtil$IsName;
import com.sun.jna.platform.win32.COM.TypeLibUtil$TypeLibDoc;
import com.sun.jna.platform.win32.Guid$CLSID$ByReference;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl$MEMBERID;
import com.sun.jna.platform.win32.OaIdl$TLIBATTR;
import com.sun.jna.platform.win32.OaIdl$TYPEKIND;
import com.sun.jna.platform.win32.OaIdl$TYPEKIND$ByReference;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes$BSTRByReference;
import com.sun.jna.platform.win32.WTypes$LPOLESTR;
import com.sun.jna.platform.win32.WinDef$BOOLByReference;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$LCID;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinDef$USHORTByReference;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.PointerByReference;

public class TypeLibUtil {
    public static final OleAuto OLEAUTO = OleAuto.INSTANCE;
    private ITypeLib typelib;
    private WinDef$LCID lcid = Kernel32.INSTANCE.GetUserDefaultLCID();
    private String name;
    private String docString;
    private int helpContext;
    private String helpFile;

    public TypeLibUtil(String object, int n, int n2) {
        Guid$CLSID$ByReference guid$CLSID$ByReference = new Guid$CLSID$ByReference();
        object = Ole32.INSTANCE.CLSIDFromString((String)object, guid$CLSID$ByReference);
        COMUtils.checkRC((WinNT$HRESULT)((Object)object));
        PointerByReference pointerByReference = new PointerByReference();
        object = OleAuto.INSTANCE.LoadRegTypeLib(guid$CLSID$ByReference, n, n2, this.lcid, pointerByReference);
        COMUtils.checkRC((WinNT$HRESULT)((Object)object));
        this.typelib = new TypeLib(pointerByReference.getValue());
        this.initTypeLibInfo();
    }

    public TypeLibUtil(String object) {
        PointerByReference pointerByReference = new PointerByReference();
        object = OleAuto.INSTANCE.LoadTypeLib((String)object, pointerByReference);
        COMUtils.checkRC((WinNT$HRESULT)((Object)object));
        this.typelib = new TypeLib(pointerByReference.getValue());
        this.initTypeLibInfo();
    }

    private void initTypeLibInfo() {
        TypeLibUtil$TypeLibDoc typeLibUtil$TypeLibDoc = this.getDocumentation(-1);
        this.name = typeLibUtil$TypeLibDoc.getName();
        this.docString = typeLibUtil$TypeLibDoc.getDocString();
        this.helpContext = typeLibUtil$TypeLibDoc.getHelpContext();
        this.helpFile = typeLibUtil$TypeLibDoc.getHelpFile();
    }

    public int getTypeInfoCount() {
        return this.typelib.GetTypeInfoCount().intValue();
    }

    public OaIdl$TYPEKIND getTypeInfoType(int n) {
        OaIdl$TYPEKIND$ByReference oaIdl$TYPEKIND$ByReference = new OaIdl$TYPEKIND$ByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeInfoType(new WinDef$UINT(n), oaIdl$TYPEKIND$ByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return oaIdl$TYPEKIND$ByReference;
    }

    public ITypeInfo getTypeInfo(int n) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeInfo(new WinDef$UINT(n), pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeInfo(pointerByReference.getValue());
    }

    public TypeInfoUtil getTypeInfoUtil(int n) {
        return new TypeInfoUtil(this.getTypeInfo(n));
    }

    public OaIdl$TLIBATTR getLibAttr() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetLibAttr(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new OaIdl$TLIBATTR(pointerByReference.getValue());
    }

    public TypeComp GetTypeComp() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeComp(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeComp(pointerByReference.getValue());
    }

    public TypeLibUtil$TypeLibDoc getDocumentation(int n) {
        WTypes$BSTRByReference wTypes$BSTRByReference = new WTypes$BSTRByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference2 = new WTypes$BSTRByReference();
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference3 = new WTypes$BSTRByReference();
        Object object = this.typelib.GetDocumentation(n, wTypes$BSTRByReference, wTypes$BSTRByReference2, winDef$DWORDByReference, wTypes$BSTRByReference3);
        COMUtils.checkRC(object);
        object = new TypeLibUtil$TypeLibDoc(wTypes$BSTRByReference.getString(), wTypes$BSTRByReference2.getString(), winDef$DWORDByReference.getValue().intValue(), wTypes$BSTRByReference3.getString());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference2.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference3.getValue());
        return object;
    }

    public TypeLibUtil$IsName IsName(String object, int n) {
        object = new WTypes$LPOLESTR((String)object);
        Object object2 = new WinDef$ULONG(n);
        WinDef$BOOLByReference winDef$BOOLByReference = new WinDef$BOOLByReference();
        object2 = this.typelib.IsName((WTypes$LPOLESTR)((Object)object), (WinDef$ULONG)object2, winDef$BOOLByReference);
        COMUtils.checkRC((WinNT$HRESULT)((Object)object2));
        return new TypeLibUtil$IsName(((WTypes$LPOLESTR)((Object)object)).getValue(), winDef$BOOLByReference.getValue().booleanValue());
    }

    public TypeLibUtil$FindName FindName(String object, int n, short s) {
        Pointer pointer = Ole32.INSTANCE.CoTaskMemAlloc(((long)((String)object).length() + 1L) * (long)Native.WCHAR_SIZE);
        WTypes$LPOLESTR wTypes$LPOLESTR = new WTypes$LPOLESTR(pointer);
        wTypes$LPOLESTR.setValue((String)object);
        object = new WinDef$ULONG(n);
        WinDef$USHORTByReference winDef$USHORTByReference = new WinDef$USHORTByReference(s);
        Pointer[] pointerArray = new Pointer[s];
        OaIdl$MEMBERID[] oaIdl$MEMBERIDArray = new OaIdl$MEMBERID[s];
        object = this.typelib.FindName(wTypes$LPOLESTR, (WinDef$ULONG)object, pointerArray, oaIdl$MEMBERIDArray, winDef$USHORTByReference);
        COMUtils.checkRC((WinNT$HRESULT)((Object)object));
        object = new TypeLibUtil$FindName(wTypes$LPOLESTR.getValue(), pointerArray, oaIdl$MEMBERIDArray, winDef$USHORTByReference.getValue().shortValue());
        Ole32.INSTANCE.CoTaskMemFree(pointer);
        return object;
    }

    public void ReleaseTLibAttr(OaIdl$TLIBATTR oaIdl$TLIBATTR) {
        this.typelib.ReleaseTLibAttr(oaIdl$TLIBATTR);
    }

    public WinDef$LCID getLcid() {
        return this.lcid;
    }

    public ITypeLib getTypelib() {
        return this.typelib;
    }

    public String getName() {
        return this.name;
    }

    public String getDocString() {
        return this.docString;
    }

    public int getHelpContext() {
        return this.helpContext;
    }

    public String getHelpFile() {
        return this.helpFile;
    }
}

