/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Rasapi32;
import com.sun.jna.platform.win32.Rasapi32Util$Ras32Exception;
import com.sun.jna.platform.win32.WinDef$BOOLByReference;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinRas;
import com.sun.jna.platform.win32.WinRas$RASCONN;
import com.sun.jna.platform.win32.WinRas$RASCREDENTIALS$ByReference;
import com.sun.jna.platform.win32.WinRas$RASDIALPARAMS;
import com.sun.jna.platform.win32.WinRas$RASDIALPARAMS$ByReference;
import com.sun.jna.platform.win32.WinRas$RASENTRY$ByReference;
import com.sun.jna.platform.win32.WinRas$RASPPPIP;
import com.sun.jna.ptr.IntByReference;
import java.util.HashMap;
import java.util.Map;

public abstract class Rasapi32Util {
    private static final int RASP_PppIp = 32801;
    private static Object phoneBookMutex = new Object();
    public static final Map CONNECTION_STATE_TEXT = new HashMap<Integer, String>();

    public static String getRasErrorString(int n) {
        char[] cArray = new char[1024];
        int n2 = Rasapi32.INSTANCE.RasGetErrorString(n, cArray, 1024);
        if (n2 != 0) {
            return "Unknown error " + n;
        }
        for (n = 0; n < 1024 && cArray[n] != '\u0000'; ++n) {
        }
        return new String(cArray, 0, n);
    }

    public static String getRasConnectionStatusText(int n) {
        if (!CONNECTION_STATE_TEXT.containsKey(n)) {
            return Integer.toString(n);
        }
        return (String)CONNECTION_STATE_TEXT.get(n);
    }

    public static WinNT$HANDLE getRasConnection(String string) {
        IntByReference intByReference = new IntByReference(0);
        IntByReference intByReference2 = new IntByReference();
        int n = Rasapi32.INSTANCE.RasEnumConnections(null, intByReference, intByReference2);
        if (n != 0 && n != 603) {
            throw new Rasapi32Util$Ras32Exception(n);
        }
        if (intByReference.getValue() == 0) {
            return null;
        }
        WinRas$RASCONN[] winRas$RASCONNArray = new WinRas$RASCONN[intByReference2.getValue()];
        for (int i = 0; i < intByReference2.getValue(); ++i) {
            winRas$RASCONNArray[i] = new WinRas$RASCONN();
        }
        IntByReference intByReference3 = new IntByReference(winRas$RASCONNArray[0].dwSize * intByReference2.getValue());
        n = Rasapi32.INSTANCE.RasEnumConnections(winRas$RASCONNArray, intByReference3, intByReference2);
        if (n != 0) {
            throw new Rasapi32Util$Ras32Exception(n);
        }
        for (int i = 0; i < intByReference2.getValue(); ++i) {
            if (!new String(winRas$RASCONNArray[i].szEntryName).equals(string)) continue;
            return winRas$RASCONNArray[i].hrasconn;
        }
        return null;
    }

    public static void hangupRasConnection(String object) {
        if ((object = Rasapi32Util.getRasConnection(object)) == null) {
            return;
        }
        int n = Rasapi32.INSTANCE.RasHangUp((WinNT$HANDLE)((Object)object));
        if (n != 0) {
            throw new Rasapi32Util$Ras32Exception(n);
        }
    }

    public static void hangupRasConnection(WinNT$HANDLE winNT$HANDLE) {
        if (winNT$HANDLE == null) {
            return;
        }
        int n = Rasapi32.INSTANCE.RasHangUp(winNT$HANDLE);
        if (n != 0) {
            throw new Rasapi32Util$Ras32Exception(n);
        }
    }

    public static WinRas$RASPPPIP getIPProjection(WinNT$HANDLE winNT$HANDLE) {
        WinRas$RASPPPIP winRas$RASPPPIP = new WinRas$RASPPPIP();
        IntByReference intByReference = new IntByReference(winRas$RASPPPIP.size());
        winRas$RASPPPIP.write();
        int n = Rasapi32.INSTANCE.RasGetProjectionInfo(winNT$HANDLE, 32801, winRas$RASPPPIP.getPointer(), intByReference);
        if (n != 0) {
            throw new Rasapi32Util$Ras32Exception(n);
        }
        winRas$RASPPPIP.read();
        return winRas$RASPPPIP;
    }

    public static WinRas$RASENTRY$ByReference getPhoneBookEntry(String string) {
        Object object = phoneBookMutex;
        synchronized (object) {
            WinRas$RASENTRY$ByReference winRas$RASENTRY$ByReference = new WinRas$RASENTRY$ByReference();
            IntByReference intByReference = new IntByReference(winRas$RASENTRY$ByReference.size());
            int n = Rasapi32.INSTANCE.RasGetEntryProperties(null, string, winRas$RASENTRY$ByReference, intByReference, null, null);
            if (n != 0) {
                throw new Rasapi32Util$Ras32Exception(n);
            }
            return winRas$RASENTRY$ByReference;
        }
    }

    public static void setPhoneBookEntry(String string, WinRas$RASENTRY$ByReference winRas$RASENTRY$ByReference) {
        Object object = phoneBookMutex;
        synchronized (object) {
            WinRas$RASENTRY$ByReference winRas$RASENTRY$ByReference2 = winRas$RASENTRY$ByReference;
            int n = Rasapi32.INSTANCE.RasSetEntryProperties(null, string, winRas$RASENTRY$ByReference2, winRas$RASENTRY$ByReference2.size(), null, 0);
            if (n != 0) {
                throw new Rasapi32Util$Ras32Exception(n);
            }
            return;
        }
    }

    public static WinRas$RASDIALPARAMS getPhoneBookDialingParams(String object) {
        Object object2 = phoneBookMutex;
        synchronized (object2) {
            WinRas$RASDIALPARAMS$ByReference winRas$RASDIALPARAMS$ByReference = new WinRas$RASDIALPARAMS$ByReference();
            System.arraycopy(winRas$RASDIALPARAMS$ByReference.szEntryName, 0, object.toCharArray(), 0, object.length());
            object = new WinDef$BOOLByReference();
            int n = Rasapi32.INSTANCE.RasGetEntryDialParams(null, winRas$RASDIALPARAMS$ByReference, (WinDef$BOOLByReference)((Object)object));
            if (n != 0) {
                throw new Rasapi32Util$Ras32Exception(n);
            }
            return winRas$RASDIALPARAMS$ByReference;
        }
    }

    public static WinNT$HANDLE dialEntry(String string) {
        WinRas$RASCREDENTIALS$ByReference winRas$RASCREDENTIALS$ByReference = new WinRas$RASCREDENTIALS$ByReference();
        Object object = phoneBookMutex;
        synchronized (object) {
            winRas$RASCREDENTIALS$ByReference.dwMask = 7;
            int n = Rasapi32.INSTANCE.RasGetCredentials(null, string, winRas$RASCREDENTIALS$ByReference);
            if (n != 0) {
                throw new Rasapi32Util$Ras32Exception(n);
            }
        }
        object = new WinRas$RASDIALPARAMS$ByReference();
        System.arraycopy(string.toCharArray(), 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szEntryName, 0, string.length());
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szUserName, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szUserName, 0, winRas$RASCREDENTIALS$ByReference.szUserName.length);
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szPassword, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szPassword, 0, winRas$RASCREDENTIALS$ByReference.szPassword.length);
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szDomain, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szDomain, 0, winRas$RASCREDENTIALS$ByReference.szDomain.length);
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        int n = Rasapi32.INSTANCE.RasDial(null, null, (WinRas$RASDIALPARAMS$ByReference)((Object)object), 0, null, winNT$HANDLEByReference);
        if (n != 0) {
            if (winNT$HANDLEByReference.getValue() != null) {
                Rasapi32.INSTANCE.RasHangUp(winNT$HANDLEByReference.getValue());
            }
            throw new Rasapi32Util$Ras32Exception(n);
        }
        return winNT$HANDLEByReference.getValue();
    }

    public static WinNT$HANDLE dialEntry(String string, WinRas.RasDialFunc2 rasDialFunc2) {
        WinRas$RASCREDENTIALS$ByReference winRas$RASCREDENTIALS$ByReference = new WinRas$RASCREDENTIALS$ByReference();
        Object object = phoneBookMutex;
        synchronized (object) {
            winRas$RASCREDENTIALS$ByReference.dwMask = 7;
            int n = Rasapi32.INSTANCE.RasGetCredentials(null, string, winRas$RASCREDENTIALS$ByReference);
            if (n != 0) {
                throw new Rasapi32Util$Ras32Exception(n);
            }
        }
        object = new WinRas$RASDIALPARAMS$ByReference();
        System.arraycopy(string.toCharArray(), 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szEntryName, 0, string.length());
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szUserName, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szUserName, 0, winRas$RASCREDENTIALS$ByReference.szUserName.length);
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szPassword, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szPassword, 0, winRas$RASCREDENTIALS$ByReference.szPassword.length);
        System.arraycopy(winRas$RASCREDENTIALS$ByReference.szDomain, 0, ((WinRas$RASDIALPARAMS$ByReference)((Object)object)).szDomain, 0, winRas$RASCREDENTIALS$ByReference.szDomain.length);
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        int n = Rasapi32.INSTANCE.RasDial(null, null, (WinRas$RASDIALPARAMS$ByReference)((Object)object), 2, rasDialFunc2, winNT$HANDLEByReference);
        if (n != 0) {
            if (winNT$HANDLEByReference.getValue() != null) {
                Rasapi32.INSTANCE.RasHangUp(winNT$HANDLEByReference.getValue());
            }
            throw new Rasapi32Util$Ras32Exception(n);
        }
        return winNT$HANDLEByReference.getValue();
    }

    static {
        CONNECTION_STATE_TEXT.put(0, "Opening the port...");
        CONNECTION_STATE_TEXT.put(1, "Port has been opened successfully");
        CONNECTION_STATE_TEXT.put(2, "Connecting to the device...");
        CONNECTION_STATE_TEXT.put(3, "The device has connected successfully.");
        CONNECTION_STATE_TEXT.put(4, "All devices in the device chain have successfully connected.");
        CONNECTION_STATE_TEXT.put(5, "Verifying the user name and password...");
        CONNECTION_STATE_TEXT.put(6, "An authentication event has occurred.");
        CONNECTION_STATE_TEXT.put(7, "Requested another validation attempt with a new user.");
        CONNECTION_STATE_TEXT.put(8, "Server has requested a callback number.");
        CONNECTION_STATE_TEXT.put(9, "The client has requested to change the password");
        CONNECTION_STATE_TEXT.put(10, "Registering your computer on the network...");
        CONNECTION_STATE_TEXT.put(11, "The link-speed calculation phase is starting...");
        CONNECTION_STATE_TEXT.put(12, "An authentication request is being acknowledged.");
        CONNECTION_STATE_TEXT.put(13, "Reauthentication (after callback) is starting.");
        CONNECTION_STATE_TEXT.put(14, "The client has successfully completed authentication.");
        CONNECTION_STATE_TEXT.put(15, "The line is about to disconnect for callback.");
        CONNECTION_STATE_TEXT.put(16, "Delaying to give the modem time to reset for callback.");
        CONNECTION_STATE_TEXT.put(17, "Waiting for an incoming call from server.");
        CONNECTION_STATE_TEXT.put(18, "Projection result information is available.");
        CONNECTION_STATE_TEXT.put(19, "User authentication is being initiated or retried.");
        CONNECTION_STATE_TEXT.put(20, "Client has been called back and is about to resume authentication.");
        CONNECTION_STATE_TEXT.put(21, "Logging on to the network...");
        CONNECTION_STATE_TEXT.put(22, "Subentry has been connected");
        CONNECTION_STATE_TEXT.put(23, "Subentry has been disconnected");
        CONNECTION_STATE_TEXT.put(4096, "Terminal state supported by RASPHONE.EXE.");
        CONNECTION_STATE_TEXT.put(4097, "Retry authentication state supported by RASPHONE.EXE.");
        CONNECTION_STATE_TEXT.put(4098, "Callback state supported by RASPHONE.EXE.");
        CONNECTION_STATE_TEXT.put(4099, "Change password state supported by RASPHONE.EXE.");
        CONNECTION_STATE_TEXT.put(4100, "Displaying authentication UI");
        CONNECTION_STATE_TEXT.put(8192, "Connected to remote server successfully");
        CONNECTION_STATE_TEXT.put(8193, "Disconnected");
    }
}

