/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Guid$GUID;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShlObj;
import com.sun.jna.platform.win32.ShlObj$KNOWN_FOLDER_FLAG;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public abstract class Shell32Util {
    public static String getFolderPath(WinDef$HWND object, int n, WinDef$DWORD winDef$DWORD) {
        char[] cArray = new char[260];
        if (!(object = Shell32.INSTANCE.SHGetFolderPath((WinDef$HWND)((Object)object), n, null, winDef$DWORD, cArray)).equals((Object)W32Errors.S_OK)) {
            throw new Win32Exception((WinNT$HRESULT)((Object)object));
        }
        return Native.toString((char[])cArray);
    }

    public static String getFolderPath(int n) {
        return Shell32Util.getFolderPath(null, n, ShlObj.SHGFP_TYPE_CURRENT);
    }

    public static String getKnownFolderPath(Guid$GUID object) {
        PointerByReference pointerByReference;
        WinNT$HANDLE winNT$HANDLE;
        int n = ShlObj$KNOWN_FOLDER_FLAG.NONE.getFlag();
        if (!W32Errors.SUCCEEDED((object = Shell32.INSTANCE.SHGetKnownFolderPath((Guid$GUID)((Object)object), n, winNT$HANDLE = null, pointerByReference = new PointerByReference())).intValue())) {
            throw new Win32Exception((WinNT$HRESULT)((Object)object));
        }
        object = pointerByReference.getValue().getWideString(0L);
        Ole32.INSTANCE.CoTaskMemFree(pointerByReference.getValue());
        return object;
    }

    public static final String getSpecialFolderPath(int n, boolean bl) {
        char[] cArray = new char[260];
        if (!Shell32.INSTANCE.SHGetSpecialFolderPath(null, cArray, n, bl)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])cArray);
    }

    public static final String[] CommandLineToArgv(String string) {
        string = new WString(string);
        String[] stringArray = new IntByReference();
        if ((string = Shell32.INSTANCE.CommandLineToArgvW((WString)string, (IntByReference)stringArray)) != null) {
            try {
                stringArray = string.getWideStringArray(0L, stringArray.getValue());
                return stringArray;
            }
            finally {
                Kernel32.INSTANCE.LocalFree((Pointer)string);
            }
        }
        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
    }
}

