/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$LUID;
import com.sun.jna.platform.win32.WinNT$LUID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_PRIVILEGES;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.platform.win32.Winsvc$ENUM_SERVICE_STATUS;
import com.sun.jna.platform.win32.Winsvc$SC_ACTION;
import com.sun.jna.platform.win32.Winsvc$SC_ACTION$ByReference;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS$ByReference;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS_FLAG;
import com.sun.jna.platform.win32.Winsvc$SERVICE_STATUS;
import com.sun.jna.platform.win32.Winsvc$SERVICE_STATUS_PROCESS;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.util.List;

public class W32Service
implements Closeable {
    Winsvc.SC_HANDLE _handle = null;

    public W32Service(Winsvc.SC_HANDLE sC_HANDLE) {
        this._handle = sC_HANDLE;
    }

    @Override
    public void close() {
        if (this._handle != null) {
            if (!Advapi32.INSTANCE.CloseServiceHandle(this._handle)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._handle = null;
        }
    }

    private void addShutdownPrivilegeToProcess() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$LUID winNT$LUID = new WinNT$LUID();
        Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 32, winNT$HANDLEByReference);
        Advapi32.INSTANCE.LookupPrivilegeValue("", "SeShutdownPrivilege", winNT$LUID);
        WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(1);
        winNT$TOKEN_PRIVILEGES.Privileges[0] = new WinNT$LUID_AND_ATTRIBUTES(winNT$LUID, new WinDef$DWORD(2L));
        WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES2 = winNT$TOKEN_PRIVILEGES;
        Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES2, winNT$TOKEN_PRIVILEGES2.size(), null, new IntByReference());
    }

    public void setFailureActions(List<Winsvc$SC_ACTION> object, int n, String string, String string2) {
        Winsvc$SERVICE_FAILURE_ACTIONS$ByReference winsvc$SERVICE_FAILURE_ACTIONS$ByReference = new Winsvc$SERVICE_FAILURE_ACTIONS$ByReference();
        new Winsvc$SERVICE_FAILURE_ACTIONS$ByReference().dwResetPeriod = n;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpRebootMsg = string;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpCommand = string2;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.cActions = object.size();
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpsaActions = new Winsvc$SC_ACTION$ByReference();
        Winsvc$SC_ACTION[] winsvc$SC_ACTIONArray = (Winsvc$SC_ACTION[])winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpsaActions.toArray(object.size());
        boolean bl = false;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Winsvc$SC_ACTION winsvc$SC_ACTION = (Winsvc$SC_ACTION)((Object)object.next());
            if (!bl && winsvc$SC_ACTION.type == 2) {
                this.addShutdownPrivilegeToProcess();
                bl = true;
            }
            winsvc$SC_ACTIONArray[n2].type = winsvc$SC_ACTION.type;
            winsvc$SC_ACTIONArray[n2].delay = winsvc$SC_ACTION.delay;
            ++n2;
        }
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 2, winsvc$SERVICE_FAILURE_ACTIONS$ByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    private Pointer queryServiceConfig2(int n) {
        IntByReference intByReference = new IntByReference();
        Advapi32.INSTANCE.QueryServiceConfig2(this._handle, n, Pointer.NULL, 0, intByReference);
        Memory memory = new Memory((long)intByReference.getValue());
        if (!Advapi32.INSTANCE.QueryServiceConfig2(this._handle, n, (Pointer)memory, intByReference.getValue(), new IntByReference())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return memory;
    }

    public Winsvc$SERVICE_FAILURE_ACTIONS getFailureActions() {
        Object object = this.queryServiceConfig2(2);
        object = new Winsvc$SERVICE_FAILURE_ACTIONS((Pointer)object);
        return object;
    }

    public void setFailureActionsFlag(boolean bl) {
        Winsvc$SERVICE_FAILURE_ACTIONS_FLAG winsvc$SERVICE_FAILURE_ACTIONS_FLAG = new Winsvc$SERVICE_FAILURE_ACTIONS_FLAG();
        int n = new Winsvc$SERVICE_FAILURE_ACTIONS_FLAG().fFailureActionsOnNonCrashFailures = bl ? 1 : 0;
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 4, winsvc$SERVICE_FAILURE_ACTIONS_FLAG)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public boolean getFailureActionsFlag() {
        Object object = this.queryServiceConfig2(4);
        object = new Winsvc$SERVICE_FAILURE_ACTIONS_FLAG((Pointer)object);
        return object.fFailureActionsOnNonCrashFailures != 0;
    }

    public Winsvc$SERVICE_STATUS_PROCESS queryStatus() {
        Winsvc$SERVICE_STATUS_PROCESS winsvc$SERVICE_STATUS_PROCESS;
        IntByReference intByReference = new IntByReference();
        Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, null, 0, intByReference);
        Winsvc$SERVICE_STATUS_PROCESS winsvc$SERVICE_STATUS_PROCESS2 = winsvc$SERVICE_STATUS_PROCESS = new Winsvc$SERVICE_STATUS_PROCESS(intByReference.getValue());
        if (!Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, winsvc$SERVICE_STATUS_PROCESS2, winsvc$SERVICE_STATUS_PROCESS2.size(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winsvc$SERVICE_STATUS_PROCESS;
    }

    public void startService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.StartService(this._handle, 0, null)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to start the service");
        }
    }

    public void stopService() {
        this.stopService(30000L);
    }

    public void stopService(long l) {
        long l2 = System.currentTimeMillis();
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 1) {
            return;
        }
        Winsvc$SERVICE_STATUS winsvc$SERVICE_STATUS = new Winsvc$SERVICE_STATUS();
        if (!Advapi32.INSTANCE.ControlService(this._handle, 1, winsvc$SERVICE_STATUS)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        while (winsvc$SERVICE_STATUS.dwCurrentState != 1) {
            long l3 = l - (System.currentTimeMillis() - l2);
            if (l3 < 0L) {
                throw new RuntimeException(String.format("Service stop exceeded timeout time of %d ms", l));
            }
            long l4 = Math.min((long)this.sanitizeWaitTime(winsvc$SERVICE_STATUS.dwWaitHint), l3);
            try {
                Thread.sleep(l4);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            if (Advapi32.INSTANCE.QueryServiceStatus(this._handle, winsvc$SERVICE_STATUS)) continue;
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public void continueService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 3, new Winsvc$SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to continue the service");
        }
    }

    public void pauseService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 7) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 2, new Winsvc$SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 7) {
            throw new RuntimeException("Unable to pause the service");
        }
    }

    int sanitizeWaitTime(int n) {
        if ((n /= 10) < 1000) {
            n = 1000;
        } else if (n > 10000) {
            n = 10000;
        }
        return n;
    }

    public void waitForNonPendingState() {
        Winsvc$SERVICE_STATUS_PROCESS winsvc$SERVICE_STATUS_PROCESS = this.queryStatus();
        int n = winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint;
        int n2 = Kernel32.INSTANCE.GetTickCount();
        while (this.isPendingState(winsvc$SERVICE_STATUS_PROCESS.dwCurrentState)) {
            if (winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint != n) {
                n = winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint;
                n2 = Kernel32.INSTANCE.GetTickCount();
            }
            if (Kernel32.INSTANCE.GetTickCount() - n2 > winsvc$SERVICE_STATUS_PROCESS.dwWaitHint) {
                throw new RuntimeException("Timeout waiting for service to change to a non-pending state.");
            }
            int n3 = this.sanitizeWaitTime(winsvc$SERVICE_STATUS_PROCESS.dwWaitHint);
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            winsvc$SERVICE_STATUS_PROCESS = this.queryStatus();
        }
    }

    private boolean isPendingState(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Winsvc.SC_HANDLE getHandle() {
        return this._handle;
    }

    public Winsvc$ENUM_SERVICE_STATUS[] enumDependentServices(int n) {
        Memory memory;
        IntByReference intByReference = new IntByReference(0);
        IntByReference intByReference2 = new IntByReference(0);
        Advapi32.INSTANCE.EnumDependentServices(this._handle, n, Pointer.NULL, 0, intByReference, intByReference2);
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (n2 != 234) {
            throw new Win32Exception(n2);
        }
        Memory memory2 = memory = new Memory((long)intByReference.getValue());
        boolean bl = Advapi32.INSTANCE.EnumDependentServices(this._handle, n, (Pointer)memory2, (int)memory2.size(), intByReference, intByReference2);
        n = bl ? 1 : 0;
        if (!bl) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (intByReference2.getValue() == 0) {
            return new Winsvc$ENUM_SERVICE_STATUS[0];
        }
        Winsvc$ENUM_SERVICE_STATUS winsvc$ENUM_SERVICE_STATUS = (Winsvc$ENUM_SERVICE_STATUS)Structure.newInstance(Winsvc$ENUM_SERVICE_STATUS.class, (Pointer)memory);
        winsvc$ENUM_SERVICE_STATUS.read();
        return (Winsvc$ENUM_SERVICE_STATUS[])winsvc$ENUM_SERVICE_STATUS.toArray(intByReference2.getValue());
    }
}

