/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilder;
import kotlin.collections.builders.ListBuilder$BuilderSubList$Itr;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.SerializedCollection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00060\u0006j\u0002`\u0007:\u0001PBA\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J&\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u001d\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010%\u001a\u00020\u001bH\u0002J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0016J\u0014\u0010(\u001a\u00020\u00132\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0013\u0010+\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010,H\u0096\u0002J\u0016\u0010-\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u000bH\u0016J\u0015\u00100\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0013H\u0016J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00028\u000104H\u0096\u0002J\u0015\u00105\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00028\u000107H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00028\u0001072\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u00108\u001a\u00020\u001bH\u0002J\u0015\u00109\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010:\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0015\u0010;\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010.J\u0015\u0010<\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010.J\u0018\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0002J\u0016\u0010@\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J.\u0010A\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010B\u001a\u00020\u0013H\u0002J\u001e\u0010C\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010DJ\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010F\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020\u000bH\u0016J\u0015\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010,0\tH\u0016\u00a2\u0006\u0002\u0010IJ'\u0010H\u001a\b\u0012\u0004\u0012\u0002HJ0\t\"\u0004\b\u0002\u0010J2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\tH\u0016\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020,H\u0002R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006Q"}, d2={"Lkotlin/collections/builders/ListBuilder$BuilderSubList;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "backing", "", "offset", "", "length", "parent", "root", "Lkotlin/collections/builders/ListBuilder;", "([Ljava/lang/Object;IILkotlin/collections/builders/ListBuilder$BuilderSubList;Lkotlin/collections/builders/ListBuilder;)V", "[Ljava/lang/Object;", "isReadOnly", "", "()Z", "size", "getSize", "()I", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addAllInternal", "i", "n", "addAtInternal", "checkForComodification", "checkIsMutable", "clear", "contentEquals", "other", "", "equals", "", "get", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "registerModification", "remove", "removeAll", "removeAt", "removeAtInternal", "removeRangeInternal", "rangeOffset", "rangeLength", "retainAll", "retainOrRemoveAllInternal", "retain", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "toArray", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toString", "", "writeReplace", "Itr", "kotlin-stdlib"})
public final class ListBuilder$BuilderSubList<E>
extends AbstractMutableList<E>
implements Serializable,
List<E>,
RandomAccess,
KMutableList {
    private E[] backing;
    private final int offset;
    private int length;
    private final ListBuilder$BuilderSubList<E> parent;
    private final ListBuilder<E> root;

    public ListBuilder$BuilderSubList(E[] EArray, int n, int n2, ListBuilder$BuilderSubList<E> listBuilder$BuilderSubList, ListBuilder<E> listBuilder) {
        Intrinsics.checkNotNullParameter(EArray, "");
        Intrinsics.checkNotNullParameter(listBuilder, "");
        this.backing = EArray;
        this.offset = n;
        this.length = n2;
        this.parent = listBuilder$BuilderSubList;
        this.root = listBuilder;
        this.modCount = ListBuilder.access$getModCount$p$s-2084097795(this.root);
    }

    private final Object writeReplace() {
        if (this.isReadOnly()) {
            return new SerializedCollection(this, 0);
        }
        throw new NotSerializableException("The list cannot be serialized while it is being built.");
    }

    @Override
    public final int getSize() {
        this.checkForComodification();
        return this.length;
    }

    @Override
    public final boolean isEmpty() {
        this.checkForComodification();
        return this.length == 0;
    }

    @Override
    public final E get(int n) {
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        return this.backing[this.offset + n];
    }

    @Override
    public final E set(int n, E e) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        E e2 = this.backing[this.offset + n];
        this.backing[this.offset + n] = e;
        return e2;
    }

    @Override
    public final int indexOf(Object object) {
        this.checkForComodification();
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.backing[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        this.checkForComodification();
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.backing[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        return new ListBuilder$BuilderSubList$Itr(this, n);
    }

    @Override
    public final boolean add(E e) {
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        listBuilder$BuilderSubList.addAtInternal(listBuilder$BuilderSubList.offset + this.length, e);
        return true;
    }

    @Override
    public final void add(int n, E e) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        listBuilder$BuilderSubList.addAtInternal(listBuilder$BuilderSubList.offset + n, e);
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        int n = collection.size();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        listBuilder$BuilderSubList.addAllInternal(listBuilder$BuilderSubList.offset + this.length, collection, n);
        return n > 0;
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        int n2 = collection.size();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        listBuilder$BuilderSubList.addAllInternal(listBuilder$BuilderSubList.offset + n, collection, n2);
        return n2 > 0;
    }

    @Override
    public final void clear() {
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        listBuilder$BuilderSubList.removeRangeInternal(listBuilder$BuilderSubList.offset, this.length);
    }

    @Override
    public final E removeAt(int n) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        return listBuilder$BuilderSubList.removeAtInternal(listBuilder$BuilderSubList.offset + n);
    }

    @Override
    public final boolean remove(Object object) {
        this.checkIsMutable();
        this.checkForComodification();
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
        }
        return n >= 0;
    }

    @Override
    public final boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        return listBuilder$BuilderSubList.retainOrRemoveAllInternal(listBuilder$BuilderSubList.offset, this.length, collection, false) > 0;
    }

    @Override
    public final boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        this.checkIsMutable();
        this.checkForComodification();
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        return listBuilder$BuilderSubList.retainOrRemoveAllInternal(listBuilder$BuilderSubList.offset, this.length, collection, true) > 0;
    }

    @Override
    public final List<E> subList(int n, int n2) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this.length);
        ListBuilder$BuilderSubList listBuilder$BuilderSubList = this;
        return new ListBuilder$BuilderSubList<E>(this.backing, this.offset + n, n2 - n, listBuilder$BuilderSubList, listBuilder$BuilderSubList.root);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        this.checkForComodification();
        if (TArray.length < this.length) {
            T[] TArray2 = Arrays.copyOfRange(this.backing, this.offset, this.offset + this.length, TArray.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray2, "");
            return TArray2;
        }
        ArraysKt.copyInto(this.backing, TArray, 0, this.offset, this.offset + this.length);
        return CollectionsKt.terminateCollectionToArray(this.length, TArray);
    }

    @Override
    public final Object[] toArray() {
        this.checkForComodification();
        E[] EArray = this.backing;
        int n = this.offset;
        int n2 = this.offset + this.length;
        return ArraysKt.copyOfRange(EArray, n, n2);
    }

    @Override
    public final boolean equals(Object object) {
        this.checkForComodification();
        return object == this || object instanceof List && this.contentEquals((List)object);
    }

    @Override
    public final int hashCode() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentHashCode(this.backing, this.offset, this.length);
    }

    @Override
    public final String toString() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentToString(this.backing, this.offset, this.length, this);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    private final void checkForComodification() {
        if (ListBuilder.access$getModCount$p$s-2084097795(this.root) != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkIsMutable() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    private final boolean isReadOnly() {
        return ListBuilder.access$isReadOnly$p(this.root);
    }

    private final boolean contentEquals(List<?> list) {
        return ListBuilderKt.access$subarrayContentEquals(this.backing, this.offset, this.length, list);
    }

    private final void addAtInternal(int n, E e) {
        this.registerModification();
        if (this.parent != null) {
            super.addAtInternal(n, e);
        } else {
            ListBuilder.access$addAtInternal(this.root, n, e);
        }
        this.backing = ListBuilder.access$getBacking$p(this.root);
        n = this.length;
        this.length = n + 1;
    }

    private final void addAllInternal(int n, Collection<? extends E> collection, int n2) {
        this.registerModification();
        if (this.parent != null) {
            super.addAllInternal(n, collection, n2);
        } else {
            ListBuilder.access$addAllInternal(this.root, n, collection, n2);
        }
        this.backing = ListBuilder.access$getBacking$p(this.root);
        this.length += n2;
    }

    private final E removeAtInternal(int n) {
        this.registerModification();
        Object object = this.parent != null ? super.removeAtInternal(n) : ListBuilder.access$removeAtInternal(this.root, n);
        int n2 = this.length;
        this.length = n2 + -1;
        return object;
    }

    private final void removeRangeInternal(int n, int n2) {
        if (n2 > 0) {
            this.registerModification();
        }
        if (this.parent != null) {
            super.removeRangeInternal(n, n2);
        } else {
            ListBuilder.access$removeRangeInternal(this.root, n, n2);
        }
        this.length -= n2;
    }

    private final int retainOrRemoveAllInternal(int n, int n2, Collection<? extends E> collection, boolean bl) {
        n = this.parent != null ? super.retainOrRemoveAllInternal(n, n2, collection, bl) : ListBuilder.access$retainOrRemoveAllInternal(this.root, n, n2, collection, bl);
        if (n > 0) {
            this.registerModification();
        }
        this.length -= n;
        return n;
    }

    public static final /* synthetic */ int access$getModCount$p$s1462993667(ListBuilder$BuilderSubList listBuilder$BuilderSubList) {
        return listBuilder$BuilderSubList.modCount;
    }

    public static final /* synthetic */ int access$getLength$p(ListBuilder$BuilderSubList listBuilder$BuilderSubList) {
        return listBuilder$BuilderSubList.length;
    }

    public static final /* synthetic */ Object[] access$getBacking$p(ListBuilder$BuilderSubList listBuilder$BuilderSubList) {
        return listBuilder$BuilderSubList.backing;
    }

    public static final /* synthetic */ int access$getOffset$p(ListBuilder$BuilderSubList listBuilder$BuilderSubList) {
        return listBuilder$BuilderSubList.offset;
    }

    public static final /* synthetic */ ListBuilder access$getRoot$p(ListBuilder$BuilderSubList listBuilder$BuilderSubList) {
        return listBuilder$BuilderSubList.root;
    }
}

