/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.builders.ListBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\r\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0015\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlin/collections/builders/ListBuilder$Itr;", "E", "", "list", "Lkotlin/collections/builders/ListBuilder;", "index", "", "(Lkotlin/collections/builders/ListBuilder;I)V", "expectedModCount", "lastIndex", "add", "", "element", "(Ljava/lang/Object;)V", "checkForComodification", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "kotlin-stdlib"})
final class ListBuilder$Itr<E>
implements ListIterator<E>,
KMutableListIterator {
    private final ListBuilder<E> list;
    private int index;
    private int lastIndex;
    private int expectedModCount;

    public ListBuilder$Itr(ListBuilder<E> listBuilder, int n) {
        Intrinsics.checkNotNullParameter(listBuilder, "");
        this.list = listBuilder;
        this.index = n;
        this.lastIndex = -1;
        this.expectedModCount = ListBuilder.access$getModCount$p$s-2084097795(this.list);
    }

    @Override
    public final boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public final boolean hasNext() {
        return this.index < ListBuilder.access$getLength$p(this.list);
    }

    @Override
    public final int previousIndex() {
        return this.index - 1;
    }

    @Override
    public final int nextIndex() {
        return this.index;
    }

    @Override
    public final E previous() {
        this.checkForComodification();
        if (this.index <= 0) {
            throw new NoSuchElementException();
        }
        ListBuilder$Itr listBuilder$Itr = this;
        listBuilder$Itr.index = this.index + -1;
        listBuilder$Itr.lastIndex = this.index;
        return (E)ListBuilder.access$getBacking$p(this.list)[this.lastIndex];
    }

    @Override
    public final E next() {
        this.checkForComodification();
        if (this.index >= ListBuilder.access$getLength$p(this.list)) {
            throw new NoSuchElementException();
        }
        int n = this.index;
        this.index = n + 1;
        this.lastIndex = n;
        return (E)ListBuilder.access$getBacking$p(this.list)[this.lastIndex];
    }

    @Override
    public final void set(E object) {
        this.checkForComodification();
        boolean bl = this.lastIndex != -1;
        if (!bl) {
            object = "Call next() or previous() before replacing element from the iterator.";
            throw new IllegalStateException(object.toString());
        }
        this.list.set(this.lastIndex, object);
    }

    @Override
    public final void add(E e) {
        this.checkForComodification();
        int n = this.index;
        this.index = n + 1;
        this.list.add(n, e);
        this.lastIndex = -1;
        this.expectedModCount = ListBuilder.access$getModCount$p$s-2084097795(this.list);
    }

    @Override
    public final void remove() {
        this.checkForComodification();
        boolean bl = this.lastIndex != -1;
        if (!bl) {
            String string = "Call next() or previous() before removing element from the iterator.";
            throw new IllegalStateException(string.toString());
        }
        this.list.remove(this.lastIndex);
        this.index = this.lastIndex;
        this.lastIndex = -1;
        this.expectedModCount = ListBuilder.access$getModCount$p$s-2084097795(this.list);
    }

    private final void checkForComodification() {
        if (ListBuilder.access$getModCount$p$s-2084097795(this.list) != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

