/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.DefaultCopyActionContext;
import kotlin.io.path.ExceptionsCollector;
import kotlin.io.path.IllegalFileNameException;
import kotlin.io.path.LinkFollowing;
import kotlin.io.path.OnErrorResult;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathReadWriteKt;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$WhenMappings;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$copyToRecursively$1;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$copyToRecursively$2;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$copyToRecursively$3;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$copyToRecursively$4;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt$copyToRecursively$5;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000v\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0082\b\u00a2\u0006\u0002\b\u0006\u001a\u001d\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b\n\u001a'\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b\u000e\u001a&\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0005H\u0082\b\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\tH\u0000\u001a\u0019\u0010\u0014\u001a\u00020\u0001*\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0002\b\u0015\u001aw\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2Q\b\u0002\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0017\u0012\u0017\u0012\u00150\u001dj\u0002`\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0007\u001a\u00b4\u0001\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2Q\b\u0002\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0017\u0012\u0017\u0012\u00150\u001dj\u0002`\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u00192\u0006\u0010!\u001a\u00020\"2C\b\u0002\u0010$\u001a=\u0012\u0004\u0012\u00020%\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020&0\u0019\u00a2\u0006\u0002\b'H\u0007\u001a\f\u0010(\u001a\u00020\u0001*\u00020\tH\u0007\u001a\u001b\u0010)\u001a\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0**\u00020\tH\u0002\u00a2\u0006\u0002\b+\u001a'\u0010,\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0-2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b.\u001a1\u0010/\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0-2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b0\u001a5\u00101\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\t0-2\u0006\u00102\u001a\u00020\t2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020504\"\u000205H\u0002\u00a2\u0006\u0004\b6\u00107\u001a\u0011\u00108\u001a\u000209*\u00020&H\u0003\u00a2\u0006\u0002\b:\u001a\u0011\u00108\u001a\u000209*\u00020 H\u0003\u00a2\u0006\u0002\b:\u00a8\u0006;"}, d2={"collectIfThrows", "", "collector", "Lkotlin/io/path/ExceptionsCollector;", "function", "Lkotlin/Function0;", "collectIfThrows$PathsKt__PathRecursiveFunctionsKt", "insecureEnterDirectory", "path", "Ljava/nio/file/Path;", "insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt", "insecureHandleEntry", "entry", "parent", "insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt", "tryIgnoreNoSuchFileException", "R", "tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkFileName", "checkNotSameAs", "checkNotSameAs$PathsKt__PathRecursiveFunctionsKt", "copyToRecursively", "target", "onError", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "source", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "Lkotlin/io/path/OnErrorResult;", "followLinks", "", "overwrite", "copyAction", "Lkotlin/io/path/CopyActionContext;", "Lkotlin/io/path/CopyActionResult;", "Lkotlin/ExtensionFunctionType;", "deleteRecursively", "deleteRecursivelyImpl", "", "deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt", "enterDirectory", "Ljava/nio/file/SecureDirectoryStream;", "enterDirectory$PathsKt__PathRecursiveFunctionsKt", "handleEntry", "handleEntry$PathsKt__PathRecursiveFunctionsKt", "isDirectory", "entryName", "options", "", "Ljava/nio/file/LinkOption;", "isDirectory$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/SecureDirectoryStream;Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "toFileVisitResult", "Ljava/nio/file/FileVisitResult;", "toFileVisitResult$PathsKt__PathRecursiveFunctionsKt", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
class PathsKt__PathRecursiveFunctionsKt
extends PathsKt__PathReadWriteKt {
    public static final Path copyToRecursively(Path path, Path path2, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        Intrinsics.checkNotNullParameter(function3, "");
        if (bl2) {
            return PathsKt.copyToRecursively(path, path2, function3, bl, new PathsKt__PathRecursiveFunctionsKt$copyToRecursively$2(bl));
        }
        return PathsKt.copyToRecursively$default(path, path2, function3, bl, null, 8, null);
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = PathsKt__PathRecursiveFunctionsKt$copyToRecursively$1.INSTANCE;
        }
        return PathsKt.copyToRecursively(path, path2, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function3, bl, bl2);
    }

    public static final Path copyToRecursively(Path path, Path path2, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, boolean bl, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> function32) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        Intrinsics.checkNotNullParameter(function3, "");
        Intrinsics.checkNotNullParameter(function32, "");
        Path path3 = path;
        LinkOption[] linkOptionArray = LinkFollowing.INSTANCE.toLinkOptions(bl);
        linkOptionArray = Arrays.copyOf(linkOptionArray, linkOptionArray.length);
        if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new NoSuchFileException(((Object)path).toString(), ((Object)path2).toString(), "The source file doesn't exist.");
        }
        if (!(!Files.exists(path, Arrays.copyOf(new LinkOption[0], 0)) || !bl && Files.isSymbolicLink(path) || (bl2 = Files.exists(path2, Arrays.copyOf(new LinkOption[0], 0)) && !Files.isSymbolicLink(path2)) && Files.isSameFile(path, path2))) {
            boolean bl3;
            if (!Intrinsics.areEqual(path.getFileSystem(), path2.getFileSystem())) {
                bl3 = false;
            } else if (bl2) {
                bl3 = path2.toRealPath(new LinkOption[0]).startsWith(path.toRealPath(new LinkOption[0]));
            } else {
                Path path4 = path2.getParent();
                if (path4 != null) {
                    Path path5 = path4;
                    bl3 = Files.exists(path4, Arrays.copyOf(new LinkOption[0], 0)) && path5.toRealPath(new LinkOption[0]).startsWith(path.toRealPath(new LinkOption[0]));
                } else {
                    boolean bl4;
                    bl3 = bl4 = false;
                }
            }
            if (bl3) {
                throw new FileSystemException(((Object)path).toString(), ((Object)path2).toString(), "Recursively copying a directory into its subdirectory is prohibited.");
            }
        }
        path3 = path2.normalize();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        PathsKt.visitFileTree$default(path, 0, bl, new PathsKt__PathRecursiveFunctionsKt$copyToRecursively$5(arrayList, function32, path, path2, path3, function3), 1, null);
        return path2;
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, Function3 function32, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = PathsKt__PathRecursiveFunctionsKt$copyToRecursively$3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function32 = new PathsKt__PathRecursiveFunctionsKt$copyToRecursively$4(bl);
        }
        return PathsKt.copyToRecursively(path, path2, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function3, bl, function32);
    }

    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(CopyActionResult copyActionResult) {
        switch (PathsKt__PathRecursiveFunctionsKt$WhenMappings.$EnumSwitchMapping$0[copyActionResult.ordinal()]) {
            case 1: {
                return FileVisitResult.CONTINUE;
            }
            case 2: {
                return FileVisitResult.TERMINATE;
            }
            case 3: {
                return FileVisitResult.SKIP_SUBTREE;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(OnErrorResult onErrorResult) {
        switch (PathsKt__PathRecursiveFunctionsKt$WhenMappings.$EnumSwitchMapping$1[onErrorResult.ordinal()]) {
            case 1: {
                return FileVisitResult.TERMINATE;
            }
            case 2: {
                return FileVisitResult.SKIP_SUBTREE;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final void deleteRecursively(Path object) {
        Intrinsics.checkNotNullParameter(object, "");
        object = PathsKt__PathRecursiveFunctionsKt.deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt((Path)object);
        if (!((Collection)object).isEmpty()) {
            FileSystemException fileSystemException;
            FileSystemException fileSystemException2 = fileSystemException = new FileSystemException("Failed to delete one or more files. See suppressed exceptions for details.");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Exception)object2;
                ExceptionsKt.addSuppressed(fileSystemException2, (Throwable)object2);
            }
            throw (Throwable)fileSystemException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final List<Exception> deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt(Path path) {
        ExceptionsCollector exceptionsCollector = new ExceptionsCollector(0, 1, null);
        boolean bl = true;
        Path path2 = path.getParent();
        if (path2 != null) {
            void var4_6;
            Path path3 = path2;
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path3);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
            }
            void var4_7 = var4_6;
            if (var4_7 != null) {
                Closeable closeable = (Closeable)var4_7;
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    if (directoryStream instanceof SecureDirectoryStream) {
                        bl = false;
                        exceptionsCollector.setPath(path3);
                        SecureDirectoryStream secureDirectoryStream = (SecureDirectoryStream)directoryStream;
                        Path path4 = path.getFileName();
                        Intrinsics.checkNotNullExpressionValue(path4, "");
                        PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt(secureDirectoryStream, path4, null, exceptionsCollector);
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }
        if (bl) {
            PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(path, null, exceptionsCollector);
        }
        return exceptionsCollector.getCollectedExceptions();
    }

    private static final void collectIfThrows$PathsKt__PathRecursiveFunctionsKt(ExceptionsCollector exceptionsCollector, Function0<Unit> function0) {
        try {
            function0.invoke();
            return;
        }
        catch (Exception exception) {
            exceptionsCollector.collect(exception);
            return;
        }
    }

    private static final <R> R tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt(Function0<? extends R> function0) {
        try {
            function0 = function0.invoke();
        }
        catch (NoSuchFileException noSuchFileException) {
            function0 = null;
        }
        return (R)function0;
    }

    private static final void handleEntry$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> secureDirectoryStream, Path path, Path path2, ExceptionsCollector exceptionsCollector) {
        exceptionsCollector.enterEntry(path);
        try {
            LinkOption[] linkOptionArray;
            if (path2 != null) {
                LinkOption[] linkOptionArray2 = exceptionsCollector.getPath();
                Intrinsics.checkNotNull(linkOptionArray2);
                linkOptionArray = linkOptionArray2;
                PathsKt.checkFileName((Path)linkOptionArray2);
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt((Path)linkOptionArray, path2);
            }
            LinkOption[] linkOptionArray3 = new LinkOption[1];
            linkOptionArray = linkOptionArray3;
            linkOptionArray3[0] = LinkOption.NOFOLLOW_LINKS;
            if (PathsKt__PathRecursiveFunctionsKt.isDirectory$PathsKt__PathRecursiveFunctionsKt(secureDirectoryStream, path, linkOptionArray)) {
                int n = exceptionsCollector.getTotalExceptions();
                PathsKt__PathRecursiveFunctionsKt.enterDirectory$PathsKt__PathRecursiveFunctionsKt(secureDirectoryStream, path, exceptionsCollector);
                if (n == exceptionsCollector.getTotalExceptions()) {
                    try {
                        secureDirectoryStream.deleteDirectory(path);
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                }
            } else {
                try {
                    secureDirectoryStream.deleteFile(path);
                }
                catch (NoSuchFileException noSuchFileException) {}
            }
        }
        catch (Exception exception) {
            exceptionsCollector.collect(exception);
        }
        exceptionsCollector.exitEntry(path);
    }

    private static final void enterDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> closeable, Path object, ExceptionsCollector exceptionsCollector) {
        block11: {
            try {
                Object object2;
                try {
                    LinkOption[] linkOptionArray = new LinkOption[1];
                    object2 = linkOptionArray;
                    linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
                    closeable = closeable.newDirectoryStream(object, (LinkOption)object2);
                }
                catch (NoSuchFileException noSuchFileException) {
                    closeable = null;
                }
                if (closeable != null) {
                    object = null;
                    try {
                        object2 = (SecureDirectoryStream)closeable;
                        for (Path path : object2) {
                            Path path2 = path.getFileName();
                            Intrinsics.checkNotNullExpressionValue(path2, "");
                            PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt((SecureDirectoryStream<Path>)object2, path2, exceptionsCollector.getPath(), exceptionsCollector);
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        object = throwable;
                        throw object2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, (Throwable)object);
                    }
                }
                return;
            }
            catch (Exception exception) {
                exceptionsCollector.collect(exception);
            }
        }
    }

    private static final boolean isDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> object, Path path, LinkOption ... linkOptionArray) {
        try {
            object = object.getFileAttributeView((Path)path, BasicFileAttributeView.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length)).readAttributes().isDirectory();
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        SecureDirectoryStream<Path> secureDirectoryStream = object;
        if (secureDirectoryStream != null) {
            return (Boolean)((Object)secureDirectoryStream);
        }
        return false;
    }

    private static final void insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, ExceptionsCollector exceptionsCollector) {
        try {
            block5: {
                block4: {
                    block3: {
                        if (path2 != null) {
                            PathsKt.checkFileName(path);
                            PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(path, path2);
                        }
                        path2 = path;
                        LinkOption[] linkOptionArray = new LinkOption[1];
                        LinkOption[] linkOptionArray2 = linkOptionArray;
                        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
                        if (!Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, 1))) break block3;
                        int n = exceptionsCollector.getTotalExceptions();
                        PathsKt__PathRecursiveFunctionsKt.insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(path, exceptionsCollector);
                        if (n != exceptionsCollector.getTotalExceptions()) break block4;
                        break block5;
                    }
                    Files.deleteIfExists(path);
                }
                return;
            }
            Files.deleteIfExists(path);
        }
        catch (Exception exception) {
            exceptionsCollector.collect(exception);
        }
    }

    private static final void insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(Path path, ExceptionsCollector exceptionsCollector) {
        block11: {
            try {
                Iterator iterator2;
                try {
                    iterator2 = Files.newDirectoryStream(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                    iterator2 = null;
                }
                Closeable closeable = iterator2;
                if (closeable != null) {
                    closeable = closeable;
                    Throwable throwable = null;
                    try {
                        iterator2 = closeable;
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            Path path2 = (Path)iterator2.next();
                            Intrinsics.checkNotNull(path2);
                            PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(path2, path, exceptionsCollector);
                        }
                        break block11;
                    }
                    catch (Throwable throwable2) {
                        iterator2 = throwable2;
                        throwable = throwable2;
                        throw iterator2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                return;
            }
            catch (Exception exception) {
                exceptionsCollector.collect(exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkFileName(Path path) {
        Intrinsics.checkNotNullParameter(path, "");
        String string = PathsKt.getName(path);
        switch (string.hashCode()) {
            case 1472: {
                if (string.equals("..")) throw new IllegalFileNameException(path);
                return;
            }
            case 1473: {
                if (string.equals("./")) throw new IllegalFileNameException(path);
                return;
            }
            case 45724: {
                if (string.equals("..\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 46: {
                if (string.equals(".")) throw new IllegalFileNameException(path);
                return;
            }
            case 1518: {
                if (string.equals(".\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 45679: {
                if (!string.equals("../")) return;
                throw new IllegalFileNameException(path);
            }
        }
    }

    private static final void checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2) {
        if (!Files.isSymbolicLink(path) && Files.isSameFile(path, path2)) {
            throw new FileSystemLoopException(((Object)path).toString());
        }
    }

    private static final Path copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, Path path3, Path path4) {
        path = PathsKt.relativeTo(path4, path);
        if (!(path = path2.resolve(((Object)path).toString())).normalize().startsWith(path3)) {
            throw new IllegalFileNameException(path4, path, "Copying files to outside the specified target directory is prohibited. The directory being recursively copied might contain an entry with an illegal name.");
        }
        Intrinsics.checkNotNull(path);
        return path;
    }

    private static final FileVisitResult copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, Path path, Path path2, Path path3, Path path4, Exception exception) {
        return PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(function3.invoke(path4, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(path, path2, path3, path4), exception));
    }

    private static final FileVisitResult copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(ArrayList<Path> object, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> function3, Path path, Path path2, Path path3, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function32, Path path4, BasicFileAttributes basicFileAttributes) {
        try {
            if (!((Collection)object).isEmpty()) {
                PathsKt.checkFileName(path4);
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(path4, (Path)CollectionsKt.last((List)object));
            }
            object = PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(function3.invoke(DefaultCopyActionContext.INSTANCE, path4, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(path, path2, path3, path4)));
        }
        catch (Exception exception) {
            object = PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(function32, path, path2, path3, path4, exception);
        }
        return object;
    }

    public static final /* synthetic */ FileVisitResult access$copyToRecursively$copy(ArrayList arrayList, Function3 function3, Path path, Path path2, Path path3, Function3 function32, Path path4, BasicFileAttributes basicFileAttributes) {
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(arrayList, function3, path, path2, path3, function32, path4, basicFileAttributes);
    }

    public static final /* synthetic */ FileVisitResult access$copyToRecursively$error(Function3 function3, Path path, Path path2, Path path3, Path path4, Exception exception) {
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(function3, path, path2, path3, path4, exception);
    }
}

