/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.MatcherMatchResult;
import kotlin.text.Regex$Companion;
import kotlin.text.Regex$Serialized;
import kotlin.text.Regex$findAll$1;
import kotlin.text.Regex$findAll$2;
import kotlin.text.Regex$special$$inlined$fromInt$1;
import kotlin.text.Regex$splitToSequence$1;
import kotlin.text.RegexKt;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 02\u00060\u0001j\u0002`\u0002:\u000201B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0001\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001bH\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0011\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001bH\u0007J\"\u0010#\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170%J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010'\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0004J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020\u001bJ \u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020\u001bH\u0007J\u0006\u0010,\u001a\u00020\rJ\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020/H\u0002R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lkotlin/text/Regex;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "pattern", "", "(Ljava/lang/String;)V", "option", "Lkotlin/text/RegexOption;", "(Ljava/lang/String;Lkotlin/text/RegexOption;)V", "options", "", "(Ljava/lang/String;Ljava/util/Set;)V", "nativePattern", "Ljava/util/regex/Pattern;", "(Ljava/util/regex/Pattern;)V", "_options", "getOptions", "()Ljava/util/Set;", "getPattern", "()Ljava/lang/String;", "containsMatchIn", "", "input", "", "find", "Lkotlin/text/MatchResult;", "startIndex", "", "findAll", "Lkotlin/sequences/Sequence;", "matchAt", "index", "matchEntire", "matches", "matchesAt", "replace", "transform", "Lkotlin/Function1;", "replacement", "replaceFirst", "split", "", "limit", "splitToSequence", "toPattern", "toString", "writeReplace", "", "Companion", "Serialized", "kotlin-stdlib"})
public final class Regex
implements Serializable {
    public static final Regex$Companion Companion = new Regex$Companion(null);
    private final Pattern nativePattern;
    private Set<? extends RegexOption> _options;

    public Regex(Pattern pattern) {
        Intrinsics.checkNotNullParameter(pattern, "");
        this.nativePattern = pattern;
    }

    public Regex(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        Pattern pattern = Pattern.compile(string);
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(String string, RegexOption regexOption) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(regexOption, "");
        Pattern pattern = Pattern.compile(string, Regex$Companion.access$ensureUnicodeCase(Companion, regexOption.getValue()));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(String string, Set<? extends RegexOption> set) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(set, "");
        Pattern pattern = Pattern.compile(string, Regex$Companion.access$ensureUnicodeCase(Companion, RegexKt.access$toInt(set)));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public final String getPattern() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final Set<RegexOption> getOptions() {
        Set<RegexOption> set = this._options;
        if (set == null) {
            Set<RegexOption> set2;
            int n = this.nativePattern.flags();
            EnumSet<RegexOption> enumSet = set2 = EnumSet.allOf(RegexOption.class);
            Intrinsics.checkNotNull(set2);
            CollectionsKt.retainAll((Iterable)enumSet, (Function1)new Regex$special$$inlined$fromInt$1(n));
            Set set3 = Collections.unmodifiableSet((Set)set2);
            Intrinsics.checkNotNullExpressionValue(set3, "");
            Set set4 = set3;
            set2 = set3;
            this._options = set2;
            set = set4;
        }
        return set;
    }

    public final boolean matches(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).matches();
    }

    public final boolean containsMatchIn(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).find();
    }

    public final MatchResult find(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$findNext(matcher, n, charSequence);
    }

    public static /* synthetic */ MatchResult find$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.find(charSequence, n);
    }

    public final Sequence<MatchResult> findAll(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        if (n < 0 || n > charSequence.length()) {
            throw new IndexOutOfBoundsException("Start index out of bounds: " + n + ", input length: " + charSequence.length());
        }
        return SequencesKt.generateSequence(new Regex$findAll$1(this, charSequence, n), (Function1)Regex$findAll$2.INSTANCE);
    }

    public static /* synthetic */ Sequence findAll$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.findAll(charSequence, n);
    }

    public final MatchResult matchEntire(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$matchEntire(matcher, charSequence);
    }

    public final MatchResult matchAt(CharSequence charSequence, int n) {
        MatcherMatchResult matcherMatchResult;
        Matcher matcher;
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher2 = this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length());
        matcher2 = matcher2;
        if (matcher.lookingAt()) {
            Intrinsics.checkNotNull(matcher2);
            matcherMatchResult = new MatcherMatchResult(matcher2, charSequence);
        } else {
            matcherMatchResult = null;
        }
        return matcherMatchResult;
    }

    public final boolean matchesAt(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length()).lookingAt();
    }

    public final String replace(CharSequence charSequence, String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceAll(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public final String replace(CharSequence charSequence, Function1<? super MatchResult, ? extends CharSequence> function1) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(function1, "");
        MatchResult matchResult = Regex.find$default(this, charSequence, 0, 2, null);
        if (matchResult == null) {
            return ((Object)charSequence).toString();
        }
        MatchResult matchResult2 = matchResult;
        int n = 0;
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        do {
            stringBuilder.append(charSequence, n, (int)matchResult2.getRange().getStart());
            stringBuilder.append(function1.invoke(matchResult2));
            n = matchResult2.getRange().getEndInclusive() + 1;
            matchResult2 = matchResult2.next();
        } while (n < n2 && matchResult2 != null);
        if (n < n2) {
            stringBuilder.append(charSequence, n, n2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final String replaceFirst(CharSequence charSequence, String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceFirst(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public final List<String> split(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n);
        Matcher matcher = this.nativePattern.matcher(charSequence);
        if (n == 1 || !matcher.find()) {
            return CollectionsKt.listOf(((Object)charSequence).toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>(n > 0 ? RangesKt.coerceAtMost(n, 10) : 10);
        int n2 = 0;
        --n;
        do {
            arrayList.add(((Object)charSequence.subSequence(n2, matcher.start())).toString());
            n2 = matcher.end();
        } while ((n < 0 || arrayList.size() != n) && matcher.find());
        arrayList.add(((Object)charSequence.subSequence(n2, charSequence.length())).toString());
        return arrayList;
    }

    public static /* synthetic */ List split$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.split(charSequence, n);
    }

    public final Sequence<String> splitToSequence(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n);
        return SequencesKt.sequence(new Regex$splitToSequence$1(this, charSequence, n, null));
    }

    public static /* synthetic */ Sequence splitToSequence$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.splitToSequence(charSequence, n);
    }

    public final String toString() {
        String string = this.nativePattern.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final Pattern toPattern() {
        return this.nativePattern;
    }

    private final Object writeReplace() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return new Regex$Serialized(string, this.nativePattern.flags());
    }

    public static final /* synthetic */ Pattern access$getNativePattern$p(Regex regex) {
        return regex.nativePattern;
    }
}

