/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.PoolUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackKeyedObjectPool<K, V>
extends BaseKeyedObjectPool<K, V>
implements KeyedObjectPool<K, V> {
    @Deprecated
    private HashMap<K, Stack<V>> a = null;
    @Deprecated
    private KeyedPoolableObjectFactory<K, V> b = null;
    @Deprecated
    private int c = 8;
    @Deprecated
    private int d = 4;
    @Deprecated
    private int e = 0;
    @Deprecated
    private int f = 0;
    @Deprecated
    private HashMap<K, Integer> g = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, int n2) {
        this.b = keyedPoolableObjectFactory;
        this.c = n < 0 ? 8 : n;
        this.d = n2 <= 0 ? 4 : n2;
        this.a = new HashMap();
        this.g = new HashMap();
    }

    @Override
    public final synchronized V d(K object) {
        Object object2;
        this.f();
        Stack<Object> stack = this.a.get(object);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this.d > this.c ? this.c : this.d);
            this.a.put(object, stack);
        }
        do {
            boolean bl = false;
            if (!stack.empty()) {
                object2 = stack.pop();
                --this.f;
            } else {
                if (this.b == null) {
                    throw new NoSuchElementException("pools without a factory cannot create new objects as needed.");
                }
                object2 = this.b.a(object);
                bl = true;
            }
            if (this.b == null || object2 == null) continue;
            try {
                this.b.c(object, object2);
                if (!this.b.b(object, object2)) {
                    throw new Exception("ValidateObject failed");
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                PoolUtils.a(throwable);
                try {
                    this.b.a(object, object2);
                    object2 = null;
                }
                catch (Throwable throwable3) {
                    object2 = throwable3;
                    PoolUtils.a(throwable3);
                    object2 = null;
                }
                if (!bl) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + throwable2.getMessage());
            }
        } while (object2 == null);
        stack = object;
        object = this;
        ++((StackKeyedObjectPool)object).e;
        Integer n = ((StackKeyedObjectPool)object).g.get(stack);
        if (n == null) {
            ((StackKeyedObjectPool)object).g.put(stack, 1);
        } else {
            ((StackKeyedObjectPool)object).g.put(stack, new Integer(n + 1));
        }
        return (V)object2;
    }

    @Override
    public final synchronized void a(K k, V v) {
        int n;
        this.e(k);
        if (this.b != null) {
            if (this.b.b(k, v)) {
                try {
                    this.b.d(k, v);
                }
                catch (Exception exception) {
                    this.b.a(k, v);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.e()) {
            if (this.b != null) {
                try {
                    this.b.a(k, v);
                    return;
                }
                catch (Exception exception) {}
            }
            return;
        }
        Stack<Object> stack = this.a.get(k);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this.d > this.c ? this.c : this.d);
            this.a.put(k, stack);
        }
        if ((n = stack.size()) >= this.c) {
            Object object;
            if (n > 0) {
                object = stack.remove(0);
                --this.f;
            } else {
                object = v;
            }
            if (this.b != null) {
                try {
                    this.b.a(k, object);
                }
                catch (Exception exception) {}
            }
        }
        stack.push(v);
        ++this.f;
    }

    @Override
    public final synchronized void b(K k, V v) {
        this.e(k);
        if (this.b != null) {
            this.b.a(k, v);
        }
        this.notifyAll();
    }

    @Override
    public final synchronized void a(K k) {
        int n;
        this.f();
        if (this.b == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        V v = this.b.a(k);
        try {
            if (!this.b.b(k, v)) {
                return;
            }
        }
        catch (Exception exception) {
            try {
                this.b.a(k, v);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
        this.b.d(k, v);
        Stack<Object> stack = this.a.get(k);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this.d > this.c ? this.c : this.d);
            this.a.put(k, stack);
        }
        if ((n = stack.size()) >= this.c) {
            if (n > 0) {
                stack = stack.remove(0);
                --this.f;
            } else {
                stack = v;
            }
            try {
                this.b.a(k, stack);
            }
            catch (Exception exception) {
                if (v == stack) {
                    throw exception;
                }
                return;
            }
        } else {
            stack.push(v);
            ++this.f;
        }
    }

    @Override
    public final synchronized int a() {
        return this.f;
    }

    @Override
    public final synchronized int b() {
        return this.e;
    }

    @Override
    public final synchronized int b(K k) {
        try {
            return this.a.get(k).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public final synchronized void c() {
        for (K k : this.a.keySet()) {
            Stack<V> stack = this.a.get(k);
            this.a(k, stack);
        }
        this.f = 0;
        this.a.clear();
        this.g.clear();
    }

    @Override
    public final synchronized void c(K k) {
        Stack<V> stack = this.a.remove(k);
        this.a(k, stack);
    }

    @Override
    private synchronized void a(K k, Stack<V> stack) {
        if (stack == null) {
            return;
        }
        if (this.b != null) {
            Iterator iterator = stack.iterator();
            while (iterator.hasNext()) {
                try {
                    this.b.a(k, iterator.next());
                }
                catch (Exception exception) {}
            }
        }
        this.f -= stack.size();
        this.g.remove(k);
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" contains ").append(this.a.size()).append(" distinct pools: ");
        for (Object object : this.a.keySet()) {
            stringBuffer.append(" |").append(object).append("|=");
            object = this.a.get(object);
            stringBuffer.append(((Vector)object).size());
        }
        return stringBuffer.toString();
    }

    @Override
    public final void d() {
        super.d();
        this.c();
    }

    @Override
    @Deprecated
    public final synchronized void a(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) {
        if (0 < this.b()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.c();
        this.b = keyedPoolableObjectFactory;
    }

    private void e(K k) {
        --this.e;
        Integer n = this.g.get(k);
        if (n == null) {
            return;
        }
        if (n <= 1) {
            this.g.remove(k);
            return;
        }
        this.g.put(k, new Integer(n - 1));
    }
}

