/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.date.DateParser;
import org.sqlite.date.FastDateParser$1;
import org.sqlite.date.FastDateParser$2;
import org.sqlite.date.FastDateParser$3;
import org.sqlite.date.FastDateParser$4;
import org.sqlite.date.FastDateParser$CaseInsensitiveTextStrategy;
import org.sqlite.date.FastDateParser$CopyQuotedStrategy;
import org.sqlite.date.FastDateParser$ISO8601TimeZoneStrategy;
import org.sqlite.date.FastDateParser$NumberStrategy;
import org.sqlite.date.FastDateParser$Strategy;
import org.sqlite.date.FastDateParser$TimeZoneStrategy;

public class FastDateParser
implements Serializable,
DateParser {
    private static final long serialVersionUID = 2L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient Pattern parsePattern;
    private transient FastDateParser$Strategy[] strategies;
    private transient String currentFormatField;
    private transient FastDateParser$Strategy nextStrategy;
    private static final Pattern formatPattern = Pattern.compile("D+|E+|F+|G+|H+|K+|M+|S+|W+|X+|Z+|a+|d+|h+|k+|m+|s+|w+|y+|z+|''|'[^']++(''[^']*+)*+'|[^'A-Za-z]++");
    private static final ConcurrentMap<Locale, FastDateParser$Strategy>[] caches = new ConcurrentMap[17];
    private static final FastDateParser$Strategy ABBREVIATED_YEAR_STRATEGY = new FastDateParser$1(1);
    private static final FastDateParser$Strategy NUMBER_MONTH_STRATEGY = new FastDateParser$2(2);
    private static final FastDateParser$Strategy LITERAL_YEAR_STRATEGY = new FastDateParser$NumberStrategy(1);
    private static final FastDateParser$Strategy WEEK_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(3);
    private static final FastDateParser$Strategy WEEK_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(4);
    private static final FastDateParser$Strategy DAY_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(6);
    private static final FastDateParser$Strategy DAY_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(5);
    private static final FastDateParser$Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new FastDateParser$NumberStrategy(8);
    private static final FastDateParser$Strategy HOUR_OF_DAY_STRATEGY = new FastDateParser$NumberStrategy(11);
    private static final FastDateParser$Strategy HOUR24_OF_DAY_STRATEGY = new FastDateParser$3(11);
    private static final FastDateParser$Strategy HOUR12_STRATEGY = new FastDateParser$4(10);
    private static final FastDateParser$Strategy HOUR_STRATEGY = new FastDateParser$NumberStrategy(10);
    private static final FastDateParser$Strategy MINUTE_STRATEGY = new FastDateParser$NumberStrategy(12);
    private static final FastDateParser$Strategy SECOND_STRATEGY = new FastDateParser$NumberStrategy(13);
    private static final FastDateParser$Strategy MILLISECOND_STRATEGY = new FastDateParser$NumberStrategy(14);
    private static final FastDateParser$Strategy ISO_8601_STRATEGY = new FastDateParser$ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::?\\d{2})?))");

    protected FastDateParser(String string, TimeZone timeZone, Locale locale) {
        this(string, timeZone, locale, null);
    }

    protected FastDateParser(String object, TimeZone timeZone, Locale locale, Date date) {
        int n;
        this.pattern = object;
        this.timeZone = timeZone;
        this.locale = locale;
        object = Calendar.getInstance(timeZone, locale);
        if (date != null) {
            ((Calendar)object).setTime(date);
            n = ((Calendar)object).get(1);
        } else if (locale.equals(JAPANESE_IMPERIAL)) {
            n = 0;
        } else {
            ((Calendar)object).setTime(new Date());
            n = ((Calendar)object).get(1) - 80;
        }
        this.century = n / 100 * 100;
        this.startYear = n - this.century;
        this.init((Calendar)object);
    }

    private void init(Calendar calendar) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<FastDateParser$Strategy> arrayList = new ArrayList<FastDateParser$Strategy>();
        Matcher matcher = formatPattern.matcher(this.pattern);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("Illegal pattern character '" + this.pattern.charAt(matcher.regionStart()) + "'");
        }
        this.currentFormatField = matcher.group();
        FastDateParser fastDateParser = this;
        FastDateParser$Strategy fastDateParser$Strategy = fastDateParser.getStrategy(fastDateParser.currentFormatField, calendar);
        while (true) {
            Matcher matcher2 = matcher;
            matcher2.region(matcher2.end(), matcher.regionEnd());
            if (!matcher.lookingAt()) break;
            String string = matcher.group();
            this.nextStrategy = this.getStrategy(string, calendar);
            if (fastDateParser$Strategy.addRegex(this, stringBuilder)) {
                arrayList.add(fastDateParser$Strategy);
            }
            this.currentFormatField = string;
            fastDateParser$Strategy = this.nextStrategy;
        }
        this.nextStrategy = null;
        if (matcher.regionStart() != matcher.regionEnd()) {
            throw new IllegalArgumentException("Failed to parse \"" + this.pattern + "\" ; gave up at index " + matcher.regionStart());
        }
        if (fastDateParser$Strategy.addRegex(this, stringBuilder)) {
            arrayList.add(fastDateParser$Strategy);
        }
        this.currentFormatField = null;
        ArrayList<FastDateParser$Strategy> arrayList2 = arrayList;
        this.strategies = arrayList2.toArray(new FastDateParser$Strategy[arrayList2.size()]);
        this.parsePattern = Pattern.compile(stringBuilder.toString());
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    Pattern getParsePattern() {
        return this.parsePattern;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateParser)) {
            return false;
        }
        object = (FastDateParser)object;
        return this.pattern.equals(((FastDateParser)object).pattern) && this.timeZone.equals(((FastDateParser)object).timeZone) && this.locale.equals(((FastDateParser)object).locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream object) {
        ((ObjectInputStream)object).defaultReadObject();
        object = Calendar.getInstance(this.timeZone, this.locale);
        this.init((Calendar)object);
    }

    @Override
    public Object parseObject(String string) {
        return this.parse(string);
    }

    @Override
    public Date parse(String string) {
        Date date = this.parse(string = string.length() == 19 ? string + ".000" : string, new ParsePosition(0));
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + string + "\" does not match " + this.parsePattern.pattern(), 0);
            }
            throw new ParseException("Unparseable date: \"" + string + "\" does not match " + this.parsePattern.pattern(), 0);
        }
        return date;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Date parse(String object, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        if (!((Matcher)(object = this.parsePattern.matcher(((String)object).substring(n)))).lookingAt()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        int n2 = 0;
        while (n2 < this.strategies.length) {
            FastDateParser$Strategy fastDateParser$Strategy = this.strategies[n2++];
            fastDateParser$Strategy.setCalendar(this, calendar, ((Matcher)object).group(n2));
        }
        parsePosition.setIndex(n + ((Matcher)object).end());
        return calendar.getTime();
    }

    private static StringBuilder escapeRegex(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append("\\Q");
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            switch (n) {
                case 39: {
                    if (!bl) break;
                    if (++i == string.length()) {
                        return stringBuilder;
                    }
                    n = string.charAt(i);
                    break;
                }
                case 92: {
                    if (++i == string.length()) break;
                    stringBuilder.append((char)n);
                    n = string.charAt(i);
                    if (n != 69) break;
                    stringBuilder.append("E\\\\E\\");
                    n = 81;
                }
            }
            stringBuilder.append((char)n);
        }
        stringBuilder.append("\\E");
        return stringBuilder;
    }

    private static Map<String, Integer> getDisplayNames(int n, Calendar calendar, Locale locale) {
        return calendar.getDisplayNames(n, 0, locale);
    }

    private int adjustYear(int n) {
        int n2 = this.century + n;
        if (n >= this.startYear) {
            return n2;
        }
        return n2 + 100;
    }

    boolean isNextNumber() {
        return this.nextStrategy != null && this.nextStrategy.isNumber();
    }

    int getFieldWidth() {
        return this.currentFormatField.length();
    }

    private FastDateParser$Strategy getStrategy(String string, Calendar calendar) {
        switch (string.charAt(0)) {
            case '\'': {
                if (string.length() > 2) {
                    return new FastDateParser$CopyQuotedStrategy(string.substring(1, string.length() - 1));
                }
            }
            default: {
                return new FastDateParser$CopyQuotedStrategy(string);
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                if (string.length() >= 3) {
                    return this.getLocaleSpecificStrategy(2, calendar);
                }
                return NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'y': {
                if (string.length() > 2) {
                    return LITERAL_YEAR_STRATEGY;
                }
                return ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return FastDateParser$ISO8601TimeZoneStrategy.getStrategy(string.length());
            }
            case 'Z': {
                if (!string.equals("ZZ")) break;
                return ISO_8601_STRATEGY;
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    private static ConcurrentMap<Locale, FastDateParser$Strategy> getCache(int n) {
        ConcurrentMap<Locale, FastDateParser$Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            if (caches[n] == null) {
                FastDateParser.caches[n] = new ConcurrentHashMap<Locale, FastDateParser$Strategy>(3);
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return caches[n];
        }
    }

    private FastDateParser$Strategy getLocaleSpecificStrategy(int n, Calendar calendar) {
        FastDateParser$Strategy fastDateParser$Strategy;
        ConcurrentMap<Locale, FastDateParser$Strategy> concurrentMap = FastDateParser.getCache(n);
        FastDateParser$Strategy fastDateParser$Strategy2 = (FastDateParser$Strategy)concurrentMap.get(this.locale);
        if (fastDateParser$Strategy2 == null && (fastDateParser$Strategy = concurrentMap.putIfAbsent(this.locale, fastDateParser$Strategy2 = n == 15 ? new FastDateParser$TimeZoneStrategy(this.locale) : new FastDateParser$CaseInsensitiveTextStrategy(n, calendar, this.locale))) != null) {
            return fastDateParser$Strategy;
        }
        return fastDateParser$Strategy2;
    }

    static /* synthetic */ StringBuilder access$100(StringBuilder stringBuilder, String string, boolean bl) {
        return FastDateParser.escapeRegex(stringBuilder, string, bl);
    }

    static /* synthetic */ Map access$200(int n, Calendar calendar, Locale locale) {
        return FastDateParser.getDisplayNames(n, calendar, locale);
    }

    static /* synthetic */ int access$300(FastDateParser fastDateParser, int n) {
        return fastDateParser.adjustYear(n);
    }
}

