/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;

public abstract class JDBC3ResultSet
extends CoreResultSet {
    protected static final Pattern COLUMN_TYPENAME = Pattern.compile("([^\\(]*)");
    protected static final Pattern COLUMN_TYPECAST = Pattern.compile("cast\\(.*?\\s+as\\s+(.*?)\\s*\\)");
    protected static final Pattern COLUMN_PRECISION = Pattern.compile(".*?\\((.*?)\\)");

    protected JDBC3ResultSet(CoreStatement coreStatement) {
        super(coreStatement);
    }

    public int findColumn(String string) {
        this.checkOpen();
        Integer n = this.findColumnIndexInCache(string);
        if (n != null) {
            return n;
        }
        for (int i = 0; i < this.cols.length; ++i) {
            if (!string.equalsIgnoreCase(this.cols[i])) continue;
            return this.addColumnIndexInCache(string, i + 1);
        }
        throw new SQLException("no such column: '" + string + "'");
    }

    public boolean next() {
        if (!this.open || this.emptyResultSet || this.pastLastRow) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 0) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0L && (long)this.row == this.maxRows) {
            return false;
        }
        int n = this.stmt.pointer.safeRunInt(DB::step);
        switch (n) {
            case 101: {
                this.pastLastRow = true;
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
        }
        this.getDatabase().throwex(n);
        return false;
    }

    public int getType() {
        return 1003;
    }

    public int getFetchSize() {
        return this.limitRows;
    }

    public void setFetchSize(int n) {
        if (n < 0 || this.maxRows != 0L && (long)n > this.maxRows) {
            throw new SQLException("fetch size " + n + " out of bounds " + this.maxRows);
        }
        this.limitRows = n;
    }

    public int getFetchDirection() {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int n) {
        this.checkOpen();
        if (n != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() {
        return this.pastLastRow && !this.emptyResultSet;
    }

    public boolean isBeforeFirst() {
        return !this.emptyResultSet && this.open && this.row == 0;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isLast() {
        throw new SQLFeatureNotSupportedException("not supported by sqlite");
    }

    public int getRow() {
        return this.row;
    }

    public boolean wasNull() {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(this.lastCol)) == 5;
    }

    public BigDecimal getBigDecimal(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol(n))) {
            case 5: {
                return null;
            }
            case 1: {
                return BigDecimal.valueOf(this.safeGetLongCol(n));
            }
        }
        String string = this.safeGetColumnText(n);
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad value for type BigDecimal : " + string);
        }
    }

    public BigDecimal getBigDecimal(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBigDecimal(jDBC3ResultSet.findColumn(string));
    }

    public boolean getBoolean(int n) {
        return this.getInt(n) != 0;
    }

    public boolean getBoolean(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBoolean(jDBC3ResultSet.findColumn(string));
    }

    public InputStream getBinaryStream(int n) {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public InputStream getBinaryStream(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBinaryStream(jDBC3ResultSet.findColumn(string));
    }

    public byte getByte(int n) {
        return (byte)this.getInt(n);
    }

    public byte getByte(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getByte(jDBC3ResultSet.findColumn(string));
    }

    public byte[] getBytes(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_blob(l, this.markCol(n)));
    }

    public byte[] getBytes(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBytes(jDBC3ResultSet.findColumn(string));
    }

    public Reader getCharacterStream(int n) {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getCharacterStream(jDBC3ResultSet.findColumn(string));
    }

    public Date getDate(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Date(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing date", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Date(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Date(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Date getDate(int n, Calendar cloneable) {
        this.requireCalendarNotNull((Calendar)cloneable);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    cloneable = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), ((Calendar)cloneable).getTimeZone());
                    return new Date(((FastDateFormat)cloneable).parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Date(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n), (Calendar)cloneable).getTimeInMillis());
            }
        }
        ((Calendar)cloneable).setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Date(((Calendar)cloneable).getTime().getTime());
    }

    public Date getDate(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDate(jDBC3ResultSet.findColumn(string), Calendar.getInstance());
    }

    public Date getDate(String string, Calendar calendar) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDate(jDBC3ResultSet.findColumn(string), calendar);
    }

    public double getDouble(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        if (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n)) == 5) {
            return 0.0;
        }
        return this.safeGetDoubleCol(n);
    }

    public double getDouble(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDouble(jDBC3ResultSet.findColumn(string));
    }

    public float getFloat(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        if (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n)) == 5) {
            return 0.0f;
        }
        return (float)this.safeGetDoubleCol(n);
    }

    public float getFloat(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getFloat(jDBC3ResultSet.findColumn(string));
    }

    public int getInt(int n) {
        return this.stmt.pointer.safeRunInt((dB, l) -> dB.column_int(l, this.markCol(n)));
    }

    public int getInt(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getInt(jDBC3ResultSet.findColumn(string));
    }

    public long getLong(int n) {
        return this.safeGetLongCol(n);
    }

    public long getLong(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getLong(jDBC3ResultSet.findColumn(string));
    }

    public short getShort(int n) {
        return (short)this.getInt(n);
    }

    public short getShort(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getShort(jDBC3ResultSet.findColumn(string));
    }

    public String getString(int n) {
        return this.safeGetColumnText(n);
    }

    public String getString(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getString(jDBC3ResultSet.findColumn(string));
    }

    public Time getTime(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Time(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Time(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Time(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Time getTime(int n, Calendar cloneable) {
        this.requireCalendarNotNull((Calendar)cloneable);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    cloneable = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), ((Calendar)cloneable).getTimeZone());
                    return new Time(((FastDateFormat)cloneable).parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Time(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n), (Calendar)cloneable).getTimeInMillis());
            }
        }
        ((Calendar)cloneable).setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Time(((Calendar)cloneable).getTime().getTime());
    }

    public Time getTime(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTime(jDBC3ResultSet.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTime(jDBC3ResultSet.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Timestamp(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Timestamp(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Timestamp(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Timestamp getTimestamp(int n, Calendar cloneable) {
        this.requireCalendarNotNull((Calendar)cloneable);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    cloneable = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), ((Calendar)cloneable).getTimeZone());
                    return new Timestamp(((FastDateFormat)cloneable).parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Timestamp(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        ((Calendar)cloneable).setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Timestamp(((Calendar)cloneable).getTime().getTime());
    }

    public Timestamp getTimestamp(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTimestamp(jDBC3ResultSet.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTimestamp(jDBC3ResultSet.findColumn(string), calendar);
    }

    public Object getObject(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 1: {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return new Long(l);
                }
                return new Integer((int)l);
            }
            case 2: {
                return new Double(this.getDouble(n));
            }
            case 4: {
                return this.getBytes(n);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getObject(jDBC3ResultSet.findColumn(string));
    }

    public Statement getStatement() {
        return (Statement)((Object)this.stmt);
    }

    public String getCursorName() {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this);
    }

    public String getCatalogName(int n) {
        return this.safeGetColumnTableName(n);
    }

    public String getColumnClassName(int n) {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(n))) {
            case 1: {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return "java.lang.Long";
                }
                return "java.lang.Integer";
            }
            case 2: {
                return "java.lang.Double";
            }
            case 4: 
            case 5: {
                return "java.lang.Object";
            }
        }
        return "java.lang.String";
    }

    public int getColumnCount() {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int n) {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int n) {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) {
        return this.safeGetColumnName(n);
    }

    public int getColumnType(int n) {
        String string = this.getColumnTypeName(n);
        JDBC3ResultSet jDBC3ResultSet = this;
        int n2 = jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol(n));
        if (n2 == 1 || n2 == 5) {
            if ("BOOLEAN".equals(string)) {
                return 16;
            }
            if ("TINYINT".equals(string)) {
                return -6;
            }
            if ("SMALLINT".equals(string) || "INT2".equals(string)) {
                return 5;
            }
            if ("BIGINT".equals(string) || "INT8".equals(string) || "UNSIGNED BIG INT".equals(string)) {
                return -5;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if ("TIMESTAMP".equals(string)) {
                return 93;
            }
            if (n2 == 1 || "INT".equals(string) || "INTEGER".equals(string) || "MEDIUMINT".equals(string)) {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return -5;
                }
                return 4;
            }
        }
        if (n2 == 2 || n2 == 5) {
            if ("DECIMAL".equals(string)) {
                return 3;
            }
            if ("DOUBLE".equals(string) || "DOUBLE PRECISION".equals(string)) {
                return 8;
            }
            if ("NUMERIC".equals(string)) {
                return 2;
            }
            if ("REAL".equals(string)) {
                return 7;
            }
            if (n2 == 2 || "FLOAT".equals(string)) {
                return 6;
            }
        }
        if (n2 == 3 || n2 == 5) {
            if ("CHARACTER".equals(string) || "NCHAR".equals(string) || "NATIVE CHARACTER".equals(string) || "CHAR".equals(string)) {
                return 1;
            }
            if ("CLOB".equals(string)) {
                return 2005;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if ("TIMESTAMP".equals(string)) {
                return 93;
            }
            if (n2 == 3 || "VARCHAR".equals(string) || "VARYING CHARACTER".equals(string) || "NVARCHAR".equals(string) || "TEXT".equals(string)) {
                return 12;
            }
        }
        if (n2 == 4 || n2 == 5) {
            if ("BINARY".equals(string)) {
                return -2;
            }
            if (n2 == 4 || "BLOB".equals(string)) {
                return 2004;
            }
        }
        return 2;
    }

    public String getColumnTypeName(int n) {
        String string = this.getColumnDeclType(n);
        if (string != null) {
            Matcher matcher = COLUMN_TYPENAME.matcher(string);
            matcher.find();
            return matcher.group(1).toUpperCase(Locale.ENGLISH);
        }
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol(n))) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 4: {
                return "BLOB";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "NUMERIC";
    }

    public int getPrecision(int n) {
        Object object = this.getColumnDeclType(n);
        if (object != null) {
            if (((Matcher)(object = COLUMN_PRECISION.matcher((CharSequence)object))).find()) {
                return Integer.parseInt(((Matcher)object).group(1).split(",")[0].trim());
            }
            return 0;
        }
        return 0;
    }

    private String getColumnDeclType(int n) {
        String string = this.stmt.pointer.safeRun((dB, l) -> dB.column_decltype(l, this.checkCol(n)));
        if (string == null) {
            Matcher matcher = COLUMN_TYPECAST.matcher(this.safeGetColumnName(n));
            string = matcher.find() ? matcher.group(1) : null;
        }
        return string;
    }

    public int getScale(int n) {
        Object object = this.getColumnDeclType(n);
        if (object != null && (object = COLUMN_PRECISION.matcher((CharSequence)object)).find() && ((String[])(object = object.group(1).split(","))).length == 2) {
            return Integer.parseInt(object[1].trim());
        }
        return 0;
    }

    public String getSchemaName(int n) {
        return "";
    }

    public String getTableName(int n) {
        String string = this.safeGetColumnTableName(n);
        if (string == null) {
            return "";
        }
        return string;
    }

    public int isNullable(int n) {
        this.checkMeta();
        if (this.meta[this.checkCol(n)][0]) {
            return 0;
        }
        return 1;
    }

    public boolean isAutoIncrement(int n) {
        this.checkMeta();
        return this.meta[this.checkCol(n)][2];
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isCurrency(int n) {
        return false;
    }

    public boolean isDefinitelyWritable(int n) {
        return true;
    }

    public boolean isReadOnly(int n) {
        return false;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isSigned(int n) {
        String string = this.getColumnTypeName(n);
        return "NUMERIC".equals(string) || "INTEGER".equals(string) || "REAL".equals(string);
    }

    public boolean isWritable(int n) {
        return true;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    private Calendar julianDateToCalendar(Double d) {
        return this.julianDateToCalendar(d, Calendar.getInstance());
    }

    private Calendar julianDateToCalendar(Double d, Calendar calendar) {
        int n;
        if (d == null) {
            return null;
        }
        double d2 = d + 0.5;
        int n2 = (int)d2;
        double d3 = d2 - (double)n2;
        if (n2 >= 2299161) {
            n = (int)(((double)n2 - 1867216.25) / 36524.25);
            n2 = n2 + 1 + n - (int)((double)n / 4.0);
        }
        n = n2 + 1524;
        n2 = (int)(((double)n - 122.1) / 365.25);
        int n3 = (int)(365.25 * (double)n2);
        int n4 = (int)((double)(n - n3) / 30.6001);
        int n5 = n4 - ((double)n4 < 13.5 ? 1 : 13);
        n2 -= (double)n5 > 2.5 ? 4716 : 4715;
        double d4 = (double)(n - n3 - (int)(30.6001 * (double)n4)) + d3;
        n = (int)d4;
        double d5 = d4 - (double)n;
        n3 = (int)(d5 * 24.0);
        double d6 = d5 * 24.0 - (double)n3;
        n4 = (int)(d6 * 60.0);
        double d7 = d6 * 60.0 - (double)n4;
        int n6 = (int)(d7 * 60.0);
        double d8 = d7 * 60.0 - (double)n6;
        int n7 = (int)(d8 * 1000.0);
        calendar.set(n2, n5 - 1, n, n3, n4, n6);
        calendar.set(14, n7);
        if (n2 <= 0) {
            calendar.set(0, 0);
            calendar.set(1, -(n2 - 1));
        }
        return calendar;
    }

    private void requireCalendarNotNull(Calendar calendar) {
        if (calendar == null) {
            throw new SQLException("Expected a calendar instance.", new IllegalArgumentException());
        }
    }

    protected int safeGetColumnType(int n) {
        return this.stmt.pointer.safeRunInt((dB, l) -> dB.column_type(l, n));
    }

    private long safeGetLongCol(int n) {
        return this.stmt.pointer.safeRunLong((dB, l) -> dB.column_long(l, this.markCol(n)));
    }

    private double safeGetDoubleCol(int n) {
        return this.stmt.pointer.safeRunDouble((dB, l) -> dB.column_double(l, this.markCol(n)));
    }

    private String safeGetColumnText(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_text(l, this.markCol(n)));
    }

    private String safeGetColumnTableName(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_table_name(l, this.checkCol(n)));
    }

    private String safeGetColumnName(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_name(l, this.checkCol(n)));
    }
}

