/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.RRect$Companion;
import org.jetbrains.skia.RRectKt;
import org.jetbrains.skia.Rect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skia/RRect;", "Lorg/jetbrains/skia/Rect;", "l", "", "t", "r", "b", "radii", "", "(FFFF[F)V", "getRadii", "()[F", "equals", "", "other", "", "hashCode", "", "inflate", "spread", "toString", "", "Companion", "skiko"})
public final class RRect
extends Rect {
    public static final RRect$Companion Companion = new RRect$Companion(null);
    private final float[] radii;

    public RRect(float f, float f2, float f3, float f4, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        super(f, f2, f3, f4);
        this.radii = fArray;
    }

    public final float[] getRadii() {
        return this.radii;
    }

    @Override
    public final Rect inflate(float f) {
        int n = 1;
        int n2 = this.radii.length;
        for (int i = 0; i < n2; ++i) {
            if (!(this.radii[i] + f >= 0.0f)) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            return Rect.Companion.makeLTRB(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f));
        }
        float[] fArray = Arrays.copyOf(this.radii, this.radii.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        float[] fArray2 = fArray;
        n = fArray2.length;
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n2] = Math.max(0.0f, fArray2[n2] + f);
        }
        return new RRect(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f), fArray2);
    }

    @Override
    public final String toString() {
        return "RRect(_left=" + this.getLeft() + ", _top=" + this.getTop() + ", _right=" + this.getRight() + ", _bottom=" + this.getBottom() + ", _radii=" + ArraysKt.joinToString$default((float[])this.radii, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RRect)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.radii.length == ((RRect)object).radii.length) {
            return Arrays.equals(this.radii, ((RRect)object).radii);
        }
        return Arrays.equals(RRectKt.access$normalizeRadii(this.radii), RRectKt.access$normalizeRadii(((RRect)object).radii));
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 59 + Arrays.hashCode(this.radii);
        return n;
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5) {
        return Companion.makeLTRB(f, f2, f3, f4, f5);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeNinePatchLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeNinePatchLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeComplexLTRB(float f, float f2, float f3, float f4, float[] fArray) {
        return Companion.makeComplexLTRB(f, f2, f3, f4, fArray);
    }
}

