/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.Rect$Companion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "isEmpty", "", "()Z", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "other", "hashCode", "", "inflate", "spread", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "scale", "sx", "sy", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "toIRect", "Lorg/jetbrains/skia/IRect;", "toString", "", "Companion", "skiko"})
public class Rect {
    public static final Rect$Companion Companion = new Rect$Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    public Rect(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    public final Rect intersect(Rect rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"");
        if (this.right <= rect2.left || rect2.right <= this.left || this.bottom <= rect2.top || rect2.bottom <= this.top) {
            return null;
        }
        return new Rect(Math.max(this.left, rect2.left), Math.max(this.top, rect2.top), Math.min(this.right, rect2.right), Math.min(this.bottom, rect2.bottom));
    }

    public final Rect scale(float f) {
        float f2 = f;
        return this.scale(f2, f2);
    }

    public final Rect scale(float f, float f2) {
        return new Rect(this.left * f, this.top * f2, this.right * f, this.bottom * f2);
    }

    public final Rect offset(float f, float f2) {
        return new Rect(this.left + f, this.top + f2, this.right + f, this.bottom + f2);
    }

    public final Rect offset(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        return this.offset(point.getX(), point.getY());
    }

    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    public Rect inflate(float f) {
        if (f <= 0.0f) {
            return Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f));
        }
        return RRect.Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f), f);
    }

    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[4];
        float[] fArray2 = fArray;
        fArray[0] = this.left;
        fArray2[1] = this.top;
        fArray2[2] = this.right;
        fArray2[3] = this.bottom;
        return fArray2;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)object).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)object).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)object).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)object).bottom) == 0;
    }

    public int hashCode() {
        int n = 59 + Float.floatToIntBits(this.left);
        n = n * 59 + Float.floatToIntBits(this.top);
        n = n * 59 + Float.floatToIntBits(this.right);
        n = n * 59 + Float.floatToIntBits(this.bottom);
        return n;
    }

    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    @JvmStatic
    public static final Rect makeLTRB(float f, float f2, float f3, float f4) {
        return Companion.makeLTRB(f, f2, f3, f4);
    }

    @JvmStatic
    public static final Rect makeWH(float f, float f2) {
        return Companion.makeWH(f, f2);
    }

    @JvmStatic
    public static final Rect makeWH(Point point) {
        return Companion.makeWH(point);
    }

    @JvmStatic
    public static final Rect makeXYWH(float f, float f2, float f3, float f4) {
        return Companion.makeXYWH(f, f2, f3, f4);
    }
}

